/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.trajectorypreview.client;

import dev.buildtool.trajectorypreview.client.BasicPlugin;
import dev.buildtool.trajectorypreview.client.IntegerColor;
import dev.buildtool.trajectorypreview.client.PreviewEntity;
import dev.buildtool.trajectorypreview.client.PreviewProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class TrajectoryPreviewClient
implements ClientModInitializer {
    static boolean state = true;
    static Logger logger = LogManager.getLogger((String)"Trajectory preview");

    public void onInitializeClient() {
        class_304 toggle = KeyBindingHelper.registerKeyBinding((class_304)new class_304("trajectory_preview.toggle", 72, "Trajectory preview"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (toggle.method_1436()) {
                state = !state;
            }
        });
        File config = new File(FabricLoader.getInstance().getConfigDir().toString(), "trajectory-preview.properties");
        Properties properties = new Properties();
        if (config.exists()) {
            try (FileInputStream inputStream = new FileInputStream(config);){
                properties.load(inputStream);
            }
            catch (IOException e) {
                logger.error("Couldn't read configuration file", (Throwable)e);
            }
        }
        String oddPointColor = (String)properties.computeIfAbsent("odd-point-color", (Function<? super Object, ?>)((Function<Object, Object>)o -> "75aaff"));
        String evenPointColor = (String)properties.computeIfAbsent("even-point-color", (Function<? super Object, ?>)((Function<Object, Object>)o -> "DB3402"));
        try (FileOutputStream outputStream = new FileOutputStream(config);){
            properties.store(outputStream, "");
        }
        catch (IOException e) {
            logger.error("Couldn't save configuration file", (Throwable)e);
        }
        Set<BasicPlugin> previewProviders = Collections.singleton(new BasicPlugin());
        HudRenderCallback.EVENT.register((matrixStack, tickDelta) -> {
            if (state) {
                class_310 minecraftClient = class_310.method_1551();
                class_702 particleManager = minecraftClient.field_1713;
                class_746 player = minecraftClient.field_1724;
                if (player != null) {
                    class_1937 world = player.method_37908();
                    TrajectoryPreviewClient.drawPreview(player.method_6047(), previewProviders, (class_1657)player, world, oddPointColor, evenPointColor, particleManager);
                    TrajectoryPreviewClient.drawPreview(player.method_6079(), previewProviders, (class_1657)player, world, oddPointColor, evenPointColor, particleManager);
                }
            }
        });
    }

    private static void drawPreview(class_1799 mainStack, Set<PreviewProvider> previewProviders, class_1657 player, class_1937 world, String oddPointColor, String evenPointColor, class_702 particleManager) {
        class_1792 item = mainStack.method_7909();
        if (!mainStack.method_7960()) {
            for (PreviewProvider previewProvider : previewProviders) {
                Class<? extends PreviewEntity<? extends class_1297>> previewClass = previewProvider.getPreviewEntityFor(player, item);
                if (previewClass == null) continue;
                try {
                    PreviewEntity<? extends class_1297> previewEntity = previewClass.getConstructor(class_1937.class).newInstance(world);
                    List<? extends class_1297> targets = previewEntity.initializeEntities(player, mainStack);
                    if (targets == null) break;
                    for (class_1297 class_12972 : targets) {
                        previewEntity = previewClass.getConstructor(class_1937.class).newInstance(world);
                        class_1297 preview = (class_1297)previewEntity;
                        preview.method_33574(class_12972.method_19538());
                        preview.method_18799(class_12972.method_18798());
                        preview.method_36457(class_12972.method_36455());
                        preview.method_36456(class_12972.method_36454());
                        world.method_8649(preview);
                        ArrayList<class_243> trajectory = new ArrayList<class_243>(128);
                        int cycle = 0;
                        while (preview.method_5805()) {
                            previewEntity.simulateShot((class_1297)class_12972);
                            class_243 newPoint = new class_243(preview.method_23317(), preview.method_23318(), preview.method_23321());
                            if (Math.sqrt(player.method_5707(newPoint)) > 2.0) {
                                trajectory.add(newPoint);
                            }
                            if ((cycle = (int)((short)(cycle + 1))) <= 512) continue;
                            break;
                        }
                        IntegerColor first = new IntegerColor(Integer.parseInt(oddPointColor, 16));
                        IntegerColor second = new IntegerColor(Integer.parseInt(evenPointColor, 16));
                        for (class_243 vec3 : trajectory) {
                            double distanceFromPlayer = Math.sqrt(player.method_5707(vec3));
                            class_243 end = (class_243)trajectory.get(trajectory.size() - 1);
                            double totalDistance = Math.sqrt(player.method_5707(end));
                            double pointScale = distanceFromPlayer / totalDistance;
                            class_703 particle = particleManager.method_3056((class_2394)class_2398.field_11207, vec3.field_1352, vec3.field_1351, vec3.field_1350, 0.0, 0.0, 0.0);
                            if (particle == null) continue;
                            if (trajectory.indexOf(vec3) % 2 == 0) {
                                particle.method_3084(first.getRed(), first.getGreen(), first.getBlue());
                            } else {
                                particle.method_3084(second.getRed(), second.getGreen(), second.getBlue());
                            }
                            particle.method_3087((float)pointScale);
                            particle.method_3085();
                        }
                    }
                    break;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }
}

