/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.util;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.extend.CrashReportSectionExtender;
import com.bawnorton.neruina.platform.Platform;
import com.bawnorton.neruina.util.Reflection;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9813;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

public final class TickingEntry {
    private final Supplier<@Nullable Object> causeSupplier;
    private final boolean persitent;
    private final class_5321<class_1937> dimension;
    private final class_2338 pos;
    private final Throwable error;
    private final UUID uuid;
    private String cachedCauseType;
    private String cachedCauseName;
    private UUID cachedEntityUuid;
    private final List<String> blacklistedModids = List.of("neruina", "minecraft", "forge", "neoforge");

    public TickingEntry(Object cause, boolean persitent, class_5321<class_1937> dimension, class_2338 pos, Throwable error) {
        this.causeSupplier = () -> cause;
        this.persitent = persitent;
        this.dimension = dimension;
        this.pos = pos;
        this.error = error;
        this.uuid = UUID.randomUUID();
        this.update();
    }

    private TickingEntry(Supplier<@Nullable Object> causeSupplier, boolean persitent, class_5321<class_1937> dimension, class_2338 pos, UUID uuid, Throwable error) {
        this.causeSupplier = causeSupplier;
        this.persitent = persitent;
        this.dimension = dimension;
        this.pos = pos;
        this.uuid = uuid;
        this.error = error;
    }

    public void populate(class_129 section) {
        section.method_578("Message", (Object)this.error.getMessage());
        ((CrashReportSectionExtender)section).neruin$setStacktrace(this.error);
        Object cause = this.getCause();
        if (cause instanceof class_1297) {
            class_1297 entity = (class_1297)cause;
            entity.method_5819(section);
        } else if (cause instanceof class_2586) {
            class_2586 blockEntity = (class_2586)cause;
            blockEntity.method_11003(section);
        } else if (cause instanceof class_2680) {
            class_2680 state = (class_2680)cause;
            section.method_578("Position", (Object)this.pos);
            section.method_578("BlockState", (Object)state);
        } else if (cause instanceof class_1799) {
            class_1799 stack = (class_1799)cause;
            section.method_578("ItemStack", (Object)stack);
        } else {
            section.method_578("Errored", (Object)"Unknown");
        }
    }

    public String createCrashReport() {
        class_128 report = new class_128("Ticking %s".formatted(this.getCauseType()), this.error);
        class_129 section = report.method_562("Source: %s".formatted(this.getCauseName()));
        this.populate(section);
        return report.method_60920(class_9813.field_52181);
    }

    public Object getCause() {
        return this.causeSupplier.get();
    }

    public void update() {
        Object cause = this.causeSupplier.get();
        if (cause instanceof class_1297) {
            class_1297 entity = (class_1297)cause;
            this.cachedCauseType = Type.ENTITY.type;
            this.cachedCauseName = Type.ENTITY.nameFunction.apply(entity);
        } else if (cause instanceof class_2586) {
            class_2586 blockEntity = (class_2586)cause;
            this.cachedCauseType = Type.BLOCK_ENTITY.type;
            this.cachedCauseName = Type.BLOCK_ENTITY.nameFunction.apply(blockEntity);
        } else if (cause instanceof class_2680) {
            class_2680 state = (class_2680)cause;
            this.cachedCauseType = Type.BLOCK_STATE.type;
            this.cachedCauseName = Type.BLOCK_STATE.nameFunction.apply(state);
        } else if (cause instanceof class_1799) {
            class_1799 stack = (class_1799)cause;
            this.cachedCauseType = Type.ITEM_STACK.type;
            this.cachedCauseName = Type.ITEM_STACK.nameFunction.apply(stack);
        } else {
            this.cachedCauseType = Type.UNKNOWN.type;
            this.cachedCauseName = Type.UNKNOWN.nameFunction.apply(cause);
        }
    }

    public String getCauseType() {
        return this.cachedCauseType;
    }

    public String getCauseName() {
        return this.cachedCauseName;
    }

    public Set<String> findPotentialSources() {
        StackTraceElement[] stackTrace = this.error.getStackTrace();
        HashSet<String> modids = new HashSet<String>();
        for (StackTraceElement element : stackTrace) {
            URL resource;
            String modidFromResource;
            Class<?> clazz;
            try {
                clazz = Class.forName(element.getClassName());
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
            String methodName = element.getMethodName();
            String modid = this.checkForMixin(clazz, methodName);
            if (modid != null) {
                modids.add(modid);
                continue;
            }
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null || (modidFromResource = TickingEntry.modidFromResource(resource = codeSource.getLocation())) == null) continue;
            modids.add(modidFromResource);
        }
        this.blacklistedModids.forEach(modids::remove);
        return modids;
    }

    @Nullable
    private String checkForMixin(Class<?> clazz, String methodName) {
        Method method = Reflection.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        if (!method.isAnnotationPresent(MixinMerged.class)) {
            return null;
        }
        MixinMerged annotation = method.getAnnotation(MixinMerged.class);
        String mixinClassName = annotation.mixin();
        ClassLoader classLoader = clazz.getClassLoader();
        URL resource = classLoader.getResource(mixinClassName.replace('.', '/') + ".class");
        if (resource == null) {
            return null;
        }
        return TickingEntry.modidFromResource(resource);
    }

    @Nullable
    private static String modidFromResource(URL resource) {
        String location = resource.getPath();
        int index = location.indexOf("jar");
        if (index != -1) {
            location = location.substring(0, index + "jar".length());
            String[] parts = location.split("/");
            String jarName = parts[parts.length - 1];
            return Platform.modidFromJar(jarName);
        }
        return null;
    }

    public class_2487 writeNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("causeType", this.getCauseType());
        nbt.method_10582("causeName", this.getCauseName());
        nbt.method_10582("uuid", this.uuid.toString());
        nbt.method_10582("dimension", this.dimension.method_29177().toString());
        nbt.method_10544("pos", this.pos.method_10063());
        this.writeStackTraceNbt(nbt);
        try {
            if (this.getCauseType().equals(Type.ENTITY.type)) {
                if (this.cachedEntityUuid != null) {
                    nbt.method_25927("entityUuid", this.cachedEntityUuid);
                } else {
                    Object object = this.getCause();
                    if (object instanceof class_1297) {
                        class_1297 entity = (class_1297)object;
                        this.cachedEntityUuid = entity.method_5667();
                        nbt.method_25927("entityUuid", this.cachedEntityUuid);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            Neruina.LOGGER.warn("Failed to find entity UUID when serializing TickingEntry", (Throwable)e);
        }
        return nbt;
    }

    private void writeStackTraceNbt(class_2487 nbt) {
        nbt.method_10582("message", this.nonNullString(this.error.getMessage()));
        nbt.method_10582("exception", this.error.getClass().getName());
        class_2499 stacktrace = new class_2499();
        for (StackTraceElement element : this.error.getStackTrace()) {
            class_2487 elementNbt = new class_2487();
            this.writeElementNbt(elementNbt, element);
            stacktrace.add((Object)elementNbt);
        }
        nbt.method_10566("stacktrace", (class_2520)stacktrace);
    }

    private void writeElementNbt(class_2487 elementNbt, StackTraceElement element) {
        elementNbt.method_10582("classLoaderName", this.nonNullString(element.getClassLoaderName()));
        elementNbt.method_10582("moduleName", this.nonNullString(element.getModuleName()));
        elementNbt.method_10582("moduleVersion", this.nonNullString(element.getModuleVersion()));
        elementNbt.method_10582("declaringClass", this.nonNullString(element.getClassName()));
        elementNbt.method_10582("methodName", this.nonNullString(element.getMethodName()));
        elementNbt.method_10582("fileName", this.nonNullString(element.getFileName()));
        elementNbt.method_10569("lineNumber", element.getLineNumber());
    }

    private String nonNullString(String str) {
        return str == null ? "" : str;
    }

    public static TickingEntry fromNbt(class_3218 world, class_2487 nbtCompound) {
        String causeType = nbtCompound.method_10558("causeType");
        String causeName = nbtCompound.method_10558("causeName");
        UUID uuid = nbtCompound.method_25926("uuid");
        String dimensionStr = nbtCompound.method_10558("dimension");
        class_5321 dimension = dimensionStr != null ? class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)dimensionStr)) : class_1937.field_25179;
        class_2338 pos = class_2338.method_10092((long)nbtCompound.method_10537("pos"));
        Throwable error = TickingEntry.readStackTraceNbt(nbtCompound);
        Supplier<Object> cause = () -> null;
        UUID entityUuid = null;
        if (causeType.equals(Type.ENTITY.type)) {
            if (nbtCompound.method_10545("entityUuid")) {
                UUID finalEntityUuid = entityUuid = nbtCompound.method_25926("entityUuid");
                cause = () -> world.method_14190(finalEntityUuid);
            }
        } else if (causeType.equals(Type.BLOCK_ENTITY.type)) {
            cause = () -> world.method_8321(pos);
        } else if (causeType.equals(Type.BLOCK_STATE.type)) {
            cause = () -> world.method_8320(pos);
        }
        TickingEntry entry = new TickingEntry(cause, true, (class_5321<class_1937>)dimension, pos, uuid, error);
        entry.cachedCauseType = causeType;
        entry.cachedCauseName = causeName;
        entry.cachedEntityUuid = entityUuid;
        return entry;
    }

    private static Throwable readStackTraceNbt(class_2487 nbtCompound) {
        String message = nbtCompound.method_10558("message");
        String exceptionClass = nbtCompound.method_10558("exception");
        class_2499 stacktrace = nbtCompound.method_10554("stacktrace", 10);
        StackTraceElement[] elements = new StackTraceElement[stacktrace.size()];
        for (int i = 0; i < stacktrace.size(); ++i) {
            String moduleVersion;
            String moduleName;
            class_2520 nbtElement = stacktrace.method_10534(i);
            class_2487 compound = (class_2487)nbtElement;
            String classLoaderName = compound.method_10558("classLoaderName");
            if (classLoaderName.isEmpty()) {
                classLoaderName = null;
            }
            if ((moduleName = compound.method_10558("moduleName")).isEmpty()) {
                moduleName = null;
            }
            if ((moduleVersion = compound.method_10558("moduleVersion")).isEmpty()) {
                moduleVersion = null;
            }
            String declaringClass = compound.method_10558("declaringClass");
            String methodName = compound.method_10558("methodName");
            String fileName = compound.method_10558("fileName");
            if (fileName.isEmpty()) {
                fileName = null;
            }
            int lineNumber = compound.method_10550("lineNumber");
            elements[i] = new StackTraceElement(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNumber);
        }
        return TickingEntry.createThrowable(message, exceptionClass, elements);
    }

    private static Throwable createThrowable(String message, String exceptionClass, StackTraceElement[] elements) {
        try {
            Class<?> clazz = Class.forName(exceptionClass);
            Throwable throwable = (Throwable)clazz.getConstructor(String.class).newInstance(message);
            throwable.setStackTrace(elements);
            return throwable;
        }
        catch (Exception e) {
            Throwable throwable = new Throwable(message);
            throwable.setStackTrace(elements);
            return throwable;
        }
    }

    public class_5321<class_1937> dimension() {
        return this.dimension;
    }

    public class_2338 pos() {
        return this.pos;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public Throwable error() {
        return this.error;
    }

    public boolean isPersitent() {
        return this.persitent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TickingEntry that = (TickingEntry)obj;
        return Objects.equals(this.cachedCauseName, that.cachedCauseName) && Objects.equals(this.cachedCauseType, that.cachedCauseType) && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.pos, that.pos) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.cachedCauseType, this.cachedCauseName, this.dimension, this.pos, this.uuid, this.error);
    }

    public String toString() {
        return "TickingEntry[causeType=%s, causeName=%s, dimension=%s pos=%s, uuid=%s, error=%s]".formatted(this.cachedCauseType, this.cachedCauseName, this.dimension, this.pos, this.uuid, this.error);
    }

    private record Type<T>(String type, Function<T, String> nameFunction) {
        static final Type<class_1297> ENTITY = new Type<class_1297>("Entity", entity -> entity.method_5477().getString());
        static final Type<class_2586> BLOCK_ENTITY = new Type<class_2586>("BlockEntity", blockEntity -> blockEntity.method_11010().method_26204().method_9518().getString());
        static final Type<class_2680> BLOCK_STATE = new Type<class_2680>("BlockState", blockState -> blockState.method_26204().method_9518().getString());
        static final Type<class_1799> ITEM_STACK = new Type<class_1799>("ItemStack", itemStack -> itemStack.method_7909().method_7848().getString());
        static final Type<Object> UNKNOWN = new Type<Object>("Unknown", object -> "Unknown");
    }
}

