/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.blacklist;

import com.bawnorton.neruina.util.ErroredType;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_2960;

public final class Blacklist {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(class_2960.class, (Object)new TypeAdapter<Object>(){

        public void write(JsonWriter out, Object value) throws IOException {
            if (value instanceof class_2960) {
                class_2960 id = (class_2960)value;
                out.value(id.toString());
            } else if (value == null) {
                out.nullValue();
            }
        }

        public Object read(JsonReader in) throws IOException {
            String value = in.nextString();
            class_2960 identifier = class_2960.method_12829((String)value);
            if (identifier == null) {
                throw new IOException("Invalid Identifier: " + value);
            }
            return identifier;
        }
    }).create();
    private List<String> namespaces;
    private List<class_2960> entities;
    private List<class_2960> blocks;
    private List<class_2960> blockEntities;
    private List<class_2960> items;

    public Blacklist(List<String> namespaces, List<class_2960> entities, List<class_2960> blocks, List<class_2960> blockEntities, List<class_2960> items) {
        this.namespaces = namespaces;
        this.entities = entities;
        this.blocks = blocks;
        this.blockEntities = blockEntities;
        this.items = items;
    }

    public static Blacklist fromJson(JsonReader reader) {
        return (Blacklist)GSON.fromJson(reader, Blacklist.class);
    }

    public boolean isBlacklisted(ErroredType type, class_2960 id) {
        if (id == null) {
            return false;
        }
        if (this.namespaces != null) {
            for (String namespace : this.namespaces) {
                if (!id.method_12836().equals(namespace)) continue;
                return true;
            }
        }
        return switch (type) {
            case ErroredType.ENTITY -> {
                if (this.entities != null && this.entities.contains(id)) {
                    yield true;
                }
                yield false;
            }
            case ErroredType.BLOCK_STATE -> {
                if (this.blocks != null && this.blocks.contains(id)) {
                    yield true;
                }
                yield false;
            }
            case ErroredType.BLOCK_ENTITY -> {
                if (this.blockEntities != null && this.blockEntities.contains(id)) {
                    yield true;
                }
                yield false;
            }
            case ErroredType.ITEM_STACK -> {
                if (this.items != null && this.items.contains(id)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

