/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures;

import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class StructureCaves
implements IStructure {
    private int offset = 12;
    private final OpenSimplexNoise heightNoise;
    private final OpenSimplexNoise rigidNoise;
    private final OpenSimplexNoise distortX;
    private final OpenSimplexNoise distortY;

    public StructureCaves(long seed) {
        class_5820 random = new class_5820(seed);
        this.heightNoise = new OpenSimplexNoise(random.method_43055());
        this.rigidNoise = new OpenSimplexNoise(random.method_43055());
        this.distortX = new OpenSimplexNoise(random.method_43055());
        this.distortY = new OpenSimplexNoise(random.method_43055());
    }

    @Override
    public void generate(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int wz;
        int z;
        int wx;
        int x;
        boolean isVoid = true;
        this.offset = (int)(this.getHeight(pos.method_10263() + 8, pos.method_10260() + 8) - 12.0);
        for (x = 0; x < 16; ++x) {
            wx = pos.method_10263() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.method_10260() + z;
                double height = this.getHeight(wx, wz);
                double rigid = this.getRigid(wx, wz);
                for (int y = 0; y < 24; ++y) {
                    int wy = this.offset + y;
                    double hRigid = Math.abs((double)wy - height);
                    double sdf = -this.opSmoothUnion(-hRigid / 30.0, -rigid, 0.15);
                    if (sdf < 0.15) {
                        context.MASK[x][y][z] = true;
                        isVoid = false;
                        continue;
                    }
                    context.MASK[x][y][z] = false;
                }
            }
        }
        if (isVoid) {
            return;
        }
        for (x = 0; x < 16; ++x) {
            wx = pos.method_10263() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.method_10260() + z;
                for (int y = 23; y >= 0; --y) {
                    int wy = this.offset + y;
                    context.POS.method_10103(wx, wy, wz);
                    if (!context.MASK[x][y][z] || !BlocksHelper.isTerrain((class_2680)world.method_8320((class_2338)context.POS))) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)context.POS, (class_2680)class_2246.field_10124.method_9564());
                }
            }
        }
    }

    private double getHeight(int x, int z) {
        return this.heightNoise.eval((double)x * 0.01, (double)z * 0.01) * 32.0 + 64.0;
    }

    private double getRigid(int x, int z) {
        return Math.abs(this.rigidNoise.eval((double)x * 0.02 + this.distortX.eval((double)x * 0.05, (double)z * 0.05) * 0.2, (double)z * 0.02 + this.distortY.eval((double)x * 0.05, (double)z * 0.05) * 0.2)) * 0.6;
    }

    private double mix(double dist1, double dist2, double blend) {
        return dist1 * (1.0 - blend) + dist2 * blend;
    }

    private double opSmoothUnion(double dist1, double dist2, double blend) {
        double h = 0.5 + 0.5 * (dist2 - dist1) / blend;
        h = h > 1.0 ? 1.0 : (h < 0.0 ? 0.0 : h);
        return this.mix(dist2, dist1, h) - blend * h * (1.0 - h);
    }

    public boolean isInCave(int x, int y, int z, StructureGeneratorThreadContext context) {
        int y2 = y - this.offset;
        if (y2 >= 0 && y < 24) {
            return context.MASK[x][y2][z];
        }
        return false;
    }
}

