/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2919;
import net.minecraft.class_3079;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3543;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.commands.PlaceCommand;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class CommandRegistry {
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> class_2561.method_43470((String)("The next biome (" + String.valueOf(object) + ") was not found.")));
    private static final int MAX_SEARCH_RADIUS = 12800;
    private static final int SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int SAMPLE_RESOLUTION_VERTICAL = 64;
    private static int biomeIndex = 0;
    private static int placeMapIdx = 0;
    private static final class_2680[] states = new class_2680[]{class_2246.field_10272.method_9564(), class_2246.field_10060.method_9564(), class_2246.field_10049.method_9564(), class_2246.field_10157.method_9564(), class_2246.field_10317.method_9564(), class_2246.field_10357.method_9564(), class_2246.field_10087.method_9564(), class_2246.field_9997.method_9564(), class_2246.field_10227.method_9564(), class_2246.field_10271.method_9564()};
    private static final class_2680[] states2 = new class_2680[]{class_2246.field_10058.method_9564(), class_2246.field_10011.method_9564(), class_2246.field_10542.method_9564(), class_2246.field_10421.method_9564(), class_2246.field_10434.method_9564(), class_2246.field_10367.method_9564(), class_2246.field_10107.method_9564(), class_2246.field_10458.method_9564(), class_2246.field_10210.method_9564(), class_2246.field_10242.method_9564()};
    public static final class_3543 BIOME_INFO_NOISE = new class_3543((class_5819)new class_2919((class_5819)new class_5820(2345L)), (List)ImmutableList.of((Object)0));

    public static void register() {
        CommandRegistrationCallback.EVENT.register(CommandRegistry::register);
    }

    private static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        LiteralArgumentBuilder<class_2168> bnContext = (LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)"bn").requires(source -> source.method_9259(4));
        bnContext = PlaceCommand.register(bnContext);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"test_place").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.testPlace((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"find_surface").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.findSurface((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tpnext").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.teleportToNextBiome((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"place_all").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.placeAllBlocks((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"place_matching").requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandRegistry.placeMatchingBlocks((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"type"))))));
    }

    private static int teleportToNextBiome(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2338 target;
        class_2680 state;
        class_2168 source = (class_2168)ctx.getSource();
        class_7225.class_7226 biomeLookup = WorldState.registryAccess().method_46762(class_7924.field_41236);
        List<class_5321> biomes = ((class_6885.class_6888)biomeLookup.method_46733(NetherTags.BETTER_NETHER).orElseThrow()).method_40239().map(class_6880::method_40230).filter(Optional::isPresent).map(Optional::get).toList();
        if (biomeIndex < 0 || biomeIndex >= biomes.size()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Failed to find the next Biome...").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return 0;
        }
        final class_5321 biome = biomes.get(biomeIndex);
        source.method_9226(() -> class_2561.method_43470((String)("Locating Biome " + String.valueOf(biome))).method_10862(class_2583.field_24360.method_10977(class_124.field_1077)), false);
        biomeIndex = (biomeIndex + 1) % biomes.size();
        class_2338 currentPosition = new class_2338((int)source.method_9222().field_1352, (int)source.method_9222().field_1351, (int)source.method_9222().field_1350);
        class_2338 biomePosition = (class_2338)source.method_9225().method_42108(b -> ((class_5321)b.method_40230().orElseThrow()).method_29177().equals((Object)biome.method_29177()), currentPosition, 12800, 32, 64).getFirst();
        final String biomeName = biome.toString();
        if (biomePosition == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)biomeName);
        }
        class_3222 player = source.method_9207();
        double yPos = source.method_9222().method_10214();
        boolean didWrap = false;
        do {
            target = new class_2338(biomePosition.method_10263(), (int)yPos, biomePosition.method_10260());
            state = player.method_37908().method_8320(target);
            if (!((yPos -= 1.0) <= (double)(player.method_37908().method_31607() + 1))) continue;
            if (didWrap) break;
            yPos = 127.0;
            didWrap = true;
        } while (!state.method_26215() && yPos > (double)player.method_37908().method_31607() && yPos < (double)player.method_37908().method_31600());
        Vector3d targetPlayerPos = new Vector3d((double)target.method_10263() + 0.5, (double)(target.method_10264() - 1), (double)target.method_10260() + 0.5);
        player.field_13987.method_14360(targetPlayerPos.x, targetPlayerPos.y, targetPlayerPos.z, 0.0f, 0.0f, Collections.EMPTY_SET);
        class_7066.class_7068 result = new class_7066.class_7068(){

            public Either<class_5321, class_6862> method_41173() {
                return Either.left((Object)biome);
            }

            public Optional<class_7066.class_7068> method_41175(class_5321 resourceKey) {
                return Optional.empty();
            }

            public String method_41176() {
                return biomeName;
            }

            public boolean test(Object o) {
                return false;
            }
        };
        class_5321 a = biome;
        if (WorldState.allStageRegistryAccess() != null) {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)class_156.field_37250);
            class_6880 h = (class_6880)WorldState.allStageRegistryAccess().method_30530(class_7924.field_41236).method_40264(a).orElseThrow();
            stopwatch.stop();
            return class_3079.method_24499((class_2168)source, (class_7066.class_7068)result, (class_2338)currentPosition, (Pair)new Pair((Object)biomePosition, (Object)h), (String)"commands.locatebiome.success", (boolean)false, (Duration)stopwatch.elapsed());
        }
        return 1;
    }

    private static int placeMatchingBlocks(CommandContext<class_2168> ctx, String type) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        class_243 pos = source.method_9222();
        LinkedList<class_2248> blocks = new LinkedList<class_2248>();
        for (class_2248 block : NetherBlocks.getModBlocks().sorted(CommandRegistry::compareBlockNames).collect(Collectors.toList())) {
            String name = class_7923.field_41175.method_10221((Object)block).method_12832();
            if (name.indexOf(type) < 0) continue;
            blocks.add(block);
        }
        CommandRegistry.placeBlockRow(player, pos, blocks, 1, true);
        return 1;
    }

    @NotNull
    private static int compareBlockNames(class_2248 a, class_2248 b) {
        String as = class_7923.field_41175.method_10221((Object)a).method_12832();
        String bs = class_7923.field_41175.method_10221((Object)b).method_12832();
        return as.compareTo(bs);
    }

    private static int findSurface(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        class_243 pos = source.method_9222();
        class_3218 level = source.method_9225();
        class_2338.class_2339 mPos = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350).method_25503();
        System.out.println("Staring at: " + String.valueOf(mPos) + " -> " + String.valueOf(level.method_8320((class_2338)mPos)));
        boolean found = org.betterx.bclib.util.BlocksHelper.findSurroundingSurface((class_1936)level, (class_2338.class_2339)mPos, (class_2350)class_2350.field_11033, (int)12, state -> BlocksHelper.isNetherGroundMagma(state));
        System.out.println("Ending at: " + String.valueOf(mPos) + " -> " + String.valueOf(level.method_8320((class_2338)mPos)) + " = " + found);
        org.betterx.bclib.util.BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350), (class_2248)class_2246.field_10542);
        org.betterx.bclib.util.BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)mPos, (class_2248)class_2246.field_10242);
        return 1;
    }

    private static int testPlace(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        class_243 pos = source.method_9222();
        class_3218 level = source.method_9225();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                double v = BIOME_INFO_NOISE.method_16451(((double)x + pos.field_1352) / 200.0, ((double)y + pos.field_1350) / 200.0, false);
                if (v < min) {
                    min = v;
                }
                if (!(v > max)) continue;
                max = v;
            }
        }
        System.out.println("Noise: " + min + " - " + max);
        class_6880 pHolder = NetherVegetationPlaced.VEGETATION_GRASSLANDS.getHolder(WorldState.registryAccess());
        if (pHolder == null) {
            return -1;
        }
        class_6796 pFeature = (class_6796)pHolder.comp_349();
        List placements = pFeature.comp_335();
        class_5444 pctx = new class_5444((class_5281)level, level.method_14178().method_12129(), Optional.of(pFeature));
        Stream<Object> s = Stream.of(new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
        class_5820 rnd = new class_5820(121212L);
        placeMapIdx = 0;
        LinkedList posStates = new LinkedList();
        for (class_6797 p2 : placements) {
            s = s.flatMap(arg_0 -> CommandRegistry.lambda$testPlace$15(p2, pctx, (class_5819)rnd, arg_0));
            List<Object> list = s.toList();
            placeMapIdx = (placeMapIdx + 1) % states.length;
            class_2680 state1 = states[placeMapIdx];
            System.out.println(p2.getClass().getSimpleName() + " -> " + list.size() + ", " + String.valueOf(state1));
            list.forEach(bp -> {
                class_2680 state = states[placeMapIdx];
                if (org.betterx.bclib.util.BlocksHelper.isTerrain((class_2680)level.method_8320(bp))) {
                    state = states2[placeMapIdx];
                }
                posStates.add(new Pair(bp, (Object)state));
            });
            s = list.stream();
        }
        posStates.forEach(p -> BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)p.getFirst(), (class_2680)p.getSecond()));
        return 1;
    }

    private static int placeAllBlocks(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        class_243 pos = source.method_9222();
        LinkedList<class_2248> pickaxes = new LinkedList<class_2248>();
        LinkedList<class_2248> axes = new LinkedList<class_2248>();
        LinkedList<class_2248> hoes = new LinkedList<class_2248>();
        LinkedList<class_2248> shovels = new LinkedList<class_2248>();
        LinkedList<class_2248> other = new LinkedList<class_2248>();
        for (class_2248 block : NetherBlocks.getModBlocks().sorted(CommandRegistry::compareBlockNames).collect(Collectors.toList())) {
            class_2680 state = block.method_9564();
            if (state.method_26164(class_3481.field_33715)) {
                pickaxes.add(block);
                continue;
            }
            if (state.method_26164(class_3481.field_33713)) {
                axes.add(block);
                continue;
            }
            if (state.method_26164(class_3481.field_33714)) {
                hoes.add(block);
                continue;
            }
            if (state.method_26164(class_3481.field_33716)) {
                shovels.add(block);
                continue;
            }
            other.add(block);
        }
        CommandRegistry.placeBlockRow(player, pos, pickaxes, 1, false);
        CommandRegistry.placeBlockRow(player, pos, axes, 2, false);
        CommandRegistry.placeBlockRow(player, pos, hoes, 3, false);
        CommandRegistry.placeBlockRow(player, pos, shovels, 4, false);
        CommandRegistry.placeBlockRow(player, pos, other, 5, false);
        return 1;
    }

    private static void placeBlockRow(class_3222 player, class_243 pos, List<class_2248> blocklist, int offset, boolean square) {
        int i = 0;
        int j = 0;
        int rowLen = (int)Math.ceil(Math.sqrt(blocklist.size()));
        blocklist.sort((a, b) -> {
            if (a instanceof class_2323 && !(b instanceof class_2323)) {
                return 1;
            }
            if (!(a instanceof class_2323) && b instanceof class_2323) {
                return -1;
            }
            return 0;
        });
        for (class_2248 bl : blocklist) {
            class_2680 state = bl.method_9564();
            class_2338 blockPos = new class_2338((int)pos.field_1352 + i, (int)pos.field_1351 + j, (int)pos.field_1350 + offset);
            CommandRegistry.place(player, bl, state, blockPos);
            if (++i < rowLen) continue;
            i = 0;
            ++j;
        }
    }

    private static void place(class_3222 player, class_2248 bl, class_2680 state, class_2338 blockPos) {
        if (bl instanceof class_2399) {
            // empty if block
        }
        BlocksHelper.setWithoutUpdate((class_1936)player.method_37908(), blockPos, state);
        if (bl instanceof class_2323) {
            BlocksHelper.setWithoutUpdate((class_1936)player.method_37908(), blockPos.method_10084(), (class_2680)state.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609));
        }
    }

    private static /* synthetic */ Stream lambda$testPlace$15(class_6797 p, class_5444 pctx, class_5819 rnd, class_2338 bp) {
        return p.method_14452(pctx, rnd, bp);
    }
}

