/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.client.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import org.betterx.bclib.util.Pair;
import org.betterx.betternether.BetterNether;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;

public class BNModels {
    private static final Map<String, class_4942> TEMPLATES = new HashMap<String, class_4942>();
    public static final class_2960 CROP_BLOCK_MODEL_LOCATION = BetterNether.C.mk("block/crop_block");
    public static final class_2960 JUNGLE_PLANT_MODEL_LOCATION = BetterNether.C.mk("block/jungle_plant");
    public static final class_2960 GRASS_FAN_MODEL_LOCATION = BetterNether.C.mk("block/grass_fan");
    public static final class_2960 STAIRS_WITH_TOP_MODEL_LOCATION = BetterNether.C.mk("block/stairs_with_top");
    public static final class_4942 STAIRS_WITH_TOP_MODEL = new class_4942(Optional.of(STAIRS_WITH_TOP_MODEL_LOCATION), Optional.empty(), new class_4945[]{class_4945.field_23015, class_4945.field_23014});

    public static void createComplex(WoverBlockModelGenerators generators, class_2248 bl, List<ModelSource> sources) {
        List<Pair> models = sources.stream().map(s -> {
            Optional parent = s.parent() == null ? Optional.empty() : Optional.of(s.parent());
            Optional suffix = s.suffix() == null || s.suffix().trim().isEmpty() ? Optional.empty() : Optional.of(s.suffix());
            class_4945[] slots = (class_4945[])s.textures().stream().map(TextureSource::slot).toArray(class_4945[]::new);
            class_4944 mapping = new class_4944();
            s.textures.forEach(t -> mapping.method_25868(t.slot(), t.texture()));
            class_4942 template = new class_4942(parent, suffix, slots);
            return new Pair(s, (Object)template.method_25846(bl, mapping, generators.vanillaGenerator.field_22831));
        }).toList();
        List<class_2960> allModels = models.stream().map(p -> (class_2960)p.second).toList();
        class_4935[] variants = (class_4935[])models.stream().flatMap(m -> ((ModelSource)m.first).variants().stream().map(f -> f.apply((class_2960)m.second, allModels))).toArray(class_4935[]::new);
        generators.acceptBlockState((class_4917)class_4925.method_25771((class_2248)bl, (class_4935[])variants));
        class_1792 item = bl.method_8389();
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25895((class_2960)sources.get((int)0).textures.get((int)0).texture), generators.vanillaGenerator.field_22831);
    }

    public static class_4942 getCropBlockModelTemplate(String suffix) {
        return TEMPLATES.computeIfAbsent(CROP_BLOCK_MODEL_LOCATION.toString() + suffix, s -> new class_4942(Optional.of(CROP_BLOCK_MODEL_LOCATION), suffix == null || suffix.trim().isEmpty() ? Optional.empty() : Optional.of(suffix), new class_4945[]{class_4945.field_23011}));
    }

    public static class_4942 getCropCrossBlockModelTemplate(String suffix) {
        return TEMPLATES.computeIfAbsent(WoverBlockModelGenerators.CROSS.toString() + suffix, s -> new class_4942(Optional.of(WoverBlockModelGenerators.CROSS), suffix == null || suffix.trim().isEmpty() ? Optional.empty() : Optional.of(suffix), new class_4945[]{class_4945.field_23025}));
    }

    @Environment(value=EnvType.CLIENT)
    public static void provideGrassBlockModels(WoverBlockModelGenerators generators, class_2248 bl, String baseName, int count) {
        ArrayList<ModelSource> variants = new ArrayList<ModelSource>(2 * count);
        for (int i = 1; i <= count; ++i) {
            class_2960 texture = BetterNether.C.mk("block/" + baseName + "_" + i);
            variants.add(ModelSource.of(WoverBlockModelGenerators.CROSS, "_" + i, List.of((id, all) -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)id)), TextureSource.of(class_4945.field_23025, texture)));
            variants.add(ModelSource.of(CROP_BLOCK_MODEL_LOCATION, "_" + (count + i), List.of((id, all) -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)id)), TextureSource.of(class_4945.field_23011, texture)));
        }
        BNModels.createComplex(generators, bl, variants);
    }

    @Environment(value=EnvType.CLIENT)
    public static void provideSimpleMultiStateBlock(WoverBlockModelGenerators generators, class_2248 bl, String ... suffixes) {
        String baseName = class_4941.method_25842((class_2248)bl).method_12832();
        ArrayList<ModelSource> variants = new ArrayList<ModelSource>(suffixes.length);
        for (int i = 1; i <= suffixes.length; ++i) {
            class_2960 texture = BetterNether.C.mk(baseName + suffixes[i - 1]);
            variants.add(ModelSource.of(WoverBlockModelGenerators.CUBE_ALL, suffixes[i - 1], List.of((id, all) -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)id)), TextureSource.of(class_4945.field_23010, texture)));
        }
        BNModels.createComplex(generators, bl, variants);
    }

    public record ModelSource(class_2960 parent, String suffix, List<VariantSupplier> variants, List<TextureSource> textures) {
        public static ModelSource of(class_2960 parent, String suffix, List<VariantSupplier> variants, TextureSource ... textures) {
            return new ModelSource(parent, suffix, variants, Arrays.asList(textures));
        }
    }

    public record TextureSource(class_4945 slot, class_2960 texture) {
        public static TextureSource of(class_4945 slot, class_2960 texture) {
            return new TextureSource(slot, texture);
        }
    }

    public static interface VariantSupplier {
        public class_4935 apply(class_2960 var1, List<class_2960> var2);
    }
}

