/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether;

import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2960;
import org.betterx.bclib.BCLib;
import org.betterx.betternether.Patcher;
import org.betterx.betternether.advancements.BNCriterion;
import org.betterx.betternether.commands.CommandRegistry;
import org.betterx.betternether.config.Config;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.loot.BNLoot;
import org.betterx.betternether.registry.BlockEntitiesRegistry;
import org.betterx.betternether.registry.BrewingRegistry;
import org.betterx.betternether.registry.NetherBiomes;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherEnchantments;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.registry.NetherPoiTypes;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.NetherTemplates;
import org.betterx.betternether.registry.SoundsRegistry;
import org.betterx.betternether.registry.features.configured.NetherVegetation;
import org.betterx.betternether.tab.BECreativeTabs;
import org.betterx.betternether.world.BNWorldGenerator;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.state.api.WorldConfig;

public class BetterNether
implements ModInitializer {
    public static final ModCore C = ModCore.create((String)"betternether");
    public static final ModCore VANILLA_HAMMERS = ModCore.create((String)"vanilla-hammers");
    public static final ModCore VANILLA_EXCAVATORS = ModCore.create((String)"vanillaexcavators");
    public static final class_2960 VANILLA_HAMMERS_PACK = C.addDatapack(VANILLA_HAMMERS);
    public static final class_2960 VANILLA_EXCAVATORS_PACK = C.addDatapack(VANILLA_EXCAVATORS);
    private static boolean lavafallParticles = true;
    private static float fogStart = 0.05f;
    private static float fogEnd = 0.5f;

    private void onDatagen() {
    }

    public void onInitialize() {
        BetterNether.C.log.info("=^..^=    BetterNether for 1.21    =^..^=");
        this.initOptions();
        SoundsRegistry.ensureStaticallyLoaded();
        NetherEnchantments.ensureStaticallyLoaded();
        NetherBlocks.register();
        BlockEntitiesRegistry.register();
        NetherItems.register();
        NetherTemplates.ensureStaticallyLoaded();
        NetherEntities.register();
        BNWorldGenerator.onModInit();
        NetherPoiTypes.register();
        NetherFeatures.register();
        NetherStructures.register();
        NetherBiomes.register();
        BrewingRegistry.register();
        CommandRegistry.register();
        Config.save();
        NetherTags.register();
        BNLoot.register();
        BNCriterion.register();
        NetherVegetation.setupBonemealFeatures();
        Configs.saveConfigs();
        WorldConfig.registerMod((ModCore)C);
        Patcher.register();
        BECreativeTabs.register();
        if (BCLib.isDatagen()) {
            this.onDatagen();
        }
    }

    private void initOptions() {
        lavafallParticles = (Boolean)Configs.CLIENT.lavafallParticles.get();
        float density = ((Float)Configs.CLIENT.fogDensity.get()).floatValue();
        BetterNether.changeFogDensity(density);
    }

    public static boolean hasLavafallParticles() {
        return lavafallParticles;
    }

    public static void changeFogDensity(float density) {
        fogStart = -0.45f * density + 0.5f;
        fogEnd = -0.5f * density + 1.0f;
    }

    public static float getFogStart() {
        return fogStart;
    }

    public static float getFogEnd() {
        return fogEnd;
    }
}

