/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawncapcontrolutility.config;

import com.mactso.spawncapcontrolutility.config.ModConfigProvider;
import com.mactso.spawncapcontrolutility.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import net.minecraft.class_1311;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MyConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    private static String spawnCategoriesConfig;
    private static String spawnCategoriesDefault;
    static String[] spawnCategories;

    public static int safeValue(int newValue) {
        if (newValue < 1) {
            return 1;
        }
        if (newValue > 350) {
            return 350;
        }
        return newValue;
    }

    public static HashSet<String> getModStringSet(String[] values) {
        HashSet<String> returnset = new HashSet<String>();
        HashSet<String> loadedset = new HashSet<String>();
        loadedset.add("respawnvillager");
        loadedset.add("test");
        for (String s : loadedset) {
            String s2 = s.trim().toLowerCase();
            if (s2.isEmpty()) continue;
            if (!returnset.contains(s2)) {
                returnset.add(s2);
                continue;
            }
            LOGGER.warn("spawncapcontrolutility");
        }
        return returnset;
    }

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        MyConfig.createConfigs();
        CONFIG = SimpleConfig.of("spawncapcontrolutilityconfig").provider(configs).request();
        MyConfig.assignConfigs();
        spawnCategories = spawnCategoriesConfig.split(";");
    }

    public static String getSpawnCategoryName(String str) {
        for (String s : spawnCategories) {
            if (!s.toUpperCase().contains(str.toUpperCase())) continue;
            String[] parts = str.split(",", 2);
            return parts[0].trim();
        }
        return "";
    }

    public static int getSpawnCategoryMaximum(String str) {
        for (String s : spawnCategories) {
            if (!s.toUpperCase().contains(str.toUpperCase())) continue;
            return MyConfig.splitAndGetInt(s.toUpperCase());
        }
        return -1;
    }

    public static int splitAndGetInt(String inputString) {
        try {
            String[] parts = inputString.split(",", 2);
            String secondHalf = parts[1].trim();
            return Integer.parseInt(secondHalf);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            LOGGER.error("Configuration Error for category: " + inputString);
            return -1;
        }
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"key.MobCategoryCapacities", (Object)spawnCategoriesDefault), "string");
    }

    private static void assignConfigs() {
        spawnCategoriesConfig = CONFIG.getOrDefault("key.MobCategoryCapacities", spawnCategoriesDefault);
        LOGGER.info("All " + configs.getConfigsList().size() + " have been set properly");
    }

    static {
        spawnCategoriesDefault = class_1311.field_6302.method_6133().toUpperCase() + "," + (class_1311.field_6302.method_6134() + 3) + ";" + class_1311.field_6294.method_6133().toUpperCase() + "," + class_1311.field_6294.method_6134() + ";" + class_1311.field_6303.method_6133().toUpperCase() + "," + (class_1311.field_6303.method_6134() - 1) + ";" + class_1311.field_34447.method_6133().toUpperCase() + "," + class_1311.field_34447.method_6134() + ";" + class_1311.field_30092.method_6133().toUpperCase() + "," + class_1311.field_30092.method_6134() + ";" + class_1311.field_6300.method_6133().toUpperCase() + "," + class_1311.field_6300.method_6134() + ";" + class_1311.field_24460.method_6133().toUpperCase() + "," + class_1311.field_24460.method_6134();
    }
}

