/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import me.pandamods.pandalib.platform.Services;
import me.pandamods.pandalib.registry.DeferredObject;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class DeferredRegister<T> {
    private final String namespace;
    private final class_5321<? extends class_2378<T>> registryKey;
    private final Map<DeferredObject<? extends T>, Supplier<? extends T>> entries = new HashMap<DeferredObject<? extends T>, Supplier<? extends T>>();

    public static <T> DeferredRegister<T> create(String namespace, class_2960 registryLocation) {
        return DeferredRegister.create(namespace, class_5321.method_29180((class_2960)registryLocation));
    }

    public static <T> DeferredRegister<T> create(String namespace, class_2378<T> registry) {
        return DeferredRegister.create(namespace, registry.method_30517());
    }

    public static <T> DeferredRegister<T> create(String namespace, class_5321<? extends class_2378<T>> registryKey) {
        return new DeferredRegister<T>(namespace, registryKey);
    }

    private DeferredRegister(String namespace, class_5321<? extends class_2378<T>> registryKey) {
        this.namespace = namespace;
        this.registryKey = registryKey;
    }

    public <R extends T> DeferredObject<R> register(String name, Function<class_5321<T>, R> registryFunc) {
        return this.register(class_2960.method_60655((String)this.namespace, (String)name), registryFunc);
    }

    public <R extends T> DeferredObject<R> register(String name, Supplier<R> registrySup) {
        return this.register(class_2960.method_60655((String)this.namespace, (String)name), registrySup);
    }

    public <R extends T> DeferredObject<R> register(class_2960 name, Function<class_5321<T>, R> registryFunc) {
        class_5321 key = class_5321.method_29179(this.registryKey, (class_2960)name);
        return this.register(key, () -> registryFunc.apply(key));
    }

    public <R extends T> DeferredObject<R> register(class_2960 name, Supplier<R> registrySup) {
        return this.register(class_5321.method_29179(this.registryKey, (class_2960)name), registrySup);
    }

    private <R extends T> DeferredObject<R> register(class_5321<T> resourceKey, Supplier<R> registrySup) {
        DeferredObject deferredObject = new DeferredObject(resourceKey);
        this.entries.put(deferredObject, registrySup);
        return deferredObject;
    }

    public void register() {
        this.entries.forEach(Services.REGISTRATION::register);
    }
}

