/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel;

import com.periut.chisel.Chisel;
import com.periut.chisel.block.ChiselGroupLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ChiselREI
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new ChiselCategory());
        registry.addWorkstations(CategoryIdentifier.of((String)"chisel", (String)"chisel_recipes_category"), new EntryStack[]{EntryStacks.of((class_1935)((class_1935)Chisel.chiselSupplier.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        Iterator<String> chiselGroupNames = ChiselGroupLookup.getGroupNameIterator();
        while (chiselGroupNames.hasNext()) {
            registry.add((Display)new ChiselDisplay(chiselGroupNames.next()));
        }
    }

    public static class ChiselCategory
    implements DisplayCategory<ChiselDisplay> {
        private final class_2960 TEXTURE = class_2960.method_60655((String)"chisel", (String)"textures/rei_recipes.png");

        public Renderer getIcon() {
            return EntryStacks.of((class_1935)((class_1935)Chisel.chiselSupplier.get()), (int)1);
        }

        public class_2561 getTitle() {
            return class_2561.method_30163((String)class_1074.method_4662((String)"rei.chisel.category", (Object[])new Object[0]));
        }

        public CategoryIdentifier<? extends ChiselDisplay> getCategoryIdentifier() {
            return CategoryIdentifier.of((String)"chisel", (String)"chisel_recipes_category");
        }

        public int getDisplayHeight() {
            return 200;
        }

        public int getDisplayWidth(ChiselDisplay display) {
            return 150;
        }

        public List<Widget> setupDisplay(ChiselDisplay display, Rectangle bounds) {
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            Point startPoint = new Point(bounds.getMinX() + 21, bounds.getMinY() + 15);
            List<EntryIngredient> outputEntries = display.getOutputEntries();
            int j = outputEntries.size();
            int rows = (int)Math.ceil((double)j / 6.0);
            widgets.add(Widgets.createTexturedWidget((class_2960)this.TEXTURE, (int)startPoint.x, (int)startPoint.y, (int)108, (int)(236 - (18 * (10 - rows) + 1))));
            ArrayList<Slot> slots = new ArrayList<Slot>();
            slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + 45, startPoint.y + 1 + 16)).backgroundEnabled(false).markInput().entries((Collection)display.getInputEntries().get(0)));
            for (int x = 0; x < 6; ++x) {
                for (int y = 0; y < rows && 6 * y + x < j; ++y) {
                    slots.add(Widgets.createSlot((Point)new Point(startPoint.x + 1 + 18 * x, startPoint.y + 1 + 55 + 18 * y)).markOutput().entries((Collection)outputEntries.get(6 * y + x)));
                }
            }
            widgets.addAll(slots);
            return widgets;
        }
    }

    public static class ChiselDisplay
    implements Display {
        private final List<class_1792> chiselGroupItems;

        public ChiselDisplay(String chiselGroup) {
            this.chiselGroupItems = ChiselGroupLookup.getBlocksInGroup(chiselGroup);
        }

        public List<EntryIngredient> getInputEntries() {
            ArrayList<EntryIngredient> entryIngredientList = new ArrayList<EntryIngredient>();
            for (class_1792 item : this.chiselGroupItems) {
                entryIngredientList.add(EntryIngredients.of((class_1935)item));
            }
            return entryIngredientList;
        }

        public List<EntryIngredient> getOutputEntries() {
            ArrayList<EntryIngredient> entryIngredientList = new ArrayList<EntryIngredient>();
            for (class_1792 item : this.chiselGroupItems) {
                entryIngredientList.add(EntryIngredients.of((class_1935)item));
            }
            return entryIngredientList;
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return CategoryIdentifier.of((String)"chisel", (String)"chisel_recipes_category");
        }
    }
}

