/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster;

import fuzs.eternalnether.EternalNether;
import fuzs.eternalnether.services.CommonAbstractions;
import fuzs.eternalnether.world.entity.ai.goal.UseShieldGoal;
import fuzs.eternalnether.world.entity.monster.ShieldedMob;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class WitherSkeletonKnight
extends class_1639
implements ShieldedMob {
    private static final class_2940<Boolean> DATA_IS_SHIELDED = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_SHIELD_HAND = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_SHIELD_COOLDOWN = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_IS_DISARMORED = class_2945.method_12791(WitherSkeletonKnight.class, (class_2941)class_2943.field_13323);
    private static final class_2960 SPEED_MODIFIER_BLOCKING_ID = EternalNether.id("blocking");
    private static final class_1322 SPEED_MODIFIER_BLOCKING = new class_1322(SPEED_MODIFIER_BLOCKING_ID, -0.1, class_1322.class_1323.field_6328);
    private static final class_2960 SPEED_MODIFIER_DISARMOURED_ID = class_2960.method_60656((String)"disarmoured");
    private static final class_1322 SPEED_MODIFIER_DISARMOURED = new class_1322(SPEED_MODIFIER_DISARMOURED_ID, (double)0.35f, class_1322.class_1323.field_6331);
    private static final float BREAK_HEALTH_PERCENT = 0.35f;

    public WitherSkeletonKnight(class_1299<? extends class_1639> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23724, 2.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_IS_DISARMORED, (Object)false);
        builder.method_56912(DATA_IS_SHIELDED, (Object)false);
        builder.method_56912(DATA_SHIELD_HAND, (Object)false);
        builder.method_56912(DATA_SHIELD_COOLDOWN, (Object)0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, new UseShieldGoal<WitherSkeletonKnight>(this, class_1657.class));
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.decrementShieldCooldown();
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Disarmored", this.isDisarmored());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setDisarmored(tag.method_10577("Disarmored"));
    }

    public boolean isDisarmored() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_DISARMORED);
    }

    private void setDisarmored(boolean disarmored) {
        this.field_6011.method_12778(DATA_IS_DISARMORED, (Object)disarmored);
    }

    public void method_5964(class_5819 random, class_1266 difficulty) {
        super.method_5964(random, difficulty);
        this.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8255));
    }

    public boolean method_5643(class_1282 damageSource, float damageAmount) {
        if (super.method_5643(damageSource, damageAmount)) {
            if (!this.isDisarmored() && this.method_6032() / this.method_6063() < 0.35f) {
                this.setDisarmored(true);
                this.method_5783(class_3417.field_15239, 1.2f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
                class_1324 attribute = this.method_5996(class_5134.field_23719);
                if (attribute != null && !attribute.method_6196(SPEED_MODIFIER_DISARMOURED_ID)) {
                    attribute.method_26837(SPEED_MODIFIER_DISARMOURED);
                }
            }
            return true;
        }
        return false;
    }

    public void method_6005(double strength, double x, double z) {
        if (!this.isUsingShield()) {
            super.method_6005(strength, x, z);
        } else {
            this.method_5783(class_3417.field_15150, 1.0f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
        }
    }

    protected void method_6090(class_1309 attacker) {
        super.method_6090(attacker);
        if (CommonAbstractions.INSTANCE.canDisableShield(attacker.method_6047(), this.field_6277, (class_1309)this, attacker)) {
            this.disableShield();
        }
    }

    private void disableShield() {
        this.setShieldCooldown(60);
        this.stopUsingShield();
        this.method_37908().method_8421((class_1297)this, (byte)30);
        this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
    }

    @Override
    public boolean isShieldDisabled() {
        return this.getShieldCooldown() > 0;
    }

    @Override
    public void startUsingShield() {
        if (!this.isUsingShield() && !this.isShieldDisabled()) {
            for (class_1268 interactionHand : class_1268.values()) {
                if (!this.method_5998(interactionHand).method_31574(class_1802.field_8255)) continue;
                this.method_6019(interactionHand);
                this.setUsingShield(true);
                this.setShieldMainHand(interactionHand == class_1268.field_5808);
                class_1324 attributeInstance = this.method_5996(class_5134.field_23719);
                if (attributeInstance == null || attributeInstance.method_6196(SPEED_MODIFIER_BLOCKING_ID)) continue;
                attributeInstance.method_26835(SPEED_MODIFIER_BLOCKING);
            }
        }
    }

    @Override
    public void stopUsingShield() {
        if (this.isUsingShield()) {
            for (class_1268 interactionHand : class_1268.values()) {
                if (!this.method_5998(interactionHand).method_31574(class_1802.field_8255)) continue;
                this.method_6021();
                this.setUsingShield(false);
                class_1324 attributeinstance = this.method_5996(class_5134.field_23719);
                if (attributeinstance == null) continue;
                attributeinstance.method_6202(SPEED_MODIFIER_BLOCKING);
            }
        }
    }

    public boolean isUsingShield() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_SHIELDED);
    }

    public void setUsingShield(boolean isShielded) {
        this.field_6011.method_12778(DATA_IS_SHIELDED, (Object)isShielded);
    }

    private boolean isShieldMainHand() {
        return (Boolean)this.field_6011.method_12789(DATA_SHIELD_HAND);
    }

    private void setShieldMainHand(boolean isShieldedMainHand) {
        this.field_6011.method_12778(DATA_SHIELD_HAND, (Object)isShieldedMainHand);
    }

    private int getShieldCooldown() {
        return (Integer)this.field_6011.method_12789(DATA_SHIELD_COOLDOWN);
    }

    private void setShieldCooldown(int shieldCooldown) {
        this.field_6011.method_12778(DATA_SHIELD_COOLDOWN, (Object)shieldCooldown);
    }

    private void decrementShieldCooldown() {
        this.setShieldCooldown(Math.max(this.getShieldCooldown() - 1, 0));
    }

    public class_1268 getShieldHand() {
        return this.isUsingShield() ? (this.isShieldMainHand() ? class_1268.field_5808 : class_1268.field_5810) : null;
    }
}

