/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.ai.goal;

import fuzs.eternalnether.world.entity.monster.ShieldedMob;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_3222;
import net.minecraft.class_4051;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class UseShieldGoal<T extends class_1308>
extends class_1352 {
    protected final Class<? extends class_1309> targetType;
    protected final T mob;
    private int shieldCoolDown;
    private int shieldWarmup;
    private int shieldStagger;
    private int shieldDelay;
    @Nullable
    protected class_1309 target;
    protected final class_4051 targetConditions;

    public UseShieldGoal(T mob, Class<? extends class_1309> targetType) {
        this.mob = mob;
        this.targetType = targetType;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        this.targetConditions = class_4051.method_36625().method_18418(this.getFollowDistance()).method_18420(null);
    }

    public boolean method_6264() {
        this.findTarget();
        return this.target != null;
    }

    public boolean method_6266() {
        if (((ShieldedMob)this.mob).isShieldDisabled()) {
            return false;
        }
        if (this.target == null) {
            return false;
        }
        if (!this.target.method_5805()) {
            return false;
        }
        if (this.mob.method_5858((class_1297)this.target) > this.getFollowDistance() * this.getFollowDistance()) {
            return false;
        }
        return this.getStage() != ShieldStage.INACTIVE;
    }

    public void method_6269() {
        this.mob.method_5980(this.target);
        this.shieldDelay = this.method_38847(3 + this.mob.method_59922().method_43048(3));
        this.shieldStagger = this.method_38847(15 + this.mob.method_59922().method_43048(25));
        this.setDefaultCounters();
        super.method_6269();
    }

    public void method_6270() {
        this.target = null;
        this.setDefaultCounters();
        ((ShieldedMob)this.mob).stopUsingShield();
    }

    public void method_6268() {
        switch (this.getStage().ordinal()) {
            case 0: {
                this.setDefaultCounters();
                break;
            }
            case 1: {
                --this.shieldWarmup;
                break;
            }
            case 2: {
                if (this.mob.method_5968() == null) {
                    return;
                }
                this.mob.method_5988().method_6230(this.mob.method_5968().method_23317(), this.mob.method_5968().method_23320(), this.mob.method_5968().method_23321(), 10.0f, (float)this.mob.method_5978());
                ((ShieldedMob)this.mob).startUsingShield();
                this.setDefaultCounters();
                break;
            }
            case 3: {
                --this.shieldCoolDown;
            }
        }
    }

    private static boolean targetDrawnBow(class_1309 target) {
        if (target == null) {
            return false;
        }
        for (class_1268 interactionhand : class_1268.values()) {
            boolean chargedCrossbow;
            class_1799 itemstack = target.method_5998(interactionhand);
            boolean drawnBow = itemstack.method_31574(class_1802.field_8102) && target.method_6115();
            boolean bl = chargedCrossbow = itemstack.method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)itemstack);
            if (!drawnBow && !chargedCrossbow) continue;
            return true;
        }
        return false;
    }

    protected class_238 getTargetSearchArea(double radius) {
        return this.mob.method_5829().method_1009(radius, 4.0, radius);
    }

    protected void findTarget() {
        Object potentialTarget = this.targetType != class_1657.class && this.targetType != class_3222.class ? this.mob.method_37908().method_18468(this.mob.method_37908().method_8390(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), livingEntity -> true), this.targetConditions, this.mob, this.mob.method_23317(), this.mob.method_23320(), this.mob.method_23321()) : this.mob.method_37908().method_18463(this.targetConditions, this.mob, this.mob.method_23317(), this.mob.method_23320(), this.mob.method_23321());
        this.target = UseShieldGoal.targetDrawnBow((class_1309)potentialTarget) ? potentialTarget : null;
    }

    protected double getFollowDistance() {
        return this.mob.method_45325(class_5134.field_23717);
    }

    private void setDefaultCounters() {
        this.shieldWarmup = this.shieldDelay;
        this.shieldCoolDown = this.shieldStagger;
    }

    private ShieldStage getStage() {
        if (UseShieldGoal.targetDrawnBow(this.target)) {
            if (this.shieldWarmup <= 0) {
                this.shieldWarmup = 0;
                return ShieldStage.ACTIVE;
            }
            return ShieldStage.WARMUP;
        }
        if (this.shieldCoolDown <= 0) {
            this.shieldCoolDown = 0;
            return ShieldStage.INACTIVE;
        }
        return ShieldStage.COOLDOWN;
    }

    private static enum ShieldStage {
        INACTIVE,
        WARMUP,
        ACTIVE,
        COOLDOWN;

    }
}

