/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fuzs.puzzleslib.api.config.v3.json.GsonCodecHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3518;

public abstract class DataFixer<T> {
    public static final DataFixer<?> JSON = new JsonDataFixer();
    public static final DataFixer<?> NBT = new NbtDataFixer();
    static final Collection<DataFixer<?>> ALL = List.of(JSON, NBT);
    private final String fileExtension;

    DataFixer(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    static void getAllFilesRecursive(File file, Consumer<File> fileOutput, Predicate<String> fileFilter) {
        File[] listedFiles = file.listFiles();
        if (listedFiles != null) {
            for (File listedFile : listedFiles) {
                if (listedFile.isDirectory()) {
                    DataFixer.getAllFilesRecursive(listedFile, fileOutput, fileFilter);
                    continue;
                }
                if (!fileFilter.test(listedFile.getName())) continue;
                fileOutput.accept(listedFile);
            }
        }
    }

    public static void updateAll(File inputDirectory, File outputDirectory, String targetValue, String replacementValue) {
        for (DataFixer<?> dataFixer : ALL) {
            dataFixer.update(inputDirectory, outputDirectory, targetValue, replacementValue);
        }
    }

    public final void update(File inputDirectory, File outputDirectory, String targetValue, String replacementValue) {
        ArrayList files = new ArrayList();
        DataFixer.getAllFilesRecursive(inputDirectory, files::add, s -> s.endsWith("." + this.fileExtension));
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File inputFile = (File)iterator.next();
            File outputFile = outputDirectory.toPath().resolve(inputDirectory.toPath().relativize(inputFile.toPath())).toFile();
            outputFile.getParentFile().mkdirs();
            try {
                T t = this.read(inputFile);
                this.write(outputFile, this.process(t, targetValue, replacementValue));
            }
            catch (IOException exception) {
                PuzzlesLib.LOGGER.warn("Failed handling {}", (Object)outputFile, (Object)exception);
                iterator.remove();
            }
        }
    }

    public abstract T process(T var1, String var2, String var3);

    abstract T read(File var1) throws IOException;

    abstract void write(File var1, T var2) throws IOException;

    private static class JsonDataFixer
    extends DataFixer<JsonElement> {
        JsonDataFixer() {
            super("json");
        }

        @Override
        public JsonElement process(JsonElement jsonElement, String targetValue, String replacementValue) {
            block4: {
                block5: {
                    if (jsonElement == null || jsonElement.isJsonNull()) break block4;
                    if (jsonElement.isJsonPrimitive()) {
                        JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                        if (jsonPrimitive.isString() && jsonPrimitive.getAsString().contains(targetValue)) {
                            return new JsonPrimitive(jsonPrimitive.getAsString().replace(targetValue, replacementValue));
                        }
                        return jsonElement;
                    }
                    if (!jsonElement.isJsonArray()) break block5;
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        jsonArray.set(i, this.process(jsonArray.get(i), targetValue, replacementValue));
                    }
                    break block4;
                }
                if (!jsonElement.isJsonObject()) break block4;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    entry.setValue(this.process((JsonElement)entry.getValue(), targetValue, replacementValue));
                }
            }
            return jsonElement;
        }

        @Override
        JsonElement read(File file) throws IOException {
            try (FileReader fileReader = new FileReader(file);){
                JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GsonCodecHelper.GSON, (Reader)fileReader, JsonElement.class);
                return jsonElement;
            }
        }

        @Override
        void write(File file, JsonElement jsonElement) throws IOException {
            try (FileWriter fileWriter = new FileWriter(file);){
                GsonCodecHelper.GSON.toJson(jsonElement, (Appendable)fileWriter);
            }
        }
    }

    private static class NbtDataFixer
    extends DataFixer<class_2487> {
        NbtDataFixer() {
            super("nbt");
        }

        @Override
        public class_2487 process(class_2487 compoundTag, String targetValue, String replacementValue) {
            return this.processTag(compoundTag, targetValue, replacementValue);
        }

        private <T extends class_2520> T processTag(T tag, String targetValue, String replacementValue) {
            block3: {
                block5: {
                    block4: {
                        if (tag == null) break block3;
                        if (!(tag instanceof class_2519)) break block4;
                        class_2519 stringTag = (class_2519)tag;
                        if (stringTag.method_10714().contains(targetValue)) {
                            return (T)class_2519.method_23256((String)stringTag.method_10714().replace(targetValue, replacementValue));
                        }
                        break block3;
                    }
                    if (!(tag instanceof class_2499)) break block5;
                    class_2499 listTag = (class_2499)tag;
                    for (int i = 0; i < listTag.size(); ++i) {
                        listTag.method_10606(i, this.processTag(listTag.method_10534(i), targetValue, replacementValue));
                    }
                    break block3;
                }
                if (!(tag instanceof class_2487)) break block3;
                class_2487 compoundTag = (class_2487)tag;
                for (String s : compoundTag.method_10541()) {
                    compoundTag.method_10566(s, this.processTag(compoundTag.method_10580(s), targetValue, replacementValue));
                }
            }
            return tag;
        }

        @Override
        class_2487 read(File file) throws IOException {
            return class_2507.method_30613((Path)file.toPath(), (class_2505)class_2505.method_53898());
        }

        @Override
        void write(File file, class_2487 tag) throws IOException {
            class_2507.method_30614((class_2487)tag, (Path)file.toPath());
        }
    }
}

