/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.data.client;

import com.google.common.collect.ImmutableMap;
import fuzs.eternalnether.data.ModAdvancementProvider;
import fuzs.eternalnether.init.ModBlockFamilies;
import fuzs.eternalnether.init.ModBlocks;
import fuzs.eternalnether.init.ModEntityTypes;
import fuzs.eternalnether.init.ModItems;
import fuzs.eternalnether.init.ModSoundEvents;
import fuzs.eternalnether.init.ResourceKeyHelper;
import fuzs.puzzleslib.api.client.data.v2.AbstractLanguageProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_5794;

public class ModLanguageProvider
extends AbstractLanguageProvider {
    static final Map<class_5794.class_5796, BiFunction<BlockFamilyBuilder, class_2248, BlockFamilyBuilder>> VARIANT_FUNCTIONS = ImmutableMap.builder().put((Object)class_5794.class_5796.field_28533, BlockFamilyBuilder::button).put((Object)class_5794.class_5796.field_28534, BlockFamilyBuilder::chiseled).put((Object)class_5794.class_5796.field_29503, BlockFamilyBuilder::cracked).put((Object)class_5794.class_5796.field_33689, BlockFamilyBuilder::cut).put((Object)class_5794.class_5796.field_28535, BlockFamilyBuilder::door).put((Object)class_5794.class_5796.field_40592, BlockFamilyBuilder::fence).put((Object)class_5794.class_5796.field_28536, BlockFamilyBuilder::fence).put((Object)class_5794.class_5796.field_40593, BlockFamilyBuilder::fenceGate).put((Object)class_5794.class_5796.field_28537, BlockFamilyBuilder::fenceGate).put((Object)class_5794.class_5796.field_40594, BlockFamilyBuilder::mosaic).put((Object)class_5794.class_5796.field_28538, BlockFamilyBuilder::sign).put((Object)class_5794.class_5796.field_28539, BlockFamilyBuilder::slab).put((Object)class_5794.class_5796.field_28540, BlockFamilyBuilder::stairs).put((Object)class_5794.class_5796.field_28541, BlockFamilyBuilder::pressurePlate).put((Object)class_5794.class_5796.field_28542, BlockFamilyBuilder::polished).put((Object)class_5794.class_5796.field_28543, BlockFamilyBuilder::trapdoor).put((Object)class_5794.class_5796.field_28544, BlockFamilyBuilder::wall).put((Object)class_5794.class_5796.field_28545, BlockFamilyBuilder::wallSign).build();

    public ModLanguageProvider(DataProviderContext context) {
        super(context);
    }

    public void addTranslations(AbstractLanguageProvider.TranslationBuilder builder) {
        builder.addCreativeModeTab("eternalnether", "Eternal Nether");
        builder.addBlock(ModBlocks.COBBLED_BLACKSTONE, "Cobbled Blackstone");
        ModLanguageProvider.blockFamily(builder, "Withered Blackstone").baseBlock((class_2248)ModBlocks.WITHERED_BLACKSTONE.comp_349()).slab((class_2248)ModBlocks.WITHERED_BLACKSTONE_SLAB.comp_349()).stairs((class_2248)ModBlocks.WITHERED_BLACKSTONE_STAIRS.comp_349()).wall((class_2248)ModBlocks.WITHERED_BLACKSTONE_WALL.comp_349()).chiseled((class_2248)ModBlocks.CHISELED_WITHERED_BLACKSTONE.comp_349());
        ModLanguageProvider.blockFamily(builder, "Cracked Withered Blackstone").generateFor(ModBlockFamilies.CRACKED_WITHERED_BLACKSTONE_FAMILY);
        ModLanguageProvider.blockFamily(builder, "Warped Nether Brick", "Warped Nether Bricks").generateFor(ModBlockFamilies.WARPED_NETHER_BRICKS_FAMILY);
        builder.add((class_2248)ModBlocks.WITHERED_BASALT.comp_349(), "Withered Basalt");
        builder.add((class_2248)ModBlocks.WITHERED_COAL_BLOCK.comp_349(), "Withered Coal Block");
        builder.add((class_2248)ModBlocks.WITHERED_QUARTZ_BLOCK.comp_349(), "Withered Quartz Block");
        builder.add((class_2248)ModBlocks.WITHERED_DEBRIS.comp_349(), "Withered Debris");
        builder.add((class_2248)ModBlocks.SOUL_STONE.comp_349(), "Soul Stone");
        builder.add((class_2248)ModBlocks.WITHERED_BONE_BLOCK.comp_349(), "Withered Bone Block");
        builder.add((class_2248)ModBlocks.NETHERITE_BELL.comp_349(), "Netherite Bell");
        builder.addSpawnEgg((class_1792)ModItems.WEX_SPAWN_EGG.comp_349(), "Wex");
        builder.addSpawnEgg((class_1792)ModItems.WARPED_ENDERMAN_SPAWN_EGG.comp_349(), "Warped Enderman");
        builder.addSpawnEgg((class_1792)ModItems.PIGLIN_PRISONER_SPAWN_EGG.comp_349(), "Piglin Prisoner");
        builder.addSpawnEgg((class_1792)ModItems.PIGLIN_HUNTER_SPAWN_EGG.comp_349(), "Piglin Hunter");
        builder.addSpawnEgg((class_1792)ModItems.WRAITHER_SPAWN_EGG.comp_349(), "Wraither");
        builder.addSpawnEgg((class_1792)ModItems.WITHER_SKELETON_KNIGHT_SPAWN_EGG.comp_349(), "Wither Skeleton Knight");
        builder.addSpawnEgg((class_1792)ModItems.CORPOR_SPAWN_EGG.comp_349(), "Corpor");
        builder.addSpawnEgg((class_1792)ModItems.WITHER_SKELETON_HORSE_SPAWN_EGG.comp_349(), "Withered Skeleton Horse");
        builder.add((class_2561)ResourceKeyHelper.getComponent(ModItems.WITHER_WALTZ_JUKEBOX_SONG), "Izofar - Wither Waltz");
        builder.add((class_1792)ModItems.WITHER_WALTZ_MUSIC_DISC.comp_349(), "Music Disc");
        builder.add((class_1792)ModItems.WARPED_ENDER_PEARL.comp_349(), "Warped Ender Pearl");
        builder.add((class_1792)ModItems.WITHERED_BONE.comp_349(), "Withered Bone");
        builder.add((class_1792)ModItems.WITHERED_BONE_MEAL.comp_349(), "Withered Bone Meal");
        builder.add((class_1792)ModItems.GILDED_NETHERITE_SHIELD.comp_349(), "Gilded Netherite Shield");
        builder.add((class_1792)ModItems.CUTLASS.comp_349(), "Cutlass");
        builder.add((class_1299)ModEntityTypes.WEX.comp_349(), "Wex");
        builder.add((class_1299)ModEntityTypes.WARPED_ENDERMAN.comp_349(), "Warped Enderman");
        builder.add((class_1299)ModEntityTypes.PIGLIN_PRISONER.comp_349(), "Piglin Prisoner");
        builder.add((class_1299)ModEntityTypes.PIGLIN_HUNTER.comp_349(), "Piglin Hunter");
        builder.add((class_1299)ModEntityTypes.WRAITHER.comp_349(), "Wraither");
        builder.add((class_1299)ModEntityTypes.WITHER_SKELETON_KNIGHT.comp_349(), "Wither Skeleton Knight");
        builder.add((class_1299)ModEntityTypes.CORPOR.comp_349(), "Corpor");
        builder.add((class_1299)ModEntityTypes.WITHER_SKELETON_HORSE.comp_349(), "Withered Skeleton Horse");
        builder.add((class_1299)ModEntityTypes.WARPED_ENDER_PEARL.comp_349(), "Warped Ender Pearl");
        builder.add((class_3414)ModSoundEvents.WEX_CHARGE.comp_349(), "Wex shrieks");
        builder.add((class_3414)ModSoundEvents.WEX_DEATH.comp_349(), "Wex dies");
        builder.add((class_3414)ModSoundEvents.WEX_HURT.comp_349(), "Wex hurts");
        builder.add((class_3414)ModSoundEvents.WEX_AMBIENT.comp_349(), "Wex wexes");
        builder.add((class_3414)ModSoundEvents.WARPED_ENDERMAN_DEATH.comp_349(), "Warped Enderman dies");
        builder.add((class_3414)ModSoundEvents.WARPED_ENDERMAN_HURT.comp_349(), "Warped Enderman hurts");
        builder.add((class_3414)ModSoundEvents.WARPED_ENDERMAN_AMBIENT.comp_349(), "Warped Enderman vwoops");
        builder.add((class_3414)ModSoundEvents.WARPED_ENDERMAN_TELEPORT.comp_349(), "Warped Enderman teleports");
        builder.add((class_3414)ModSoundEvents.WARPED_ENDERMAN_SCREAM.comp_349(), "Warped Enderman screams");
        builder.add((class_3414)ModSoundEvents.WARPED_ENDERMAN_STARE.comp_349(), "Warped Enderman cries out");
        builder.add(ModAdvancementProvider.ROOT_ADVANCEMENT.title(), "Eternal Nether");
        builder.add(ModAdvancementProvider.ROOT_ADVANCEMENT.description(), "Explore the Nether for new structures!");
        builder.add(ModAdvancementProvider.ACQUIRE_WITHER_WALTZ_ADVANCEMENT.title(), "Here I Waltz");
        builder.add(ModAdvancementProvider.ACQUIRE_WITHER_WALTZ_ADVANCEMENT.description(), "Acquire the Wither Waltz Music Disc");
        builder.add(ModAdvancementProvider.CATACOMB_ADVANCEMENT.title(), "To Wither Or Not To Wither");
        builder.add(ModAdvancementProvider.CATACOMB_ADVANCEMENT.description(), "Locate a Catacomb structure");
        builder.add(ModAdvancementProvider.CITADEL_ADVANCEMENT.title(), "The Warping Citadel");
        builder.add(ModAdvancementProvider.CITADEL_ADVANCEMENT.description(), "Locate a Citadel structure");
        builder.add(ModAdvancementProvider.EXPLORE_STRUCTURES_ADVANCEMENT.title(), "Hotter Tourist Destinations");
        builder.add(ModAdvancementProvider.EXPLORE_STRUCTURES_ADVANCEMENT.description(), "Locate all Eternal Nether structures");
        builder.add(ModAdvancementProvider.PIGLIN_MANOR_ADVANCEMENT.title(), "Mind Your Manors");
        builder.add(ModAdvancementProvider.PIGLIN_MANOR_ADVANCEMENT.description(), "Locate a Piglin Manor structure");
        builder.add(ModAdvancementProvider.RIDE_WITHER_SKELETON_HORSE_ADVANCEMENT.title(), "Dark Horse");
        builder.add(ModAdvancementProvider.RIDE_WITHER_SKELETON_HORSE_ADVANCEMENT.description(), "Ride a Wither Skeleton Horse");
        builder.add(ModAdvancementProvider.SUMMON_ENDERMAN_ADVANCEMENT.title(), "A Little Off The Top");
        builder.add(ModAdvancementProvider.SUMMON_ENDERMAN_ADVANCEMENT.description(), "Trim the Warp from a Warped Enderman");
        builder.add(ModAdvancementProvider.RESCUE_PIGLIN_PRISONER_ADVANCEMENT.title(), "Saving Private Swine");
        builder.add(ModAdvancementProvider.RESCUE_PIGLIN_PRISONER_ADVANCEMENT.description(), "Rescue a Piglin Prisoner");
    }

    public static BlockFamilyBuilder blockFamily(AbstractLanguageProvider.TranslationBuilder builder, String blockValue) {
        return new BlockFamilyBuilder((arg_0, arg_1) -> ((AbstractLanguageProvider.TranslationBuilder)builder).add(arg_0, arg_1), blockValue);
    }

    public static BlockFamilyBuilder blockFamily(AbstractLanguageProvider.TranslationBuilder builder, String blockValue, String baseBlockValue) {
        return new BlockFamilyBuilder((arg_0, arg_1) -> ((AbstractLanguageProvider.TranslationBuilder)builder).add(arg_0, arg_1), blockValue, baseBlockValue);
    }

    public static class BlockFamilyBuilder {
        private final BiConsumer<class_2248, String> valueConsumer;
        private final String blockValue;
        private final String baseBlockValue;

        public BlockFamilyBuilder(BiConsumer<class_2248, String> valueConsumer, String blockValue) {
            this(valueConsumer, blockValue, blockValue);
        }

        public BlockFamilyBuilder(BiConsumer<class_2248, String> valueConsumer, String blockValue, String baseBlockValue) {
            this.valueConsumer = valueConsumer;
            this.blockValue = blockValue;
            this.baseBlockValue = baseBlockValue;
        }

        public void generateFor(class_5794 blockFamily) {
            this.baseBlock(blockFamily.method_33469());
            blockFamily.method_33474().forEach((variant, block) -> {
                BiFunction<BlockFamilyBuilder, class_2248, BlockFamilyBuilder> variantFunction = VARIANT_FUNCTIONS.get(variant);
                if (variantFunction != null) {
                    variantFunction.apply(this, (class_2248)block);
                }
            });
        }

        public BlockFamilyBuilder baseBlock(class_2248 block) {
            this.valueConsumer.accept(block, this.baseBlockValue);
            return this;
        }

        public BlockFamilyBuilder button(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Button");
            return this;
        }

        public BlockFamilyBuilder chiseled(class_2248 block) {
            this.valueConsumer.accept(block, "Chiseled " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder cracked(class_2248 block) {
            this.valueConsumer.accept(block, "Cracked " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder cut(class_2248 block) {
            this.valueConsumer.accept(block, "Cut " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder door(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Door");
            return this;
        }

        public BlockFamilyBuilder fence(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Fence");
            return this;
        }

        public BlockFamilyBuilder fenceGate(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Fence Gate");
            return this;
        }

        public BlockFamilyBuilder mosaic(class_2248 block) {
            this.valueConsumer.accept(block, "Mosaic " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder sign(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Sign");
            return this;
        }

        public BlockFamilyBuilder slab(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Slab");
            return this;
        }

        public BlockFamilyBuilder stairs(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Stairs");
            return this;
        }

        public BlockFamilyBuilder pressurePlate(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Pressure Plate");
            return this;
        }

        public BlockFamilyBuilder polished(class_2248 block) {
            this.valueConsumer.accept(block, "Polished " + this.blockValue);
            return this;
        }

        public BlockFamilyBuilder trapdoor(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Trapdoor");
            return this;
        }

        public BlockFamilyBuilder wall(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Wall");
            return this;
        }

        public BlockFamilyBuilder wallSign(class_2248 block) {
            this.valueConsumer.accept(block, this.blockValue + " Wall Sign");
            return this;
        }
    }
}

