/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.render.RenderConfiguration;
import com.supermartijn642.core.render.RenderStateConfiguration;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_290;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final RenderConfiguration LINES = RenderConfiguration.create("supermartijn642corelib", "lines", class_290.field_29337, RenderConfiguration.PrimitiveType.TRIANGLE_LINES, 128, true, true, RenderStateConfiguration.builder().useShader(class_757::method_34535).useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());
    private static final RenderConfiguration LINES_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "lines_no_depth", class_290.field_29337, RenderConfiguration.PrimitiveType.TRIANGLE_LINES, 128, true, true, RenderStateConfiguration.builder().useShader(class_757::method_34535).useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().disableDepthTest().disableDepthMask().build());
    private static final RenderConfiguration QUADS = RenderConfiguration.create("supermartijn642corelib", "quads", class_290.field_1576, RenderConfiguration.PrimitiveType.QUADS, 256, false, true, RenderStateConfiguration.builder().useShader(class_757::method_34540).useTranslucentTransparency().disableTexture().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());
    private static final RenderConfiguration QUADS_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "quads_no_depth", class_290.field_1576, RenderConfiguration.PrimitiveType.QUADS, 256, false, true, RenderStateConfiguration.builder().useShader(class_757::method_34540).useTranslucentTransparency().disableTexture().disableCulling().disableDepthTest().disableDepthMask().build());

    public static class_243 getCameraPosition() {
        return ClientUtils.getMinecraft().method_1561().field_4686.method_19326();
    }

    public static class_4597.class_4598 getMainBufferSource() {
        return ClientUtils.getMinecraft().method_22940().method_23000();
    }

    public static void renderShape(class_4587 poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? LINES : LINES_NO_DEPTH;
        class_4597.class_4598 bufferSource = RenderUtils.getMainBufferSource();
        class_4588 builder = renderConfiguration.begin((class_4597)bufferSource);
        class_4587.class_4665 pose = poseStack.method_23760();
        Matrix4f matrix = pose.method_23761();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            class_243 normal = new class_243(x2 - x1, y2 - y1, z2 - z1);
            normal.method_1029();
            builder.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_22915(red, green, blue, alpha).method_60831(pose, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
            builder.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_22915(red, green, blue, alpha).method_60831(pose, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
        });
        renderConfiguration.end(bufferSource);
    }

    public static void renderShapeSides(class_4587 poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? QUADS : QUADS_NO_DEPTH;
        class_4597.class_4598 bufferSource = RenderUtils.getMainBufferSource();
        class_4588 builder = renderConfiguration.begin((class_4597)bufferSource);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        shape.forEachBox(box -> {
            float minX = (float)box.field_1323;
            float maxX = (float)box.field_1320;
            float minY = (float)box.field_1322;
            float maxY = (float)box.field_1325;
            float minZ = (float)box.field_1321;
            float maxZ = (float)box.field_1324;
            builder.method_22918(matrix, minX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, minY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, minX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha);
            builder.method_22918(matrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha);
        });
        renderConfiguration.end(bufferSource);
    }

    public static void renderShape(class_4587 poseStack, class_265 shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderShapeSides(class_4587 poseStack, class_265 shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderBox(class_4587 poseStack, class_238 box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderBoxSides(class_4587 poseStack, class_238 box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderShape(class_4587 poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(class_4587 poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShape(class_4587 poseStack, class_265 shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(class_4587 poseStack, class_265 shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBox(class_4587 poseStack, class_238 box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBoxSides(class_4587 poseStack, class_238 box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }
}

