/*
 * Decompiled with CFR 0.152.
 */
package com.logprot.players;

import com.logprot.Logprot;
import com.logprot.config.CommonConfiguration;
import com.logprot.players.PlayerData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class PlayerManager {
    private static PlayerManager instance;
    private Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();

    private PlayerManager() {
    }

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }

    public void onPlayerLogin(class_1657 player) {
        this.playerDataMap.put(player.method_5667(), new PlayerData(player, player.method_24515(), System.currentTimeMillis() + (long)(((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime / 20) * 1000L));
        if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
            Logprot.LOGGER.info("Player:" + player.method_5477().getString() + " now has login protection for " + ((CommonConfiguration)Logprot.config.getCommonConfig()).invulTime + " ticks");
        }
    }

    public void updatePlayers() {
        if (this.playerDataMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, PlayerData>> iterator = this.playerDataMap.entrySet().iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PlayerData> entry = iterator.next();
            if (!entry.getValue().player.method_5805()) {
                iterator.remove();
                break;
            }
            if (entry.getValue().invulTimePoint > currentTime) continue;
            if (((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
                Logprot.LOGGER.info("Player:" + entry.getValue().player.method_5477().getString() + " got their login protection removed due to timeout");
            }
            entry.getValue().player.field_6235 = 0;
            iterator.remove();
        }
    }

    public boolean isPlayerImmune(class_1657 playerEntity, class_1282 source) {
        if (this.playerDataMap.isEmpty()) {
            return false;
        }
        if (source == playerEntity.method_48923().method_48827() && ((CommonConfiguration)Logprot.config.getCommonConfig()).ignoreFallDamage) {
            return false;
        }
        this.updatePlayers();
        return this.playerDataMap.containsKey(playerEntity.method_5667());
    }

    public void removeProtection(class_3222 player) {
        if (player != null && this.playerDataMap.containsKey(player.method_5667()) && this.playerDataMap.remove(player.method_5667()) != null && ((CommonConfiguration)Logprot.config.getCommonConfig()).debugOutput) {
            Logprot.LOGGER.info("Player:" + player.method_5477().getString() + " got their login protection removed due to activity");
        }
    }
}

