/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.mixin.BlockBehaviourAccessor;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2541;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2975;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3719;
import net.minecraft.class_3773;
import net.minecraft.class_4538;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6801;
import net.minecraft.class_7924;

public abstract class BetterMineshaftPiece
extends class_3443 {
    public BetterMineshaftConfiguration config;
    protected static final class_2680 AIR = class_2246.field_10124.method_9564();

    public BetterMineshaftPiece(class_3773 structurePieceType, int chainLength, BetterMineshaftConfiguration config, class_3341 boundingBox) {
        super(structurePieceType, chainLength, boundingBox);
        this.config = config;
    }

    public BetterMineshaftPiece(class_3773 structurePieceType, class_2487 compoundTag) {
        super(structurePieceType, compoundTag);
        this.config = new BetterMineshaftConfiguration(compoundTag.method_10583("replacementRate"), BetterMineshaftConfiguration.LegVariant.byId(compoundTag.method_10550("legVariantIndex")), new BetterMineshaftConfiguration.MineshaftDecorationChances(compoundTag.method_10583("vineChance"), compoundTag.method_10583("snowChance"), compoundTag.method_10583("cactusChance"), compoundTag.method_10583("deadBushChance"), compoundTag.method_10583("mushroomChance"), compoundTag.method_10583("gravelPileChance"), compoundTag.method_10577("lushDecorations"), compoundTag.method_10577("dripstoneDecorations")), new BetterMineshaftConfiguration.MineshaftBlockStates((class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("mainBlockId")), (class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("supportBlockId")), (class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("slabBlockId")), (class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("gravelBlockId")), (class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("stoneWallBlockId")), (class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("stoneSlabBlockId")), (class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("trapdoorBlockId")), (class_2680)class_2248.field_10651.method_10200(compoundTag.method_10550("smallLegBlockId"))), new BetterMineshaftConfiguration.MineshaftBlockstateRandomizers(new BlockStateRandomizer(compoundTag.method_10562("mainSelector")), new BlockStateRandomizer(compoundTag.method_10562("floorSelector")), new BlockStateRandomizer(compoundTag.method_10562("brickSelector")), new BlockStateRandomizer(compoundTag.method_10562("legSelector"))));
    }

    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        compoundTag.method_10548("replacementRate", this.config.replacementRate);
        compoundTag.method_10569("legVariantIndex", this.config.legVariant.ordinal());
        compoundTag.method_10548("vineChance", this.config.decorationChances.vineChance);
        compoundTag.method_10548("snowChance", this.config.decorationChances.snowChance);
        compoundTag.method_10548("cactusChance", this.config.decorationChances.cactusChance);
        compoundTag.method_10548("deadBushChance", this.config.decorationChances.deadBushChance);
        compoundTag.method_10548("mushroomChance", this.config.decorationChances.mushroomChance);
        compoundTag.method_10548("gravelPileChance", this.config.decorationChances.gravelPileChance);
        compoundTag.method_10556("lushDecorations", this.config.decorationChances.lushDecorations);
        compoundTag.method_10556("dripstoneDecorations", this.config.decorationChances.dripstoneDecorations);
        compoundTag.method_10569("mainBlockId", class_2248.field_10651.method_10206((Object)this.config.blockStates.mainBlockState));
        compoundTag.method_10569("supportBlockId", class_2248.field_10651.method_10206((Object)this.config.blockStates.supportBlockState));
        compoundTag.method_10569("slabBlockId", class_2248.field_10651.method_10206((Object)this.config.blockStates.slabBlockState));
        compoundTag.method_10569("gravelBlockId", class_2248.field_10651.method_10206((Object)this.config.blockStates.gravelBlockState));
        compoundTag.method_10569("stoneWallBlockId", class_2248.field_10651.method_10206((Object)this.config.blockStates.stoneWallBlockState));
        compoundTag.method_10569("stoneSlabBlockId", class_2248.field_10651.method_10206((Object)this.config.blockStates.stoneSlabBlockState));
        compoundTag.method_10569("trapdoorBlockId", class_2248.field_10651.method_10206((Object)this.config.blockStates.trapdoorBlockState));
        compoundTag.method_10569("smallLegBlockId", class_2248.field_10651.method_10206((Object)this.config.blockStates.smallLegBlockState));
        compoundTag.method_10566("mainSelector", (class_2520)this.config.blockStateRandomizers.mainRandomizer.saveTag());
        compoundTag.method_10566("floorSelector", (class_2520)this.config.blockStateRandomizers.floorRandomizer.saveTag());
        compoundTag.method_10566("brickSelector", (class_2520)this.config.blockStateRandomizers.brickRandomizer.saveTag());
        compoundTag.method_10566("legSelector", (class_2520)this.config.blockStateRandomizers.legRandomizer.saveTag());
    }

    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource) {
    }

    protected boolean addBarrel(class_5281 world, class_3341 boundingBox, class_5819 randomSource, class_2338 pos, class_5321<class_52> lootTableId) {
        if (boundingBox.method_14662((class_2382)pos) && world.method_8320(pos).method_26204() != class_2246.field_16328) {
            world.method_8652(pos, (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036), 2);
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_3719) {
                class_3719 barrelBlockEntity = (class_3719)blockEntity;
                barrelBlockEntity.method_54867(lootTableId, randomSource.method_43055());
            }
            return true;
        }
        return false;
    }

    protected boolean addBarrel(class_5281 world, class_3341 boundingBox, class_5819 randomSource, int x, int y, int z, class_5321<class_52> lootTableId) {
        return this.addBarrel(world, boundingBox, randomSource, (class_2338)this.method_33781(x, y, z), lootTableId);
    }

    protected void addVines(class_5281 world, class_3341 boundingBox, class_2350 facing, class_5819 randomSource, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutable.method_10103(this.method_14928(x, z), this.method_14924(y), this.method_14941(x, z)).method_10098(facing);
                    class_2680 nextBlock = this.method_14929((class_1922)world, x + facing.method_10148(), y + facing.method_10164(), z + facing.method_10165(), boundingBox);
                    if (!this.method_14929((class_1922)world, x, y, z, boundingBox).method_26215() || !class_2248.method_9501((class_265)nextBlock.method_26220((class_1922)world, (class_2338)mutable), (class_2350)facing.method_10153()) || nextBlock.method_26204().method_9564() == class_2246.field_9983.method_9564() || !(randomSource.method_43057() < chance)) continue;
                    this.method_14917(world, (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)class_2541.method_10828((class_2350)(facing.method_10166() == class_2350.class_2351.field_11048 ? facing : facing.method_10153())), (Comparable)Boolean.valueOf(true)), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void addVines(class_5281 world, class_3341 boundingBox, class_5819 randomSource, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.addVines(world, boundingBox, class_2350.field_11034, randomSource, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11039, randomSource, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11043, randomSource, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, class_2350.field_11035, randomSource, chance, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void addBiomeDecorations(class_5281 world, class_3341 box, class_5819 randomSource, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        class_2378 registry = (class_2378)world.method_30349().method_33310(class_7924.field_41239).get();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338.class_2339 blockPos = this.method_33781(x, y, z);
                    class_2680 state = this.method_14929((class_1922)world, x, y, z, box);
                    class_2680 stateBelow = this.method_14929((class_1922)world, x, y - 1, z, box);
                    if (this.config.decorationChances.snowChance > 0.0f && randomSource.method_43057() < this.config.decorationChances.snowChance && state.method_26215() && ((BlockBehaviourAccessor)class_2246.field_10477).callCanSurvive(AIR, (class_4538)world, (class_2338)blockPos)) {
                        this.method_14917(world, (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2741.field_12536, (Comparable)Integer.valueOf(randomSource.method_43048(2) + 1)), x, y, z, box);
                    }
                    if (this.config.decorationChances.lushDecorations) {
                        if (box.method_14662((class_2382)blockPos) && randomSource.method_43057() < 0.005f) {
                            ((class_2975)registry.method_29107(class_6801.field_35782)).method_12862(world, world.method_8410().method_14178().method_12129(), randomSource, (class_2338)blockPos);
                        }
                        if (box.method_14662((class_2382)blockPos) && randomSource.method_43057() < 0.005f) {
                            ((class_2975)registry.method_29107(class_6801.field_35787)).method_12862(world, world.method_8410().method_14178().method_12129(), randomSource, (class_2338)blockPos);
                        }
                        if (box.method_14662((class_2382)blockPos) && randomSource.method_43057() < 0.005f) {
                            ((class_2975)registry.method_29107(class_6801.field_35788)).method_12862(world, world.method_8410().method_14178().method_12129(), randomSource, (class_2338)blockPos);
                        }
                        if (stateBelow.method_27852(this.config.blockStates.mainBlockState.method_26204()) && state.method_26215() && stateBelow.method_26206((class_1922)world, blockPos.method_10074(), class_2350.field_11036)) {
                            this.method_14917(world, class_2246.field_28680.method_9564(), x, y, z, box);
                        }
                    }
                    if (this.config.decorationChances.dripstoneDecorations) {
                        if (box.method_14662((class_2382)blockPos) && randomSource.method_43057() < 0.02f) {
                            ((class_2975)registry.method_29107(class_6801.field_35773)).method_12862(world, world.method_8410().method_14178().method_12129(), randomSource, (class_2338)blockPos);
                        }
                        if (box.method_14662((class_2382)blockPos) && randomSource.method_43057() < 0.02f) {
                            ((class_2975)registry.method_29107(class_6801.field_35775)).method_12862(world, world.method_8410().method_14178().method_12129(), randomSource, (class_2338)blockPos);
                        }
                    }
                    if (this.config.decorationChances.cactusChance > 0.0f && randomSource.method_43057() < this.config.decorationChances.cactusChance && state.method_26215() && ((BlockBehaviourAccessor)class_2246.field_10029).callCanSurvive(AIR, (class_4538)world, (class_2338)blockPos)) {
                        this.method_14917(world, (class_2680)class_2246.field_10029.method_9564().method_11657((class_2769)class_2741.field_12498, (Comparable)Integer.valueOf(0)), x, y, z, box);
                        if (randomSource.method_43057() < 0.5f && this.method_14929((class_1922)world, x, y + 1, z, box).method_27852(class_2246.field_10124)) {
                            this.method_14917(world, (class_2680)class_2246.field_10029.method_9564().method_11657((class_2769)class_2741.field_12498, (Comparable)Integer.valueOf(0)), x, y + 1, z, box);
                        }
                    }
                    if (this.config.decorationChances.deadBushChance > 0.0f && randomSource.method_43057() < this.config.decorationChances.deadBushChance && state.method_26215() && (stateBelow.method_27852(class_2246.field_10102) || stateBelow.method_27852(class_2246.field_10534) || stateBelow.method_27852(class_2246.field_10415) || stateBelow.method_27852(class_2246.field_10611) || stateBelow.method_27852(class_2246.field_10184) || stateBelow.method_27852(class_2246.field_10143) || stateBelow.method_27852(class_2246.field_10123) || stateBelow.method_27852(class_2246.field_10566))) {
                        this.method_14917(world, class_2246.field_10428.method_9564(), x, y, z, box);
                    }
                    if (!(this.config.decorationChances.mushroomChance > 0.0f) || !state.method_26215() || !((BlockBehaviourAccessor)class_2246.field_10559).callCanSurvive(AIR, (class_4538)world, (class_2338)blockPos)) continue;
                    float r = randomSource.method_43057();
                    if (r < this.config.decorationChances.mushroomChance / 2.0f) {
                        this.method_14917(world, class_2246.field_10559.method_9564(), x, y, z, box);
                        continue;
                    }
                    if (!(r < this.config.decorationChances.mushroomChance)) continue;
                    this.method_14917(world, class_2246.field_10251.method_9564(), x, y, z, box);
                }
            }
        }
    }

    protected void generateLeg(class_5281 world, class_5819 randomSource, class_3341 box, int x, int z, BlockStateRandomizer selector) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, -1, z);
        class_2680 state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        while (this.method_14924(mutable.method_10264()) > world.method_31607() + 1 && this.method_33881(state)) {
            this.method_14917(world, selector.get(randomSource), x, mutable.method_10264(), z, box);
            mutable.method_10098(class_2350.field_11033);
            state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        }
    }

    protected boolean generateLegOrChain(class_5281 world, class_5819 randomSource, class_3341 box, int x, int z, BlockStateRandomizer selector) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, -1, z);
        class_2680 state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        boolean lavaBelow = false;
        while (this.method_14924(mutable.method_10264()) > world.method_31607() + 1 && this.method_33881(state)) {
            if (state.method_27852(class_2246.field_10164)) {
                lavaBelow = true;
                break;
            }
            mutable.method_10098(class_2350.field_11033);
            state = this.method_14929((class_1922)world, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), box);
        }
        if (lavaBelow) {
            mutable = this.method_33781(x, 0, z);
            if (!this.field_15315.method_14662((class_2382)mutable)) {
                return false;
            }
            int realChainY = this.method_14924(0);
            int length = 1;
            boolean canGenerateChain = true;
            while (canGenerateChain) {
                if (canGenerateChain) {
                    mutable.method_33098(realChainY + length);
                    class_2680 currBlock = world.method_8320((class_2338)mutable);
                    boolean currBlockCanBeReplaced = this.method_33881(currBlock);
                    if (!currBlockCanBeReplaced && this.canHangChainBelow((class_4538)world, (class_2338)mutable, currBlock)) {
                        world.method_8652((class_2338)mutable.method_33098(realChainY + 1), this.config.blockStates.supportBlockState, 2);
                        BetterMineshaftPiece.fillColumnBetween(world, class_2246.field_23985.method_9564(), mutable, realChainY + 2, realChainY + length);
                        return false;
                    }
                    canGenerateChain = length <= 50 && currBlockCanBeReplaced && mutable.method_10264() < world.method_31600() - 1;
                }
                ++length;
            }
        } else {
            this.generateLeg(world, randomSource, box, x, z, selector);
            return true;
        }
        return false;
    }

    protected void generatePillarDownOrChainUp(class_5281 world, class_5819 randomSource, class_3341 boundingBox, int x, int z, int pillarStartY, int chainStartY, class_2680 chainBlock) {
        class_2338.class_2339 mutable = this.method_33781(x, pillarStartY, z);
        if (!boundingBox.method_14662((class_2382)mutable)) {
            return;
        }
        int realPillarY = this.method_14924(pillarStartY);
        int realChainY = this.method_14924(chainStartY);
        int length = 1;
        boolean canGenerateLeg = true;
        boolean canGenerateChain = true;
        while (canGenerateLeg || canGenerateChain) {
            boolean currBlockCanBeReplaced;
            class_2680 currBlock;
            if (canGenerateLeg) {
                mutable.method_33098(realPillarY - length);
                currBlock = world.method_8320((class_2338)mutable);
                boolean bl = currBlockCanBeReplaced = this.method_33881(currBlock) && !currBlock.method_27852(class_2246.field_10164);
                if (!currBlockCanBeReplaced && this.canPlaceColumnOnTopOf(currBlock)) {
                    BetterMineshaftPiece.fillColumnBetween(world, this.config.blockStates.smallLegBlockState, mutable, realPillarY - length + 1, realPillarY);
                    return;
                }
                boolean bl2 = canGenerateLeg = length <= 20 && currBlockCanBeReplaced && mutable.method_10264() > world.method_31607() + 1;
            }
            if (canGenerateChain) {
                mutable.method_33098(realChainY + length);
                currBlock = world.method_8320((class_2338)mutable);
                currBlockCanBeReplaced = this.method_33881(currBlock);
                if (!currBlockCanBeReplaced && this.canHangChainBelow((class_4538)world, (class_2338)mutable, currBlock)) {
                    world.method_8652((class_2338)mutable.method_33098(realChainY + 1), chainBlock, 2);
                    BetterMineshaftPiece.fillColumnBetween(world, class_2246.field_23985.method_9564(), mutable, realChainY + 2, realChainY + length);
                    return;
                }
                canGenerateChain = length <= 50 && currBlockCanBeReplaced && mutable.method_10264() < world.method_31600() - 1;
            }
            ++length;
        }
    }

    protected void generatePillarDownOrChainUp(class_5281 world, class_5819 randomSource, class_3341 boundingBox, int x, int y, int z) {
        this.generatePillarDownOrChainUp(world, randomSource, boundingBox, x, z, y, y, this.config.blockStates.supportBlockState);
    }

    private boolean canPlaceColumnOnTopOf(class_2680 blockState) {
        return !blockState.method_27852(class_2246.field_10167) && !blockState.method_27852(class_2246.field_10164);
    }

    private boolean canHangChainBelow(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        return class_2248.method_20044((class_4538)levelReader, (class_2338)blockPos, (class_2350)class_2350.field_11033) && !(blockState.method_26204() instanceof class_2346);
    }

    protected boolean method_33881(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_51176() || blockState.method_27852(class_2246.field_28411) || blockState.method_27852(class_2246.field_10376) || blockState.method_27852(class_2246.field_10238) || blockState.method_27852(class_2246.field_28048) || blockState.method_27852(class_2246.field_28675) || blockState.method_27852(class_2246.field_28676) || blockState.method_27852(class_2246.field_28680) || blockState.method_27852(class_2246.field_10477);
    }

    protected void fill(class_5281 world, class_3341 boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.method_14929((class_1922)world, x, y, z, boundingBox) == class_2246.field_23985.method_9564() || !blockState.method_26184((class_4538)world, (class_2338)this.method_33781(x, y, z))) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void fill(class_5281 world, class_3341 boundingBox, class_5819 randomSource, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockStateRandomizer selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 blockState;
                    if (this.method_14929((class_1922)world, x, y, z, boundingBox) == class_2246.field_23985.method_9564() || !(blockState = selector.get(randomSource)).method_26184((class_4538)world, (class_2338)this.method_33781(x, y, z))) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void replaceAirOrChains(class_5281 world, class_3341 boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox);
                    if (currState == null || !currState.method_26215() && currState != class_2246.field_23985.method_9564() || !blockState.method_26184((class_4538)world, (class_2338)this.method_33781(x, y, z))) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void replaceAirOrChains(class_5281 world, class_3341 boundingBox, class_5819 randomSource, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockStateRandomizer selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 blockState;
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox);
                    if (currState == null || !currState.method_26215() && currState != class_2246.field_23985.method_9564() || !(blockState = selector.get(randomSource)).method_26184((class_4538)world, (class_2338)this.method_33781(x, y, z))) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected static void fillColumnBetween(class_5281 worldGenLevel, class_2680 blockState, class_2338.class_2339 mutableBlockPos, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            worldGenLevel.method_8652((class_2338)mutableBlockPos.method_33098(y), blockState, 2);
        }
    }

    protected static void fillColumnBetween(class_5281 worldGenLevel, class_5819 randomSource, BlockStateRandomizer selector, class_2338.class_2339 mutableBlockPos, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            worldGenLevel.method_8652((class_2338)mutableBlockPos.method_33098(y), selector.get(randomSource), 2);
        }
    }

    protected void chanceFill(class_5281 world, class_3341 boundingBox, class_5819 randomSource, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(randomSource.method_43057() < chance) || !blockState.method_26184((class_4538)world, (class_2338)this.method_33781(x, y, z))) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceFill(class_5281 world, class_3341 boundingBox, class_5819 randomSource, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockStateRandomizer selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(randomSource.method_43057() < chance)) continue;
                    this.method_14917(world, selector.get(randomSource), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(class_5281 world, class_3341 boundingBox, class_5819 randomSource, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState;
                    if (!(randomSource.method_43057() < chance) || (currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox)) == null || !currState.method_26215()) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(class_5281 world, class_3341 boundingBox, class_5819 randomSource, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox);
                    if (currState == null || currState == class_2246.field_23985.method_9564() || !currState.method_51176() && (!(randomSource.method_43057() < chance) || currState.method_26215())) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(class_5281 world, class_3341 boundingBox, class_5819 randomSource, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockStateRandomizer selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox);
                    if (currState == null || currState == class_2246.field_23985.method_9564() || !currState.method_51176() && (!(randomSource.method_43057() < chance) || currState.method_26215())) continue;
                    class_2680 blockState = selector.get(randomSource);
                    if (currState.method_51176()) {
                        for (int numAttempts = 0; (blockState == class_2246.field_10124.method_9564() || blockState == class_2246.field_10543.method_9564()) && numAttempts < 10; ++numAttempts) {
                            blockState = selector.get(randomSource);
                        }
                    }
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceSolid(class_5281 world, class_3341 boundingBox, class_5819 randomSource, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 currState;
                    if (!(randomSource.method_43057() < chance) || (currState = this.getBlockAtFixed((class_1922)world, x, y, z, boundingBox)) == null || currState == class_2246.field_23985.method_9564() || !currState.method_51367()) continue;
                    this.method_14917(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceAddBlock(class_5281 world, class_5819 randomSource, float chance, class_2680 block, int x, int y, int z, class_3341 boundingBox) {
        if (randomSource.method_43057() < chance && block.method_26184((class_4538)world, (class_2338)this.method_33781(x, y, z))) {
            this.method_14917(world, block, x, y, z, boundingBox);
        }
    }

    protected void chanceReplaceAir(class_5281 world, class_5819 randomSource, float chance, class_2680 block, int x, int y, int z, class_3341 boundingBox) {
        if (randomSource.method_43057() < chance && block.method_26184((class_4538)world, (class_2338)this.method_33781(x, y, z)) && block.method_27852(class_2246.field_10124) || block.method_27852(class_2246.field_10543)) {
            this.method_14917(world, block, x, y, z, boundingBox);
        }
    }

    protected class_2680 getBlockAtFixed(class_1922 blockGetter, int x, int y, int z, class_3341 boundingBox) {
        class_2338.class_2339 blockPos = this.method_33781(x, y, z);
        return !boundingBox.method_14662((class_2382)blockPos) ? null : blockGetter.method_8320((class_2338)blockPos);
    }
}

