/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.level.material;

import com.stereowalker.unionlib.util.math.Funcs;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1690;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public abstract class FluidProperties {
    public static final Map<class_3611, FluidProperties> fluidProps = new HashMap<class_3611, FluidProperties>();

    public static FluidProperties fromFluid(class_3611 fluid) {
        return fluidProps.getOrDefault(fluid, null);
    }

    public static <T> T or(class_3611 fluid, Function<FluidProperties, T> func, T or) {
        if (fluidProps.containsKey(fluid)) {
            return func.apply(fluidProps.get(fluid));
        }
        return or;
    }

    public static Builder create(class_2960 name) {
        Builder b = new Builder();
        b.name = name;
        return b;
    }

    public abstract class_2960 name();

    public class_2960 stillTexture() {
        return null;
    }

    public class_2960 flowingTexture() {
        return null;
    }

    public class_2960 overlayTexture() {
        return null;
    }

    public int tintColor() {
        return -1;
    }

    public int tintColor(class_3610 state, class_1920 getter, class_2338 pos) {
        return this.tintColor();
    }

    public double motionScale(class_1297 entity) {
        return 0.014;
    }

    public boolean canPushEntity(class_1297 entity) {
        return true;
    }

    public boolean canSwim(class_1297 entity) {
        return true;
    }

    public float fallDistanceModifier(class_1297 entity) {
        return 0.5f;
    }

    public boolean canExtinguish(class_1297 entity) {
        return false;
    }

    public boolean move(class_3610 state, class_1309 entity, class_243 movementVector, double gravity) {
        return false;
    }

    public boolean canDrownIn(class_1309 entity) {
        return true;
    }

    public void itemMovement(class_1542 entity) {
        class_243 vec3 = entity.method_18798();
        entity.method_18800(vec3.field_1352 * (double)0.99f, vec3.field_1351 + (double)(vec3.field_1351 < (double)0.06f ? 5.0E-4f : 0.0f), vec3.field_1350 * (double)0.99f);
    }

    public boolean supportsBoats(class_1690 boat) {
        return false;
    }

    public boolean supportsBoats(class_3610 state, class_1690 boat) {
        return this.supportsBoats(boat);
    }

    public static class Builder {
        int tint = -1;
        float fallDistanceModifier = 0.5f;
        double motionScale = 0.014;
        boolean supportsBoats = false;
        boolean canPushEntity = true;
        boolean canSwim = true;
        boolean canDrownIn = true;
        boolean canExtinguish = true;
        class_2960 name;
        class_2960 stillTexture = null;
        class_2960 flowingTexture = null;
        class_2960 overlayTexture = null;
        Funcs._3<class_3610, class_1920, class_2338, Integer> tint2 = (a, b, c) -> this.tint;
        Funcs._4<class_3610, class_1309, class_243, Double, Boolean> move = (a, b, c, d) -> false;
        Consumer<class_1542> itemMovement = entity -> {
            class_243 vec3 = entity.method_18798();
            entity.method_18800(vec3.field_1352 * (double)0.99f, vec3.field_1351 + (double)(vec3.field_1351 < (double)0.06f ? 5.0E-4f : 0.0f), vec3.field_1350 * (double)0.99f);
        };

        private Builder() {
        }

        public Builder stillTexture(class_2960 tex) {
            this.stillTexture = tex;
            return this;
        }

        public Builder flowingTexture(class_2960 tex) {
            this.flowingTexture = tex;
            return this;
        }

        public Builder overlayTexture(class_2960 text) {
            this.overlayTexture = text;
            return this;
        }

        public Builder motionScale(double motionScale) {
            this.motionScale = motionScale;
            return this;
        }

        public Builder canPushEntity(boolean canPushEntity) {
            this.canPushEntity = canPushEntity;
            return this;
        }

        public Builder canSwim(boolean canSwim) {
            this.canSwim = canSwim;
            return this;
        }

        public Builder canExtinguish(boolean val) {
            this.canExtinguish = val;
            return this;
        }

        public Builder canDrownIn(boolean val) {
            this.canDrownIn = val;
            return this;
        }

        public Builder tint(int tint) {
            this.tint = tint;
            return this;
        }

        public Builder supportsBoats(boolean val) {
            this.supportsBoats = val;
            return this;
        }

        public Builder tint(Funcs._3<class_3610, class_1920, class_2338, Integer> tint) {
            this.tint2 = tint;
            return this;
        }

        public Builder customMovement(Funcs._4<class_3610, class_1309, class_243, Double, Boolean> move) {
            this.move = move;
            return this;
        }

        public Builder fallDistanceModifier(float val) {
            this.fallDistanceModifier = val;
            return this;
        }

        public FluidProperties toProperties() {
            return new FluidProperties(){

                @Override
                public class_2960 name() {
                    return name;
                }

                @Override
                public class_2960 stillTexture() {
                    return stillTexture;
                }

                @Override
                public class_2960 flowingTexture() {
                    return flowingTexture;
                }

                @Override
                public class_2960 overlayTexture() {
                    return overlayTexture;
                }

                @Override
                public boolean canPushEntity(class_1297 entity) {
                    return canPushEntity;
                }

                @Override
                public boolean canSwim(class_1297 entity) {
                    return canSwim;
                }

                @Override
                public boolean canExtinguish(class_1297 entity) {
                    return canExtinguish;
                }

                @Override
                public boolean canDrownIn(class_1309 entity) {
                    return canDrownIn;
                }

                @Override
                public double motionScale(class_1297 entity) {
                    return motionScale;
                }

                @Override
                public float fallDistanceModifier(class_1297 entity) {
                    return fallDistanceModifier;
                }

                @Override
                public int tintColor() {
                    return tint;
                }

                @Override
                public int tintColor(class_3610 state, class_1920 getter, class_2338 pos) {
                    return tint2.apply(state, getter, pos);
                }

                @Override
                public boolean move(class_3610 state, class_1309 entity, class_243 movementVector, double gravity) {
                    return move.apply(state, entity, movementVector, gravity);
                }

                @Override
                public void itemMovement(class_1542 entity) {
                    itemMovement.accept(entity);
                }

                @Override
                public boolean supportsBoats(class_1690 boat) {
                    return supportsBoats;
                }
            };
        }
    }
}

