/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util.toml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TomlWriter {
    final File file;
    final Map<String, Pair<Object, String>> values = new HashMap<String, Pair<Object, String>>();

    public TomlWriter(File file) {
        this.file = file;
    }

    public TomlWriter put(String key, Object value) {
        this.values.put(key, new Pair<Object, String>(value, ""));
        return this;
    }

    public TomlWriter put(String key, Object value, String comment) {
        this.values.put(key, new Pair<Object, String>(value, comment));
        return this;
    }

    public <V extends Comparable<? super V>> TomlWriter putRanged(String key, V value, V min, V max, Class<V> clazz) {
        return this.putRanged(key, value, min, max, clazz, "");
    }

    public <V extends Comparable<? super V>> TomlWriter putRanged(String key, V value, V min, V max, Class<V> clazz, String comment) {
        String range = comment + (comment.length() > 0 ? "\n" : "") + "Range: " + String.valueOf(min) + " ~ " + String.valueOf(max);
        return this.put(key, value, range);
    }

    public <V extends Enum<V>> TomlWriter putEnum(String key, V value) {
        return this.putEnum(key, value, "");
    }

    public <V extends Enum<V>> TomlWriter putEnum(String key, V value, String comment) {
        List<Enum> acceptableValues = Arrays.asList((Enum[])value.getDeclaringClass().getEnumConstants());
        Object range = comment + (comment.length() > 0 ? "\n" : "") + "Allowed Values: ";
        for (Object e : acceptableValues) {
            range = (String)range + String.valueOf(e) + ", ";
        }
        range = ((String)range).substring(0, ((String)range).length() - 2);
        return this.put(key, value, (String)range);
    }

    public void update(String key, Object value) {
        if (this.values.containsKey(key)) {
            this.values.get(key).setA(value);
        } else {
            System.err.println("Cannot update " + key + " because it's not in the toml file");
        }
    }

    public String build() {
        Object ret = "";
        ArrayList<Pair<String, Pair>> sorted = new ArrayList<Pair<String, Pair>>();
        HashMap valuesClone = new HashMap();
        this.values.forEach((k, v) -> valuesClone.put(k, v));
        while (valuesClone.size() > 0) {
            ArrayList<String> removedKeys = new ArrayList<String>();
            String table = "";
            for (String key : valuesClone.keySet()) {
                if (key.contains(".")) {
                    String table1 = key.split("\\.")[0];
                    if (table1.isEmpty() || !table1.equals(table) && !table.isEmpty()) continue;
                    table = table1;
                    sorted.add(new Pair<String, Pair>(key, (Pair)valuesClone.get(key)));
                    removedKeys.add(key);
                    continue;
                }
                sorted.add(new Pair<String, Pair>(key, (Pair)valuesClone.get(key)));
                removedKeys.add(key);
            }
            removedKeys.forEach(valuesClone::remove);
        }
        String lastTable = "";
        for (Pair pair : sorted) {
            String tab;
            String key;
            key = (String)pair.A();
            String currentTable = "";
            if (((String)pair.A()).contains(".")) {
                currentTable = ((String)pair.A()).split("\\.")[0];
                if (!lastTable.equals(currentTable)) {
                    lastTable = currentTable;
                    ret = currentTable.contains(" ") ? (String)ret + "[\"" + currentTable + "\"]\n" : (String)ret + "[" + currentTable + "]\n";
                }
                key = key.split(currentTable + "\\.")[1];
            } else {
                currentTable = "";
            }
            String string = tab = currentTable.isEmpty() ? "" : "\t";
            if (!((String)((Pair)pair.B()).B()).isEmpty()) {
                ret = (String)ret + tab + "#" + ((String)((Pair)pair.B()).B()).replaceAll("\n", "\n" + tab + "#") + "\n";
            }
            Object contents = ((Pair)pair.B()).A() instanceof String || ((Pair)pair.B()).A() instanceof Enum ? "\"" + String.valueOf(((Pair)pair.B()).A()) + "\"" : String.valueOf(((Pair)pair.B()).A());
            Object object = ((Pair)pair.B()).A();
            if (object instanceof List) {
                List list = (List)object;
                contents = "[";
                for (Object o : list) {
                    contents = (String)contents + (o instanceof String || ((Pair)pair.B()).A() instanceof Enum ? "\"" + String.valueOf(o) + "\"" : String.valueOf(o)) + ", ";
                }
                if (!list.isEmpty()) {
                    contents = ((String)contents).substring(0, ((String)contents).length() - 2) + "]";
                }
            }
            if (key.contains(" ")) {
                ret = (String)ret + tab + "\"" + key + "\" = " + (String)contents + "\n";
                continue;
            }
            ret = (String)ret + tab + key + " = " + (String)contents + "\n";
        }
        return ret;
    }

    public boolean fileExists() {
        return this.file.exists();
    }

    public void buildToFile() {
        String contents = this.build();
        if (contents.length() == 0) {
            System.err.println("There are no contents to save to" + this.file.getPath());
        } else {
            this.file.getParentFile().mkdirs();
            File tmp = new File(this.file.getPath() + ".tmp");
            try (PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), StandardCharsets.UTF_8));){
                printwriter.println(this.build());
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            try {
                Files.copy(tmp.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Files.delete(tmp.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Pair<A, B> {
        private A a;
        private B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A A() {
            return this.a;
        }

        public void setA(A a) {
            this.a = a;
        }

        public B B() {
            return this.b;
        }

        public void setB(B b) {
            this.b = b;
        }
    }
}

