/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mod;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.core.registries.UnionLibRegistry;
import com.stereowalker.unionlib.fabric.PlatformHelper;
import com.stereowalker.unionlib.insert.InsertSystem;
import com.stereowalker.unionlib.mod.MinecraftMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_3304;
import net.minecraft.server.MinecraftServer;

public class ModHandler {
    private static LoadState loadState = null;
    public static final Map<String, MinecraftMod> mods = new HashMap<String, MinecraftMod>();
    private static final List<MinecraftMod> clientInitializableMods = new ArrayList<MinecraftMod>();
    private static final List<MinecraftMod> serverInitializableMods = new ArrayList<MinecraftMod>();
    private static boolean hasHandledServerPackets = false;
    private static boolean hasHandledClientPackets = false;
    private static MinecraftMod unionLib = null;

    public static boolean isModRegistered(String mod) {
        return mods.containsKey(mod);
    }

    public static LoadState getLoadState() {
        if (loadState == null) {
            UnionLib.warn("Load state is null, not ideal");
        }
        return loadState == null ? LoadState.NOT_INITIALIZED : loadState;
    }

    public static void registerPacketsOnDedicatedServer() {
        if (!hasHandledServerPackets) {
            hasHandledServerPackets = true;
        }
    }

    public static void registerAllClientRelaodableResources(class_3304 resourceManager) {
        ReloadListeners reloaders = arg_0 -> ((class_3304)resourceManager).method_14477(arg_0);
        mods.values().forEach(mod -> mod.registerClientRelaodableResources(reloaders));
    }

    public static void registerPacketsOnClient() {
        if (!hasHandledClientPackets) {
            hasHandledClientPackets = true;
        }
    }

    public static void doServerInitialization(MinecraftServer mc) {
        if (serverInitializableMods.size() > 0) {
            UnionLib.debug("Attempting to initialize mod on server. There are " + serverInitializableMods.size() + " mods that will require this process");
            ArrayList<MinecraftMod> initializaed = new ArrayList<MinecraftMod>();
            for (MinecraftMod mod : serverInitializableMods) {
                mod.getServerSegment().setupServerBeforeMinecraft(mc);
                if (!mod.getServerSegment().hasInitialized()) continue;
                initializaed.add(mod);
            }
            serverInitializableMods.removeAll(initializaed);
            UnionLib.debug("Successfully initialized " + initializaed.size() + " mods on the server");
        }
    }

    public static void doClientInitialization(class_310 mc) {
        if (clientInitializableMods.size() > 0) {
            UnionLib.debug("Attempting to initialize mod on client. There are " + clientInitializableMods.size() + " mods that will require this process");
            ArrayList<MinecraftMod> initializaed = new ArrayList<MinecraftMod>();
            MinecraftMod unionlib = null;
            for (MinecraftMod mod : clientInitializableMods) {
                if (!mod.getModid().equals("unionlib")) continue;
                unionlib = mod;
                break;
            }
            clientInitializableMods.remove(unionlib);
            clientInitializableMods.add(unionlib);
            for (MinecraftMod mod : clientInitializableMods) {
                mod.getClientSegment().setupClientAfterMinecraft(mc);
                if (!mod.getClientSegment().hasInitialized()) continue;
                initializaed.add(mod);
            }
            clientInitializableMods.removeAll(initializaed);
            UnionLib.debug("Successfully initialized " + initializaed.size() + " mods on the client");
        }
    }

    public static void registerMod(MinecraftMod mod) {
        mods.put(mod.getModid(), mod);
        mod.commonStuff();
        mod.registerInserts(InsertSystem.instance);
        PlatformHelper.registerAllServerRelaodableResources(mod);
        if (mod.getLoadType().onClient() && PlatformHelper.isClientInstance()) {
            mod.getClientSegment().registerInserts(InsertSystem.instance);
            clientInitializableMods.add(mod);
        }
        if (mod.getLoadType().onServer() && PlatformHelper.isServerInstance()) {
            mod.getServerSegment().registerInserts(InsertSystem.instance);
            serverInitializableMods.add(mod);
        }
        if (loadState != LoadState.BOTH) {
            if (mod.getModid().equals("unionlib")) {
                if (mods.size() == 1) {
                    UnionLib.debug("Only UnionLib for now");
                    loadState = LoadState.ONLY_UNIONLIB;
                } else if (mods.size() > 1) {
                    UnionLib.debug("UnionLib cannot affect the load type");
                }
            } else {
                if (loadState == LoadState.ONLY_UNIONLIB) {
                    UnionLib.debug("UnionLib is no longer the only mod, we found " + mod.getModid());
                    loadState = null;
                }
                if (mod.getLoadType() == MinecraftMod.LoadType.BOTH) {
                    loadState = LoadState.BOTH;
                } else if (mod.getLoadType() == MinecraftMod.LoadType.CLIENT) {
                    loadState = loadState == LoadState.SERVER ? LoadState.BOTH : LoadState.CLIENT;
                } else if (mod.getLoadType() == MinecraftMod.LoadType.SERVER) {
                    loadState = loadState == LoadState.CLIENT ? LoadState.BOTH : LoadState.SERVER;
                }
            }
        }
        if (mod.getModid().equals("unionlib")) {
            unionLib = mod;
        }
        if (mod.getLoadType() == MinecraftMod.LoadType.BOTH && unionLib != null && ModHandler.getLoadState().isInitialized() && UnionLibRegistry.registerObjects(unionLib)) {
            unionLib = null;
        }
        if (!mod.getModid().equals("unionlib")) {
            UnionLibRegistry.registerObjects(mod);
        }
    }

    public static enum LoadState {
        CLIENT,
        BOTH,
        SERVER,
        ONLY_UNIONLIB,
        NOT_INITIALIZED;


        public boolean runsOnClient() {
            return this == CLIENT || this == BOTH || this == ONLY_UNIONLIB;
        }

        public boolean runsOnServer() {
            return this == SERVER || this == BOTH;
        }

        public boolean runsOnlyOnClient() {
            return this == CLIENT || this == ONLY_UNIONLIB;
        }

        public boolean runsOnlyOnServer() {
            return this == SERVER;
        }

        public boolean runsOnBothSides() {
            return this == BOTH;
        }

        public boolean isInitialized() {
            return this == BOTH || this == CLIENT || this == SERVER;
        }
    }
}

