/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import com.stereowalker.unionlib.hook.AccessoryStack;
import com.stereowalker.unionlib.hook.EntityHook;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.entity.player.CustomInventoryGetter;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import com.stereowalker.unionlib.world.level.material.FluidProperties;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5131;
import net.minecraft.class_5132;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements EntityHook {
    private final class_2371<class_1799> lastAccessoryItemStacks = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    boolean killWaterMovement = false;
    double gravity = 0.0;

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public class_5131 method_6127() {
        return null;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;detectEquipmentUpdates()V")})
    public void tick_inject(CallbackInfo ci) {
        this.detectAccessoryUpdates();
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")}, cancellable=true)
    private static void tick_inject(CallbackInfoReturnable<class_5132.class_5133> cir) {
    }

    private void detectAccessoryUpdates() {
        Map<AccessorySlot, class_1799> map = this.collectAccesssoryChanges();
        if (map != null && !map.isEmpty()) {
            this.handleAccessoryChanges(map);
        }
    }

    @Nullable
    private Map<AccessorySlot, class_1799> collectAccesssoryChanges() {
        EnumMap map = null;
        for (AccessorySlot accessoryslot : AccessorySlot.values()) {
            class_1799 itemstackR;
            boolean hasModifier;
            AccessoryStack itemstack1;
            AccessoryStack itemstack = (AccessoryStack)this.getLastAccessoryItem(accessoryslot);
            class_5131 attributemap = this.method_6127();
            if (!(this instanceof CustomInventoryGetter) || class_1799.method_7973((class_1799)(itemstack1 = (AccessoryStack)((CustomInventoryGetter)((Object)this)).getUnionInventory().getAccessory(accessoryslot)).self(), (class_1799)itemstack.self())) continue;
            if (map == null) {
                map = Maps.newEnumMap(AccessorySlot.class);
            }
            map.put(accessoryslot, itemstack1.self());
            if (!itemstack.self().method_7960() && itemstack.self().method_7909() instanceof AccessoryItem) {
                itemstack.forEachModifier(accessoryslot, (at, mo) -> {
                    class_1324 attributeinstance = attributemap.method_45329(at);
                    if (attributeinstance != null) {
                        attributeinstance.method_6202(mo);
                    }
                });
                hasModifier = false;
                for (AccessorySlot accessoryslotR : AccessorySlot.values()) {
                    if (accessoryslot == accessoryslotR || accessoryslot.getGroup() != accessoryslotR.getGroup()) continue;
                    itemstackR = ((CustomInventoryGetter)((Object)this)).getUnionInventory().getAccessory(accessoryslotR);
                    break;
                }
                if (!hasModifier) {
                    // empty if block
                }
            }
            if (itemstack1.self().method_7960() || !(itemstack1.self().method_7909() instanceof AccessoryItem)) continue;
            itemstack1.forEachModifier(accessoryslot, (at, mo) -> {
                class_1324 attributeinstance = attributemap.method_45329(at);
                if (attributeinstance != null) {
                    attributeinstance.method_6200(mo.comp_2447());
                    attributeinstance.method_26835(mo);
                }
            });
            hasModifier = false;
            for (AccessorySlot accessoryslotR : AccessorySlot.values()) {
                if (accessoryslot == accessoryslotR || accessoryslot.getGroup() != accessoryslotR.getGroup()) continue;
                itemstackR = ((CustomInventoryGetter)((Object)this)).getUnionInventory().getAccessory(accessoryslotR);
                break;
            }
            if (hasModifier) continue;
        }
        return map;
    }

    private void handleAccessoryChanges(Map<AccessorySlot, class_1799> p_21143_) {
        ArrayList list = Lists.newArrayListWithCapacity((int)p_21143_.size());
        p_21143_.forEach((p_147204_, p_147205_) -> {
            class_1799 itemstack = p_147205_.method_7972();
            list.add(Pair.of((Object)p_147204_, (Object)itemstack));
            this.setLastAccessoryItem((AccessorySlot)((Object)p_147204_), itemstack);
        });
    }

    private class_1799 getLastAccessoryItem(AccessorySlot pSlot) {
        return (class_1799)this.lastAccessoryItemStacks.get(pSlot.getIndex());
    }

    private void setLastAccessoryItem(AccessorySlot pSlot, class_1799 pStack) {
        this.lastAccessoryItemStacks.set(pSlot.getIndex(), (Object)pStack);
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    public void travel_inject(class_243 travelVector, CallbackInfo ci) {
        this.killWaterMovement = false;
    }

    @Inject(method={"travel"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")})
    public void travel_inject2(class_243 travelVector, CallbackInfo ci, double d) {
        this.gravity = d;
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWater()Z")})
    public boolean travel_wrapOperation(class_1309 entity, Operation<Boolean> o, class_243 travelVector) {
        class_3610 fluidState = this.method_37908().method_8316(this.method_24515());
        return (Boolean)o.call(new Object[]{entity}) != false || FluidProperties.fluidProps.containsKey(fluidState.method_15772());
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isSprinting()Z")})
    public void updateFluidOnEyes_inject_head(class_243 travelVector, CallbackInfo ci) {
        class_3610 fluidState = this.method_37908().method_8316(this.method_24515());
        this.killWaterMovement = FluidProperties.fluidProps.containsKey(fluidState.method_15772()) && FluidProperties.fluidProps.get(fluidState.method_15772()).move(fluidState, (class_1309)this, travelVector, this.gravity);
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;moveRelative(FLnet/minecraft/world/phys/Vec3;)V")})
    public void travel_wrapOperation1(class_1309 entity, float f, class_243 travelVector, Operation<Void> o) {
        if (!this.killWaterMovement) {
            o.call(new Object[]{entity, Float.valueOf(f), travelVector});
        }
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V")})
    public void travel_wrapOperation2(class_1309 entity, class_1313 f, class_243 travelVector, Operation<Void> o) {
        if (!this.killWaterMovement) {
            o.call(new Object[]{entity, f, travelVector});
        }
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V")})
    public void travel_wrapOperation3(class_1309 entity, class_243 travelVector, Operation<Void> o) {
        if (!this.killWaterMovement) {
            o.call(new Object[]{entity, travelVector});
        }
    }

    @WrapOperation(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/TagKey;)D")})
    public double aiStep_wrapOperation1(class_1309 entity, class_6862 key, Operation<Double> o) {
        class_3610 fluidState = this.method_37908().method_8316(this.method_24515());
        return Math.max(this.fluidHeights().getOrDefault((Object)FluidProperties.fromFluid(fluidState.method_15772()), 0.0), (Double)o.call(new Object[]{entity, key}));
    }

    @WrapOperation(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWater()Z")})
    public boolean aiStep_wrapOperation2(class_1309 entity, Operation<Boolean> o) {
        class_3610 fluidState = this.method_37908().method_8316(this.method_24515());
        return (Boolean)o.call(new Object[]{entity}) != false || this.isInFluid(fluidState);
    }

    @WrapOperation(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;jumpInLiquid(Lnet/minecraft/tags/TagKey;)V")})
    public void aiStep_wrapOperation3(class_1309 entity, class_6862 key, Operation<Void> o) {
        class_3610 fluidState = this.method_37908().method_8316(this.method_24515());
        if (FluidProperties.fluidProps.containsKey(fluidState.method_15772())) {
            o.call(new Object[]{entity, new class_6862(RegistryHelper.fluidKey(), VersionHelper.toLoc("fluid_unionlib", RegistryHelper.fluids().method_10221((Object)fluidState.method_15772()).toString().replace(":", "unionlib")))});
        } else {
            o.call(new Object[]{entity, key});
        }
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWaterRainOrBubble()Z")})
    public boolean isInWaterRainOrBubble_wrapOperation(class_1309 entity, Operation<Boolean> o) {
        return (Boolean)o.call(new Object[]{entity}) != false || this.isInFluid(this.method_37908().method_8316(this.method_24515()), prop -> prop.canExtinguish((class_1297)entity));
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isEyeInFluid(Lnet/minecraft/tags/TagKey;)Z")})
    public boolean updateFluidOnEyes_inject_head(class_1309 entity, class_6862<class_3611> d, Operation<Boolean> o) {
        return (Boolean)o.call(new Object[]{entity, d}) != false || FluidProperties.fluidProps.containsKey(this.fluidInEyes().method_15772()) && FluidProperties.fluidProps.get(this.fluidInEyes().method_15772()).canDrownIn(entity);
    }
}

