/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.core.registries;

import com.stereowalker.unionlib.api.registries.BindableRegistryWrapper;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.api.registries.RegistryWrapper;
import com.stereowalker.unionlib.core.registries.ClassNRegistry;
import com.stereowalker.unionlib.core.registries.CustomNRegistry;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.fabric.PlatformHelper;
import com.stereowalker.unionlib.mod.MinecraftMod;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_4149;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegisterObjects {
    public static final Logger LOGGER = LogManager.getLogger((String)"UnionLib Registry");

    public static void putObjectsInGameRegistries(final MinecraftMod mod) {
        final ArrayList regs = new ArrayList();
        final ArrayList regs2 = new ArrayList();
        mod.setupRegistries(new RegistryCollector(){

            @Override
            public <T> void addRegistry(RegistryWrapper<T> wrapper, class_5321<class_2378<T>> registryKey, boolean sync) {
                if (wrapper instanceof BindableRegistryWrapper) {
                    BindableRegistryWrapper bindable = (BindableRegistryWrapper)wrapper;
                    bindable.bind(PlatformHelper.createWrappedRegistry(mod, sync, registryKey));
                } else {
                    LOGGER.info("A registry wrapper for " + mod.getModid() + " is somehow not an instance of BindableRegistryWrapper");
                }
            }

            @Override
            public <T> void addCustom(class_5321<class_2378<T>> registryKey, Consumer<RegistryCollector.Custom<T>> register) {
                regs2.add(new CustomNRegistry<T>(registryKey, register));
            }

            @Override
            public void addRegistryHolder(Class<?> holder) {
                if (!holder.isAnnotationPresent(RegistryHolder.class)) {
                    LOGGER.info(String.valueOf(holder) + " is missing the @RegistryHolder annotation. Include it to register the objects in this class");
                } else {
                    RegistryHolder reg = holder.getAnnotation(RegistryHolder.class);
                    if (reg.registry() == class_2248.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41254, holder));
                    } else if (reg.registry() == class_9331.class) {
                        regs.add(new ClassNRegistry(class_7924.field_49659, holder));
                    } else if (reg.registry() == class_3611.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41270, holder));
                    } else if (reg.registry() == class_1792.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41197, holder));
                    } else if (reg.registry() == class_1741.class) {
                        regs.add(new ClassNRegistry(class_7924.field_48977, holder));
                    } else if (reg.registry() == class_1320.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41251, holder));
                    } else if (reg.registry() == class_1291.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41208, holder));
                    } else if (reg.registry() == class_1842.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41215, holder));
                    } else if (reg.registry() == class_1865.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41216, holder));
                    } else if (reg.registry() == class_4149.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41221, holder));
                    } else if (reg.registry() == class_3917.class) {
                        regs.add(new ClassNRegistry(class_7924.field_41207, holder));
                    }
                }
            }

            @Override
            public <T> void addRegistryHolder(class_5321<class_2378<T>> registryKey, Class<?> holder) {
                if (!holder.isAnnotationPresent(RegistryHolder.class)) {
                    LOGGER.info(String.valueOf(holder) + " is missing the @RegistryHolder annotation. Include it to register the objects in this class");
                } else {
                    regs.add(new ClassNRegistry<T>(registryKey, holder));
                }
            }
        });
        LOGGER.info("Found " + regs.size() + " registry classes in " + mod.getModid());
        for (ClassNRegistry classs : regs) {
            RegistryHolder reg = classs.classs.getAnnotation(RegistryHolder.class);
            LOGGER.info("Registering " + String.valueOf(classs.registryKey.method_29177()) + "s in " + String.valueOf(classs));
            String namespace = reg.namespace().isEmpty() ? mod.getModid() : reg.namespace();
            PlatformHelper.handleRegistration(mod, namespace, classs.classs.getFields(), classs.registryKey, LOGGER);
        }
        regs2.forEach(custom -> custom.invoke(mod));
        PlatformHelper.doCreativeTabs(mod);
    }
}

