/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stereowalker.unionlib.client.gui.components.OverflowTextButton;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.config.lists.ListScreen;
import com.stereowalker.unionlib.client.gui.widget.button.Slider;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ConfigHolder;
import com.stereowalker.unionlib.config.ConfigSide;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.ScreenHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7919;

public class ConfigList
extends class_4265<Entry> {
    protected ConfigScreen screen;
    protected List<class_2561> tooltip = null;
    protected int tooltipX = 0;
    protected int tooltipY = 0;
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    public ConfigList(class_310 mcIn, ConfigScreen screen, UnionConfig config) {
        super(mcIn, screen.field_22789, screen.layout.method_57727(), screen.layout.method_48998(), 25);
        this.screen = screen;
        List<String> c = Arrays.asList(ConfigBuilder.getValues(config).keySet().toArray(new String[0]));
        Collections.sort(c);
        String currentCategory = "";
        for (String configValue : c) {
            Object name = "";
            for (int i = 1; i < configValue.split("=").length; ++i) {
                name = (String)name + configValue.split("=")[i];
            }
            if (ConfigList.split((String)name).size() > 1 && !ConfigList.split((String)name).get(0).equals(currentCategory)) {
                this.method_25321((class_350.class_351)new CategoryEntry((class_2561)class_2561.method_43470((String)ConfigList.split((String)name).get(0))));
                currentCategory = ConfigList.split((String)name).get(0);
            }
            Object name2 = "";
            if (ConfigList.split((String)name).size() > 1) {
                for (int i = 1; i < ConfigList.split((String)name).size(); ++i) {
                    name2 = (String)name2 + ConfigList.split((String)name).get(i);
                }
            } else {
                name2 = name;
            }
            ConfigHolder<Boolean> holder = ConfigBuilder.getValues(config).get(configValue);
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Boolean) {
                this.method_25321((class_350.class_351)new BooleanEntry(this, (class_2561)class_2561.method_43470((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof String) {
                this.method_25321((class_350.class_351)new StringEntry((class_2561)class_2561.method_43470((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Enum) {
                this.method_25321((class_350.class_351)new EnumEntry(this, (class_2561)class_2561.method_43470((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Number) {
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Double) {
                    this.method_25321((class_350.class_351)new NumberedEntry<Boolean>((class_2561)class_2561.method_43470((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Float) {
                    this.method_25321((class_350.class_351)new NumberedEntry<Boolean>((class_2561)class_2561.method_43470((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Long) {
                    this.method_25321((class_350.class_351)new NumberedEntry<Boolean>((class_2561)class_2561.method_43470((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Short) {
                    this.method_25321((class_350.class_351)new NumberedEntry<Boolean>((class_2561)class_2561.method_43470((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Byte) {
                    this.method_25321((class_350.class_351)new NumberedEntry<Boolean>((class_2561)class_2561.method_43470((String)name2), holder));
                    continue;
                }
                this.method_25321((class_350.class_351)new NumberedEntry<Boolean>((class_2561)class_2561.method_43470((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof List) {
                this.method_25321((class_350.class_351)new ListEntry((class_2561)class_2561.method_43470((String)name2), holder));
                continue;
            }
            this.method_25321((class_350.class_351)new ConfigEntry<Boolean>((class_2561)class_2561.method_43470((String)name2), holder));
        }
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    protected int method_25329() {
        return super.method_25329();
    }

    public int method_25322() {
        return 400;
    }

    public void tick() {
        for (Entry ent : this.method_25396()) {
            if (!(ent instanceof ConfigEntry)) continue;
            ((ConfigEntry)ent).tick();
        }
    }

    public class CategoryEntry
    extends Entry {
        private final class_2561 labelText;
        private final int labelWidth;

        public CategoryEntry(class_2561 p_i232280_2_) {
            this.labelText = p_i232280_2_;
            this.labelWidth = ((ConfigList)ConfigList.this).field_22740.field_1772.method_27525((class_5348)this.labelText);
        }

        public void method_25343(class_332 p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            p_230432_1_.method_51439(((ConfigList)ConfigList.this).field_22740.field_1772, this.labelText, ((ConfigList)ConfigList.this).field_22740.field_1755.field_22789 / 2 - this.labelWidth / 2, p_230432_3_ + p_230432_6_ - 9 - 1, 0xFFFFFF, false);
        }

        public boolean changeFocus(boolean focus) {
            return false;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }

    public class BooleanEntry
    extends ConfigEntry<Boolean> {
        private BooleanEntry(ConfigList this$0, class_2561 name, ConfigHolder<Boolean> config) {
            super(name, config);
        }

        @Override
        public void reset(class_2561 name) {
            this.configInteractable = ScreenHelper.buttonBuilder(name, onPress -> {
                this.config.setValue((Boolean)this.config.get() == false);
                ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
            }).method_46434(0, 0, this.interactionWidth, 20).method_46431();
        }

        @Override
        public void method_25343(class_332 p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.method_25343(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.configInteractable.method_25355(class_5244.method_36134((boolean)((Boolean)this.config.get())));
        }
    }

    public class StringEntry
    extends ConfigEntry<String> {
        private StringEntry(class_2561 name, ConfigHolder<String> config) {
            super(name, config);
        }

        @Override
        public void reset(class_2561 name) {
            if (this.configInteractable instanceof class_342) {
                ((class_342)this.configInteractable).method_1852((String)this.config.get());
            } else {
                this.configInteractable = new class_342(((ConfigList)ConfigList.this).field_22740.field_1772, 0, 0, this.interactionWidth, 20, (class_2561)class_2561.method_43471((String)"config.editBox"));
                ((class_342)this.configInteractable).method_1852((String)this.config.get());
                ((class_342)this.configInteractable).method_1863(p_214319_1_ -> {
                    this.config.setValue(p_214319_1_);
                    ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
                });
            }
        }

        @Override
        public void tick() {
        }
    }

    public class EnumEntry
    extends ConfigEntry<Enum<?>> {
        private EnumEntry(ConfigList this$0, class_2561 name, ConfigHolder<Enum<?>> config) {
            super(name, config);
        }

        @Override
        public void reset(class_2561 name) {
            this.configInteractable = ScreenHelper.buttonBuilder(name, onPress -> {
                this.config.setValue(RegistryHelper.rotateEnumForward((Enum)((Enum)this.config.get()), (Enum[])((Enum[])((Enum)this.config.get()).getDeclaringClass().getEnumConstants())));
                ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
            }).method_46434(0, 0, this.interactionWidth, 20).method_46431();
        }

        @Override
        public void method_25343(class_332 p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.method_25343(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.configInteractable.method_25355((class_2561)class_2561.method_43471((String)((Enum)this.config.get()).name()));
        }
    }

    public class NumberedEntry<V extends Number>
    extends ConfigEntry<V> {
        private NumberedEntry(class_2561 name, ConfigHolder<V> config) {
            super(name, config);
        }

        @Override
        public void reset(class_2561 name) {
            double shiftedMax = ((Number)this.config.getMax()).doubleValue() - ((Number)this.config.getMin()).doubleValue();
            if (this.config.isUsingSlider()) {
                if (this.configInteractable instanceof Slider) {
                    ((Slider)this.configInteractable).method_25347(((Number)this.config.get()).doubleValue() / shiftedMax);
                } else {
                    this.configInteractable = new Slider(0, 0, this.interactionWidth, 20, ((Number)this.config.get()).doubleValue() / shiftedMax, (class_2561)class_2561.method_43470((String)((Number)this.config.get()).toString()));
                    ((Slider)this.configInteractable).setResponder(val -> {
                        if (this.config.isUsingSlider()) {
                            Number oldValue = (Number)this.config.get();
                            Double newValue = val * shiftedMax + ((Number)this.config.getMin()).doubleValue();
                            try {
                                if (this.config.get() instanceof Double) {
                                    this.config.setValue(newValue);
                                } else if (this.config.get() instanceof Float) {
                                    this.config.setValue(Float.valueOf(newValue.floatValue()));
                                } else if (this.config.get() instanceof Long) {
                                    this.config.setValue(newValue.longValue());
                                } else if (this.config.get() instanceof Short) {
                                    this.config.setValue(newValue.shortValue());
                                } else if (this.config.get() instanceof Byte) {
                                    this.config.setValue(newValue.byteValue());
                                } else {
                                    this.config.setValue(newValue.intValue());
                                }
                            }
                            catch (NumberFormatException e) {
                                this.config.setValue(oldValue);
                            }
                            ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
                            ((Slider)this.configInteractable).method_25355((class_2561)class_2561.method_43470((String)((Number)this.config.get()).toString()));
                        }
                    });
                }
            } else if (this.configInteractable instanceof class_342) {
                ((class_342)this.configInteractable).method_1852(((Number)this.config.get()).toString());
            } else {
                this.configInteractable = new class_342(((ConfigList)ConfigList.this).field_22740.field_1772, 0, 0, this.interactionWidth, 20, (class_2561)class_2561.method_43471((String)"config.editNumberBox"));
                ((class_342)this.configInteractable).method_1852(((Number)this.config.get()).toString());
                ((class_342)this.configInteractable).method_1890(text -> {
                    Number oldValue = (Number)this.config.get();
                    Number newValue = null;
                    try {
                        newValue = oldValue instanceof Double ? (Number)Double.parseDouble(text) : (Number)(oldValue instanceof Float ? (Number)Float.valueOf(Float.parseFloat(text)) : (Number)(oldValue instanceof Long ? (Number)Long.parseLong(text) : (Number)(oldValue instanceof Short ? (Number)Short.parseShort(text) : (Number)(oldValue instanceof Byte ? (Number)Byte.parseByte(text) : (Number)Integer.parseInt(text)))));
                        return newValue != null;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                });
                ((class_342)this.configInteractable).method_1863(text -> {
                    Number oldValue = (Number)this.config.get();
                    Number newValue = null;
                    try {
                        newValue = oldValue instanceof Double ? (Number)Double.parseDouble(text) : (Number)(oldValue instanceof Float ? (Number)Float.valueOf(Float.parseFloat(text)) : (Number)(oldValue instanceof Long ? (Number)Long.parseLong(text) : (Number)(oldValue instanceof Short ? (Number)Short.parseShort(text) : (Number)(oldValue instanceof Byte ? (Number)Byte.parseByte(text) : (Number)Integer.parseInt(text)))));
                        this.config.setValue(newValue);
                        ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
            }
        }

        @Override
        public void tick() {
        }
    }

    public class ListEntry
    extends ConfigEntry<List<?>> {
        private ListEntry(class_2561 name, ConfigHolder<List<?>> config) {
            super(name, config);
        }

        @Override
        public void reset(class_2561 name) {
            this.configInteractable = ScreenHelper.buttonBuilder((class_2561)class_2561.method_43471((String)"needle.gui.list"), onPress -> ConfigList.this.field_22740.method_1507((class_437)new ListScreen(name, ConfigList.this.screen, this.config))).method_46434(0, 0, this.interactionWidth, 20).method_46431();
        }
    }

    public class ConfigEntry<T>
    extends Entry {
        protected final ConfigHolder<T> config;
        protected final class_4185 configButton;
        protected class_339 configInteractable;
        protected final class_4185 resetButton;
        protected final int interactionWidth;

        public void tick() {
        }

        public void reset(class_2561 name) {
            this.configInteractable = null;
        }

        private ConfigEntry(class_2561 name, ConfigHolder<T> config) {
            this.config = config;
            this.interactionWidth = 140;
            class_2561 translatableOr = config.getTranslatable().isEmpty() ? name : class_2561.method_43471((String)config.getTranslatable());
            this.configButton = new OverflowTextButton(0, 0, 195, 20, translatableOr, onPress -> {});
            class_5250 c = class_2561.method_43473();
            List<class_2561> translatableCommentOr = config.getTranslatableComments().isEmpty() ? config.getComments() : config.getTranslatableComments();
            translatableCommentOr.subList(0, translatableCommentOr.size() - 1).forEach(el -> c.method_10852(el).method_27693("\n"));
            c.method_10852(translatableCommentOr.get(translatableCommentOr.size() - 1));
            this.configButton.method_47400(class_7919.method_47407((class_2561)c));
            this.reset(name);
            this.resetButton = new OverflowTextButton(0, 0, 40, 20, (class_2561)class_2561.method_43471((String)"controls.reset"), onPress -> {
                this.config.setValue(this.config.getDefaultValue());
                this.reset(name);
            });
            ConfigList.this.screen.addChild(this.configInteractable);
            ConfigList.this.screen.addChild(this.resetButton);
        }

        public void method_25343(class_332 pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            int i = ConfigList.this.method_25329() - this.resetButton.method_25368() - 10;
            ScreenHelper.setWidgetPosition((class_339)this.resetButton, i, pTop);
            this.resetButton.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
            boolean bl = this.resetButton.field_22763 = !this.config.get().equals(this.config.getDefaultValue());
            if (this.configInteractable != null) {
                int k = i - 5 - this.configInteractable.method_25368();
                ScreenHelper.setWidgetPosition(this.configInteractable, k, pTop);
                this.configInteractable.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
            ScreenHelper.setWidgetPosition((class_339)this.configButton, pLeft, pTop);
            this.configButton.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
            this.configButton.field_22763 = false;
        }

        public List<? extends class_364> method_25396() {
            return this.configInteractable == null ? ImmutableList.of((Object)this.configButton, (Object)this.resetButton) : ImmutableList.of((Object)this.configButton, (Object)this.resetButton, (Object)this.configInteractable);
        }

        public List<? extends class_6379> method_37025() {
            return this.configInteractable == null ? ImmutableList.of((Object)this.configButton, (Object)this.resetButton) : ImmutableList.of((Object)this.configButton, (Object)this.resetButton, (Object)this.configInteractable);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.resetButton.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.configInteractable != null && this.configInteractable.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            return this.configButton.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return this.resetButton.method_25406(mouseX, mouseY, button) || this.configInteractable != null && this.configInteractable.method_25406(mouseX, mouseY, button) || this.configButton.method_25406(mouseX, mouseY, button);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.configInteractable != null) {
                return this.configInteractable.method_25404(keyCode, scanCode, modifiers);
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.configInteractable != null && this.configInteractable.method_25403(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (this.resetButton.method_25403(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            return this.configButton.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
    }
}

