/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.MenuCollector;
import com.stereowalker.unionlib.api.keymaps.KeyMappingCollector;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.inventory.UnionInventoryScreen;
import com.stereowalker.unionlib.client.keybindings.KeyBindings;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.insert.ClientInserts;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.supporter.CosmeticHandler;
import com.stereowalker.unionlib.supporter.CosmeticSelection;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.world.inventory.UMenuType;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.minecraft.class_922;

public class UnionLibClientSegment
extends ClientSegment {
    private Map<class_922<?, ?>, HatModel<?>> cosmetics = new WeakHashMap();

    @Override
    public void initClientAfterMinecraft(class_310 mc) {
        new Cosmetics(mc);
    }

    @Override
    public class_437 getConfigScreen(class_310 mc, class_437 previousScreen) {
        return new ConfigScreen(previousScreen, UnionLib.CONFIG, (class_2561)class_2561.method_43471((String)"UnionLib Config"));
    }

    @Override
    public void setupKeymappings(KeyMappingCollector collector) {
        collector.addKeyMapping(KeyBindings.OPEN_UNION_INVENTORY);
    }

    @Override
    public void registerInserts(InsertCollector collector) {
        collector.addInsert(ClientInserts.CLIENT_TICK_BEGIN, () -> {
            if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_18456().size() > 1) {
                Cosmetics.pollCosmetics();
            }
        });
        collector.addInsert(ClientInserts.ITEM_TOOLTIP, (stack, player, tip, flag) -> {
            if (flag.method_8035() && UnionLib.CONFIG.tags) {
                ArrayList tags = new ArrayList();
                stack.method_40133().forEach(tag -> tags.add(class_2561.method_43470((String)("#" + String.valueOf(tag.comp_327()))).method_54663(UnionLib.CONFIG.tagColor)));
                if (stack.method_57353().method_57835() > 0) {
                    tip.addAll(tip.size() - 1, tags);
                } else {
                    tip.addAll(tags);
                }
            }
        });
        collector.addInsert(ClientInserts.LIVING_RENDER_FINISH, (entity, renderer, entityYaw, partialTicks, poseStack, buffer, packedLight) -> {
            class_742 player;
            if (entity instanceof class_742 && CosmeticHandler.doesPlayerNeedCosmetic((class_1657)(player = (class_742)entity))) {
                CosmeticSelection hat = CosmeticHandler.getHat((class_1657)player);
                if (!this.cosmetics.containsKey(renderer) || !hat.equals(this.cosmetics.get(renderer).getHat())) {
                    this.cosmetics.put(renderer, new HatModel(hat));
                }
                HatModel<?> hatmodel = this.cosmetics.get(renderer);
                boolean hasTexture = false;
                if (hatmodel.getHat().variant().equals("custom")) {
                    hasTexture = hatmodel.getCosmetic().texture(hatmodel.getHat().variant() + "_" + hatmodel.getCosmetic().segments().get(0)) != null;
                } else {
                    boolean bl = hasTexture = hatmodel.getCosmetic().texture(hatmodel.getHat().variant()) != null;
                }
                if (hasTexture && (hatmodel.getCosmetic().showOnHelmet() || player.method_6118(class_1304.field_6169).method_7960())) {
                    poseStack.method_22903();
                    CosmeticHandler.setupPose(renderer, player, entityYaw, partialTicks, poseStack, buffer, packedLight);
                    CosmeticHandler.addCosmetic(renderer, player, poseStack, buffer, hatmodel, packedLight, partialTicks, (class_572)renderer.method_4038());
                    poseStack.method_22909();
                }
            }
        });
    }

    @Override
    public class_2960 getModIcon() {
        return UnionLib.Locations.UNION_BUTTON_IMAGE;
    }

    @Override
    public void setupMenus(MenuCollector collector) {
        if (!ModHandler.getLoadState().runsOnlyOnClient()) {
            collector.addMenu(UMenuType.UNION, UnionInventoryScreen::new);
        }
    }
}

