/*
 * Decompiled with CFR 0.152.
 */
package com.invoke.spells;

import com.invoke.InvokeMod;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.event.SpellHandlers;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.utils.WorldScheduler;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public class SpellCustomImpact {
    private static Spell.Impact createImpact(Spell.Impact.Action.Type type, float coeff, float knockback) {
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = type;
        if (type == Spell.Impact.Action.Type.DAMAGE) {
            impact.action.damage = new Spell.Impact.Action.Damage();
            impact.action.damage.knockback = knockback;
            impact.action.damage.spell_power_coefficient = coeff;
        }
        return impact;
    }

    public static Spell.Impact createFrostImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = SpellCustomImpact.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.FROST;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_frost_impact_burst", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        Spell.TargetCondition targetCondition = new Spell.TargetCondition();
        targetCondition.entity_type = "#minecraft:freeze_immune_entity_types";
        Spell.Impact.TargetModifier targetModifier = new Spell.Impact.TargetModifier();
        targetModifier.conditions = List.of(targetCondition);
        targetModifier.modifier = new Spell.Impact.Modifier();
        targetModifier.modifier.power_multiplier = -0.3f;
        Spell.Impact.TargetModifier targetModifier2 = new Spell.Impact.TargetModifier();
        targetCondition.entity_type = "#minecraft:freeze_hurts_extra_types";
        targetModifier2.conditions = List.of(targetCondition);
        targetModifier2.modifier = new Spell.Impact.Modifier();
        targetModifier2.modifier.power_multiplier = 0.3f;
        impact.target_modifiers = List.of(targetModifier, targetModifier2);
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_FROST_IMPACT.id());
        return impact;
    }

    public static Spell.Impact createArcaneImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = SpellCustomImpact.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.ARCANE;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_arcane_spark_float", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.05f, 0.1f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_RELEASE.id());
        return impact;
    }

    public static Spell.Impact createFireImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = SpellCustomImpact.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.FIRE;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f), new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        Spell.TargetCondition targetCondition = new Spell.TargetCondition();
        targetCondition.entity_type = "#minecraft:freeze_immune_entity_types";
        Spell.Impact.TargetModifier targetModifier = new Spell.Impact.TargetModifier();
        targetModifier.conditions = List.of(targetCondition);
        targetModifier.modifier = new Spell.Impact.Modifier();
        targetModifier.modifier.critical_chance_bonus = 0.3f;
        impact.target_modifiers = List.of(targetModifier);
        impact.particles = hitParticles;
        impact.sound = sound = new Sound("minecraft:entity.player.hurt_on_fire");
        return impact;
    }

    public static void registerImpacts() {
        SpellHandlers.registerCustomImpact((class_2960)class_2960.method_60655((String)InvokeMod.MODID, (String)"delay_area_impact"), (SpellHandlers.CustomImpact)new DelayImpact());
    }

    public static class DelayImpact
    implements SpellHandlers.CustomImpact {
        public SpellHandlers.ImpactResult onSpellImpact(class_6880<Spell> registryEntry, SpellPower.Result result, class_1309 livingEntity, @Nullable class_1297 entity, SpellHelper.ImpactContext impactContext) {
            Spell.AreaImpact areaImpact = ((Spell)registryEntry.comp_349()).area_impact;
            ParticleHelper.sendBatches((class_1297)entity, (ParticleBatch[])areaImpact.particles);
            class_243 vec3d = entity.method_19538();
            ((WorldScheduler)livingEntity.method_37908()).schedule(20, () -> {
                Spell.Impact[] impacts = new Spell.Impact[1];
                if (((Spell)registryEntry.comp_349()).school.equals(SpellSchools.ARCANE)) {
                    impacts[0] = SpellCustomImpact.createArcaneImpact(((Spell.Impact)((Spell)registryEntry.comp_349()).impacts.get((int)0)).action.damage.spell_power_coefficient, ((Spell.Impact)((Spell)registryEntry.comp_349()).impacts.get((int)0)).action.damage.knockback);
                } else if (((Spell)registryEntry.comp_349()).school.equals(SpellSchools.FROST)) {
                    impacts[0] = SpellCustomImpact.createFrostImpact(((Spell.Impact)((Spell)registryEntry.comp_349()).impacts.get((int)0)).action.damage.spell_power_coefficient, ((Spell.Impact)((Spell)registryEntry.comp_349()).impacts.get((int)0)).action.damage.knockback);
                } else if (((Spell)registryEntry.comp_349()).school.equals(SpellSchools.FIRE)) {
                    impacts[0] = SpellCustomImpact.createFireImpact(((Spell.Impact)((Spell)registryEntry.comp_349()).impacts.get((int)0)).action.damage.spell_power_coefficient, ((Spell.Impact)((Spell)registryEntry.comp_349()).impacts.get((int)0)).action.damage.knockback);
                }
                SpellHelper.performImpacts((class_1937)livingEntity.method_37908(), (class_1309)livingEntity, (class_1297)entity, (class_1297)entity, (class_6880)registryEntry, List.of(impacts), (SpellHelper.ImpactContext)new SpellHelper.ImpactContext(1.0f, 1.0f, vec3d, result, SpellTarget.FocusMode.AREA, 0));
            });
            return new SpellHandlers.ImpactResult(true, false);
        }
    }
}

