/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.api;

import java.util.ArrayList;
import net.critical_strike.api.AttributeIdentifiers;
import net.critical_strike.internal.CustomStatusEffect;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1329;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CriticalStrikeAttributes {
    public static final String NAMESPACE = "critical_strike";
    public static final ArrayList<Entry> all = new ArrayList();
    public static final Entry CHANCE = CriticalStrikeAttributes.entry("chance", 100.0, 100.0, false).translations("Critical Hit Chance", "Critical Hit", "Increases the chance to deal critical hits.").innateModifier(class_1322.class_1323.field_6330, 0.05f).effect(0xF400FF);
    public static final Entry DAMAGE = CriticalStrikeAttributes.entry("damage", 100.0, 100.0, false).translations("Critical Hit Damage", "Critical Impact", "Increases the damage dealt by critical hits.").innateModifier(class_1322.class_1323.field_6330, 0.5f).effect(0x800000);

    private static Entry entry(String name, double baseValue, boolean tracked) {
        return CriticalStrikeAttributes.entry(name, 0.0, baseValue, tracked);
    }

    private static Entry entry(String name, double minValue, double baseValue, boolean tracked) {
        Entry entry = new Entry(name, minValue, baseValue, tracked);
        all.add(entry);
        return entry;
    }

    public static class Entry {
        public final class_2960 id;
        public final String translationKey;
        public final class_1320 attribute;
        public final double baseValue;
        @Nullable
        public class_6880<class_1320> attributeEntry;
        @Nullable
        public class_1322 innateModifier;
        @Nullable
        public Translations translations;
        @Nullable
        private class_1291 statusEffect = null;
        @Nullable
        public class_6880<class_1291> effectEntry = null;

        public Entry(String name, double minValue, double baseValue, boolean tracked) {
            this.id = class_2960.method_60655((String)CriticalStrikeAttributes.NAMESPACE, (String)name);
            this.translationKey = "attribute.name.critical_strike." + name;
            this.attribute = new class_1329(this.translationKey, baseValue, minValue, 2048.0).method_26829(tracked);
            this.baseValue = baseValue;
        }

        public double asMultiplier(double attributeValue) {
            return attributeValue / this.baseValue;
        }

        public float asChance(double attributeValue) {
            return (float)((attributeValue - this.baseValue) / this.baseValue);
        }

        public void register() {
            if (this.attributeEntry != null) {
                return;
            }
            this.attributeEntry = class_2378.method_47985((class_2378)class_7923.field_41190, (class_2960)this.id, (Object)this.attribute);
        }

        public Entry innateModifier(class_1322.class_1323 operation, float value) {
            this.innateModifier = new class_1322(AttributeIdentifiers.INNATE_BONUS, (double)value, operation);
            return this;
        }

        public void setInnateBonus(float bonus) {
            if (this.innateModifier != null) {
                this.innateModifier = new class_1322(this.innateModifier.comp_2447(), (double)bonus, this.innateModifier.comp_2450());
            }
        }

        public Entry translations(String name, String effectName, String effectDescription) {
            this.translations = new Translations(name, effectName, effectDescription);
            return this;
        }

        public Entry effect(int color) {
            this.statusEffect = new CustomStatusEffect(class_4081.field_18271, color);
            return this;
        }

        public void setEffectBonus(float bonus) {
            if (this.statusEffect != null && this.attributeEntry != null) {
                this.statusEffect.method_5566(this.attributeEntry, AttributeIdentifiers.EFFECT_BONUS, (double)bonus, class_1322.class_1323.field_6330);
            }
        }

        public void registerEffect() {
            if (this.statusEffect != null) {
                this.effectEntry = class_2378.method_47985((class_2378)class_7923.field_41174, (class_2960)this.id, (Object)this.statusEffect);
            }
        }

        public class_2960 potionId() {
            return class_2960.method_60655((String)this.id.method_12836(), (String)(this.id.method_12836() + "_" + this.id.method_12832()));
        }
    }

    public record Translations(String name, String effectName, String effectDescription) {
    }
}

