/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.entity;

import com.google.common.collect.ImmutableList;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.container.SeedDrillMenu;
import net.jmb19905.niftycarts.entity.AbstractDrawnInventoryEntity;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_7225;

public class SeedDrillEntity
extends AbstractDrawnInventoryEntity {
    private static final int SLOT_COUNT = 9;
    private static final ImmutableList<class_2940<class_1799>> SEEDS = ImmutableList.of((Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(SeedDrillEntity.class, (class_2941)class_2943.field_13322));

    public SeedDrillEntity(class_1299<? extends class_1297> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn, 9);
        this.spacing = 1.3;
    }

    private void plant() {
        for (int j = 0; j < 9; ++j) {
            class_1799 stack = this.getStackInSlot(j);
            double x = this.method_23317() + (double)class_3532.method_15374((float)((float)Math.toRadians(this.method_36454() - 90.0f)));
            double z = this.method_23321() + (double)class_3532.method_15362((float)((float)Math.toRadians(this.method_36454() - 90.0f)));
            class_2338 blockPos = new class_2338((int)Math.round(x - 0.5), (int)Math.round(this.method_23318() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.method_10084(), this.method_37908(), j)) break;
            x = this.method_23317();
            z = this.method_23321();
            blockPos = new class_2338((int)Math.round(x - 0.5), (int)Math.round(this.method_23318() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.method_10084(), this.method_37908(), j)) break;
            x = this.method_23317() + (double)class_3532.method_15374((float)((float)Math.toRadians(this.method_36454() + 90.0f)));
            z = this.method_23321() + (double)class_3532.method_15362((float)((float)Math.toRadians(this.method_36454() + 90.0f)));
            blockPos = new class_2338((int)Math.round(x - 0.5), (int)Math.round(this.method_23318() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.method_10084(), this.method_37908(), j)) break;
        }
    }

    private boolean tryPlaceCrop(class_1799 stack, class_2338 pos, class_1937 level, int slot) {
        class_1792 class_17922;
        if (stack.method_31573(NiftyCarts.SEED_DRILL_PLANTABLE) && (class_17922 = stack.method_7909()) instanceof class_1747) {
            class_1747 item = (class_1747)class_17922;
            class_2248 block = item.method_7711();
            if (level.method_8320(pos).method_26215() && block.method_9564().method_26184((class_4538)level, pos)) {
                level.method_8501(pos, block.method_9564());
                stack.method_7934(1);
                this.onContentsChanged(slot);
                return true;
            }
        }
        return false;
    }

    @Override
    public void pulledTick() {
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!(this.method_37908().field_9236 || this.field_6014 == this.method_23317() && this.field_5969 == this.method_23321())) {
            this.plant();
        }
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.updateSlot(slot);
    }

    public void updateSlot(int slot) {
        if (!this.method_37908().field_9236) {
            if (((class_1799)this.method_42278().get(slot)).method_7960()) {
                this.field_6011.method_12778((class_2940)SEEDS.get(slot), (Object)class_1799.field_8037);
            } else {
                this.field_6011.method_12778((class_2940)SEEDS.get(slot), (Object)((class_1799)this.method_42278().get(slot)));
            }
        }
    }

    public class_1799 getStackInSlot(int i) {
        return (class_1799)this.field_6011.method_12789((class_2940)SEEDS.get(i));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        for (class_2940 param : SEEDS) {
            builder.method_56912(param, (Object)class_1799.field_8037);
        }
    }

    @Override
    protected class_1269 onInteractNotOpen(class_1657 player, class_1268 hand) {
        return class_1269.field_5812;
    }

    @Override
    protected class_1703 createMenuLootUnpacked(int i, class_1661 inventory, class_1657 player) {
        return new SeedDrillMenu(i, inventory, (class_1263)this);
    }

    @Override
    public class_1792 getCartItem() {
        return NiftyCarts.SEED_DRILL.get(this.getWoodType());
    }

    @Override
    protected NiftyCartsConfig.CartConfig getConfig() {
        return NiftyCartsConfig.get().seedDrill;
    }

    @Override
    protected void saveInventory(class_2487 compound) {
        class_1262.method_5426((class_2487)compound, this.method_42278(), (class_7225.class_7874)this.method_56673());
    }

    @Override
    protected void readInventory(class_2487 compound) {
        class_1262.method_5429((class_2487)compound, this.method_42278(), (class_7225.class_7874)this.method_56673());
    }
}

