/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.client.renderer.NiftyCartsModelLayers;
import net.jmb19905.niftycarts.client.renderer.entity.CargoRenderUtil;
import net.jmb19905.niftycarts.client.renderer.entity.DrawnRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.model.HandCartModel;
import net.jmb19905.niftycarts.entity.HandCartEntity;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5151;
import net.minecraft.class_5253;
import net.minecraft.class_5455;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_7406;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9279;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class HandCartRenderer
extends DrawnRenderer<HandCartEntity, HandCartModel> {
    private final class_572<class_1309> leggings;
    private final class_572<class_1309> armor;
    private final class_1059 armorTrimAtlas;

    public HandCartRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new HandCartModel(renderManager.method_32167(NiftyCartsModelLayers.HAND_CART)));
        this.leggings = new class_572(renderManager.method_32167(class_5602.field_27579));
        this.armor = new class_572(renderManager.method_32167(class_5602.field_27580));
        this.armorTrimAtlas = renderManager.method_48481().method_24153(class_4722.field_42071);
        this.field_4673 = 1.0f;
    }

    @Override
    protected void renderContents(HandCartEntity entity, float delta, class_4587 stack, class_4597 source, int packedLight) {
        class_1799 s;
        class_2371<class_1799> cargo = entity.getCargo();
        Contents contents = Contents.SUPPLIES;
        Iterator it = cargo.iterator();
        block0: while (it.hasNext()) {
            s = (class_1799)it.next();
            if (s.method_7960()) continue;
            for (Contents c : Contents.values()) {
                if (!c.predicate.test((class_1799)s)) continue;
                contents = c;
                break block0;
            }
        }
        while (contents != Contents.SUPPLIES && it.hasNext()) {
            s = (class_1799)it.next();
            if (s.method_7960() || contents.predicate.test((class_1799)s)) continue;
            contents = Contents.SUPPLIES;
            if (contents.predicate.test((class_1799)s)) continue;
            contents = Contents.NONE;
        }
        stack.method_22903();
        ((HandCartModel)this.model).getBody().method_22703(stack);
        if (contents.renderer != null) {
            contents.renderer.render(this, entity, stack, source, packedLight, cargo);
        }
        stack.method_22909();
    }

    private void renderFlowers(HandCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        ((HandCartModel)this.model).getFlowerBasket().method_22698(stack, source.getBuffer(((HandCartModel)this.model).method_23500(this.getTextureLocation(entity))), packedLight, class_4608.field_21444);
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (!(itemStack.method_7909() instanceof class_1747)) continue;
            int ix = i % 2;
            int iz = i / 2;
            class_2680 defaultState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
            class_2680 state = defaultState.method_28498((class_2769)class_2741.field_12533) ? (class_2680)defaultState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609) : defaultState;
            class_1087 model = dispatcher.method_3349(state);
            int rgb = class_310.method_1551().method_1505().method_1697(state, null, null, 0);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            stack.method_22903();
            stack.method_22904(0.0, -0.7, -0.0625);
            stack.method_22905(0.65f, 0.65f, 0.65f);
            stack.method_22904((double)ix, 0.5, (double)iz - 1.0);
            stack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            renderer.method_3367(stack.method_23760(), source.getBuffer(class_1921.method_23581()), state, model, r, g, b, packedLight, class_4608.field_21444);
            stack.method_22909();
        }
    }

    private void renderWheel(HandCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        stack.method_22903();
        stack.method_22904(0.91, 0.05, -0.15);
        class_630 wheel = ((HandCartModel)this.model).getWheel();
        wheel.field_3654 = 0.9f;
        wheel.field_3674 = 0.9424779f;
        wheel.method_22698(stack, source.getBuffer(((HandCartModel)this.model).method_23500(this.getTextureLocation(entity))), packedLight, class_4608.field_21444);
        stack.method_22909();
    }

    private void renderPaintings(HandCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        class_4588 buf = source.getBuffer(class_1921.method_23572((class_2960)class_310.method_1551().method_18321().method_18342().method_45852()));
        Random rng = new Random(entity.method_5667().getMostSignificantBits() ^ entity.method_5667().getLeastSignificantBits());
        stack.method_22903();
        stack.method_22904(0.0, -0.15625, 0.0);
        stack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
        class_5455 registryAccess = entity.method_37908().method_30349();
        ObjectArrayList variants = new ObjectArrayList();
        registryAccess.method_30530(class_7924.field_41209).method_40286(class_7406.field_38929).forEach(arg_0 -> HandCartRenderer.lambda$renderPaintings$0((ObjectList)variants, arg_0));
        ObjectLists.shuffle((ObjectList)variants, (Random)rng);
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (itemStack.method_7960()) continue;
            class_9279 customData = (class_9279)itemStack.method_57825(class_9334.field_49609, (Object)class_9279.field_49302);
            Optional<Object> paintingVariant = Optional.empty();
            if (!customData.method_57458()) {
                paintingVariant = customData.method_59980((DynamicOps)registryAccess.method_57093((DynamicOps)class_2509.field_11560), (MapDecoder)class_1534.field_49238).result().map(class_6880::comp_349);
            }
            if (paintingVariant.isEmpty() || ((class_1535)paintingVariant.get()).method_59947() > 1) {
                if (variants.isEmpty()) continue;
                paintingVariant = Optional.of((class_1535)variants.get(i % variants.size()));
            }
            stack.method_22903();
            stack.method_22904(0.0, 0.03, -0.0625 * (double)i + (double)1.0E-4f);
            stack.method_22907(class_7833.field_40718.rotation(rng.nextFloat() * (float)Math.PI * 0.2f));
            CargoRenderUtil.renderPainting((class_1535)paintingVariant.get(), stack, buf, packedLight);
            stack.method_22909();
        }
        stack.method_22909();
    }

    private void renderSupplies(HandCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        class_918 renderer = class_310.method_1551().method_1480();
        Random rng = new Random();
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (itemStack.method_7960()) continue;
            int ix = i % 2;
            int iz = i / 2;
            if (i < cargo.size() - 2 && ((class_1799)cargo.get(i + 2)).method_31573(class_3489.field_16444) || i >= 2 && ((class_1799)cargo.get(i - 2)).method_31573(class_3489.field_16444)) continue;
            double x = (double)((ix * 2 - 1) * 4) / 16.0;
            double z = (double)((iz * 2 - 1) * 5) / 16.0;
            class_1087 model = renderer.method_4019(itemStack, entity.method_37908(), null, i);
            stack.method_22903();
            if (model.method_4712() && itemStack.method_7909() != class_1802.field_8547 && ((Boolean)NiftyCartsConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                stack.method_22904(x, -0.46, z);
                stack.method_22905(0.5f, 0.5f, 0.5f);
                stack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                if (itemStack.method_7909() == class_1802.field_8255) {
                    stack.method_22905(1.2f, 1.2f, 1.2f);
                    stack.method_22907(class_7833.field_40716.rotationDegrees(ix == 0 ? -90.0f : 90.0f));
                    stack.method_22904(0.5, 0.8, -0.05);
                    stack.method_22907(class_7833.field_40714.rotationDegrees(-22.5f));
                } else if (iz < 1 && itemStack.method_31573(class_3489.field_16444)) {
                    stack.method_22904(0.0, 0.0, 1.0);
                } else if (!model.method_4713()) {
                    stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                }
                renderer.method_23179(itemStack, class_811.field_4315, false, stack, source, packedLight, class_4608.field_21444, model);
            } else {
                rng.setSeed(32L * (long)i + (long)Objects.hashCode(class_7923.field_41178.method_10221((Object)itemStack.method_7909())));
                stack.method_22904(x, -0.15 + ((ix + iz) % 2 == 0 ? 0.0 : 1.0E-4), z);
                if (class_1738.class.equals(itemStack.method_7909().getClass()) && ((Boolean)NiftyCartsConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                    stack.method_22905(0.9f, 0.9f, 0.9f);
                    this.renderArmor(stack, source, packedLight, itemStack, ix);
                } else {
                    stack.method_22905(0.6f, 0.6f, 0.6f);
                    stack.method_22907(class_7833.field_40716.rotation(rng.nextFloat() * (float)Math.PI));
                    stack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                    int copies = Math.min(itemStack.method_7947(), (itemStack.method_7947() - 1) / 16 + 2);
                    renderer.method_23179(itemStack, class_811.field_4319, false, stack, source, packedLight, class_4608.field_21444, model);
                    for (int n = 1; n < copies; ++n) {
                        stack.method_22903();
                        stack.method_22907(class_7833.field_40718.rotation(rng.nextFloat() * (float)Math.PI));
                        stack.method_22904((double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), -0.1 * (double)n);
                        renderer.method_23179(itemStack, class_811.field_4319, false, stack, source, packedLight, class_4608.field_21444, model);
                        stack.method_22909();
                    }
                }
            }
            stack.method_22909();
        }
    }

    private class_1304 getEquipmentSlotForItem(class_1799 itemStack) {
        class_5151 equipable = class_5151.method_48957((class_1799)itemStack);
        if (equipable != null) {
            return equipable.method_7685();
        }
        return class_1304.field_6173;
    }

    private void renderArmor(class_4587 stack, class_4597 source, int packedLight, class_1799 itemStack, int ix) {
        class_1792 item = itemStack.method_7909();
        if (!(item instanceof class_1738)) {
            return;
        }
        class_1738 armorItem = (class_1738)item;
        class_1304 slot = this.getEquipmentSlotForItem(itemStack);
        class_572<class_1309> m = slot == class_1304.field_6172 ? this.leggings : this.armor;
        stack.method_22907(class_7833.field_40716.rotation(ix == 0 ? 1.5707964f : -1.5707964f));
        m.method_2805(false);
        m.field_3399 = class_572.class_573.field_3409;
        m.field_3395 = class_572.class_573.field_3409;
        m.field_3400 = false;
        m.field_3396 = 0.0f;
        m.field_3448 = false;
        switch (slot) {
            case field_6169: {
                stack.method_22904(0.0, 0.1, 0.0);
                m.field_3398.field_3654 = 0.2f;
                m.field_3394.method_17138(m.field_3398);
                m.field_3398.field_3665 = true;
                m.field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                stack.method_22904(0.0, -0.4, -0.15);
                m.field_27433.field_3654 = -0.15f;
                m.field_3401.field_3654 = -0.15f;
                m.field_3391.field_3654 = 0.9f;
                m.field_3391.field_3665 = true;
                m.field_3401.field_3665 = true;
                m.field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                stack.method_22904(0.0, -0.7, -0.15);
                m.field_3391.field_3654 = 0.0f;
                m.field_3392.field_3654 = 1.2f;
                m.field_3397.field_3654 = 1.2f;
                m.field_3392.field_3675 = -0.3f;
                m.field_3397.field_3675 = 0.3f;
                m.field_3391.field_3665 = true;
                m.field_3392.field_3665 = true;
                m.field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                stack.method_22904(0.0, -1.15, -0.1);
                m.field_3392.field_3654 = 0.0f;
                m.field_3397.field_3654 = 0.0f;
                m.field_3392.field_3675 = -0.1f;
                m.field_3397.field_3675 = 0.0f;
                m.field_3392.field_3665 = true;
                m.field_3397.field_3665 = true;
            }
        }
        stack.method_22905(0.75f, 0.75f, 0.75f);
        class_1741 material = (class_1741)armorItem.method_7686().comp_349();
        int rgb = itemStack.method_31573(class_3489.field_48803) ? class_5253.class_5254.method_57174((int)class_9282.method_57470((class_1799)itemStack, (int)-6265536)) : -1;
        boolean usesInnerModel = slot == class_1304.field_6172;
        for (class_1741.class_9196 layer : material.comp_2302()) {
            int k = layer.method_56692() ? rgb : -1;
            class_4588 vertexConsumer = source.getBuffer(class_1921.method_25448((class_2960)layer.method_56693(usesInnerModel)));
            m.method_2828(stack, vertexConsumer, packedLight, class_4608.field_21444, k);
        }
        class_8053 armorTrim = (class_8053)itemStack.method_57824(class_9334.field_49607);
        if (armorTrim != null) {
            class_1058 textureAtlasSprite = this.armorTrimAtlas.method_4608(usesInnerModel ? armorTrim.method_48434(armorItem.method_7686()) : armorTrim.method_48436(armorItem.method_7686()));
            class_4588 vertexConsumer = textureAtlasSprite.method_24108(source.getBuffer(class_4722.method_48480((boolean)((class_8056)armorTrim.method_48424().comp_349()).comp_1905())));
            m.method_2828(stack, vertexConsumer, packedLight, class_4608.field_21444, rgb);
        }
        if (itemStack.method_7958()) {
            m.method_2828(stack, source.getBuffer(class_1921.method_27949()), packedLight, class_4608.field_21444, rgb);
        }
    }

    @NotNull
    public class_2960 getTextureLocation(HandCartEntity entity) {
        return class_2960.method_60655((String)"niftycarts", (String)("textures/entity/" + entity.getWoodType().comp_1299() + "_hand_cart.png"));
    }

    private static /* synthetic */ void lambda$renderPaintings$0(ObjectList variants, class_6880 variantHolder) {
        if (((class_1535)variantHolder.comp_349()).method_59947() == 1) {
            variants.add((Object)((class_1535)variantHolder.comp_349()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static enum Contents {
        FLOWERS(s -> s.method_7909() instanceof class_1747 && s.method_31573(class_3489.field_20344) && (Boolean)NiftyCartsConfig.getClient().renderSupplyFlowers.get() != false, HandCartRenderer::renderFlowers),
        PAINTINGS(s -> s.method_7909() == class_1802.field_8892 && (Boolean)NiftyCartsConfig.getClient().renderSupplyPaintings.get() != false, HandCartRenderer::renderPaintings),
        WHEEL(s -> s.method_7909() == NiftyCarts.WHEEL && (Boolean)NiftyCartsConfig.getClient().renderSupplyWheel.get() != false, HandCartRenderer::renderWheel),
        SUPPLIES(s -> (Boolean)NiftyCartsConfig.getClient().renderSupplies.get(), HandCartRenderer::renderSupplies),
        NONE(s -> true, null);

        private final Predicate<? super class_1799> predicate;
        private final ContentsRenderer renderer;

        private Contents(Predicate<? super class_1799> predicate, ContentsRenderer renderer) {
            this.predicate = predicate;
            this.renderer = renderer;
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    private static interface ContentsRenderer {
        public void render(HandCartRenderer var1, HandCartEntity var2, class_4587 var3, class_4597 var4, int var5, class_2371<class_1799> var6);
    }
}

