/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class NiftyCartsConfig {
    public static Common get() {
        return Holder.COMMON;
    }

    public static ForgeConfigSpec spec() {
        return Holder.COMMON_SPEC;
    }

    public static Client getClient() {
        return Holder.CLIENT;
    }

    public static ForgeConfigSpec clientSpec() {
        return Holder.CLIENT_SPEC;
    }

    private static final class Holder {
        private static final Common COMMON;
        private static final ForgeConfigSpec COMMON_SPEC;
        private static final Client CLIENT;
        private static final ForgeConfigSpec CLIENT_SPEC;

        private Holder() {
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
            COMMON = (Common)specPair.getLeft();
            COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
            Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
            CLIENT = (Client)clientSpecPair.getLeft();
            CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        }
    }

    public static class Common {
        public final CartConfig supplyCart;
        public final CartConfig animalCart;
        public final CartConfig plow;
        public final CartConfig handCart;
        public final CartConfig reaper;
        public final CartConfig seedDrill;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration for all carts and cart-like vehicles, check log for automatic \"pull_animals\" list.").push("carts");
            this.supplyCart = new CartConfig(builder, "supply_cart", "The Supply Cart, a type of cart that stores items");
            this.animalCart = new CartConfig(builder, "animal_cart", "The Animal Cart, a type of cart to haul other animals");
            this.plow = new CartConfig(builder, "plow", "The Plow, an animal pulled machine for tilling soil and creating paths");
            ArrayList<String> list = new ArrayList<String>();
            list.add("minecraft:player");
            this.handCart = new CartConfig(builder, "hand_cart", "The Hand Cart, a player pulled cart that stores items", list, 0.0);
            this.reaper = new CartConfig(builder, "reaper", "The Reaper, a cart that harvests crops");
            this.seedDrill = new CartConfig(builder, "seed_drill", "The Seed Drill, a cart that plants crops");
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue renderSupplies;
        public final ForgeConfigSpec.BooleanValue renderSupplyGear;
        public final ForgeConfigSpec.BooleanValue renderSupplyFlowers;
        public final ForgeConfigSpec.BooleanValue renderSupplyPaintings;
        public final ForgeConfigSpec.BooleanValue renderSupplyWheel;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration to disable the rendering of certain supplies in the supply cart");
            this.renderSupplies = builder.comment("Enables/Disables the rendering of all supplies").define("render_supplies", true);
            this.renderSupplyGear = builder.comment("Falls back to rendering as items if false").define("render_supply_gear", true);
            this.renderSupplyFlowers = builder.comment("Falls back to rendering as items if false").define("render_supply_flowers", true);
            this.renderSupplyPaintings = builder.comment("Falls back to rendering as items if false").define("render_supply_paintings", true);
            this.renderSupplyWheel = builder.comment("Falls back to rendering as items if false").define("render_supply_wheel", true);
        }
    }

    public static class CartConfig {
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> pullEntities;
        public final ForgeConfigSpec.DoubleValue slowSpeed;
        public final ForgeConfigSpec.DoubleValue pullSpeed;
        public final ForgeConfigSpec.IntValue destroyDamage;

        CartConfig(ForgeConfigSpec.Builder builder, String name, String description) {
            this(builder, name, description, new ArrayList<String>(), 0.0);
        }

        CartConfig(ForgeConfigSpec.Builder builder, String name, String description, ArrayList<String> defaultEntityList, double defaultPullSpeed) {
            builder.comment(description).push(name);
            this.pullEntities = builder.comment("Entity that are able to pull this cart, such as [\"minecraft:horse\"]\nAn empty list defaults to all which may wear a saddle but not steered by an item").define("pull_animals", defaultEntityList);
            this.slowSpeed = builder.comment("Slow speed modifier toggled by the sprint key").defineInRange("slow_speed", -0.65, -1.0, 0.0);
            this.pullSpeed = builder.comment("Base speed modifier applied to animals (-0.5 = half normal speed)").defineInRange("pull_speed", 0.0, -1.0, defaultPullSpeed);
            this.destroyDamage = builder.comment("Damage needed to destroy the cart. Damage accumulates over time but decays at a rate of 2 damage per second.").defineInRange("destroy_damage", 4, 1, 100);
            builder.pop();
        }
    }
}

