/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.reward.builtin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public class CommandReward
implements Reward {
    public static final class_2960 ID = SkillsMod.createIdentifier("command");
    private final Map<UUID, Integer> counts = new HashMap<UUID, Integer>();
    private final String command;
    private final String unlockCommand;
    private final String lockCommand;

    private CommandReward(String command, String unlockCommand, String lockCommand) {
        this.command = command;
        this.unlockCommand = unlockCommand;
        this.lockCommand = lockCommand;
    }

    public static void register() {
        SkillsAPI.registerReward(ID, CommandReward::parse);
    }

    private static Result<CommandReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(CommandReward::parse, context));
    }

    private static Result<CommandReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        String command = rootObject.get("command").getSuccess().flatMap(jsonElement -> jsonElement.getAsString().ifFailure(problems::add).getSuccess()).orElse("");
        String unlockCommand = rootObject.get("unlock_command").getSuccess().flatMap(jsonElement -> jsonElement.getAsString().ifFailure(problems::add).getSuccess()).orElse("");
        String lockCommand = rootObject.get("lock_command").getSuccess().flatMap(jsonElement -> jsonElement.getAsString().ifFailure(problems::add).getSuccess()).orElse("");
        if (problems.isEmpty()) {
            return Result.success(new CommandReward(command, unlockCommand, lockCommand));
        }
        return Result.failure(Problem.combine(problems));
    }

    private void executeCommand(class_3222 player, String command) {
        if (command.isBlank()) {
            return;
        }
        MinecraftServer server = Objects.requireNonNull(player.method_5682());
        server.method_3734().method_44252(player.method_5671().method_9217().method_9206(server.method_21714()), command);
    }

    @Override
    public void update(RewardUpdateContext context) {
        class_3222 player = context.getPlayer();
        if (context.isAction()) {
            this.executeCommand(player, this.command);
        }
        this.counts.compute(player.method_5667(), (uuid, count) -> {
            Integer n;
            if (count == null) {
                count = 0;
            }
            while (context.getCount() > count) {
                this.executeCommand(player, this.unlockCommand);
                n = count;
                count = count + 1;
            }
            while (context.getCount() < count) {
                this.executeCommand(player, this.lockCommand);
                n = count;
                count = count - 1;
            }
            return count;
        });
    }

    @Override
    public void dispose(RewardDisposeContext context) {
        for (Map.Entry<UUID, Integer> entry : this.counts.entrySet()) {
            class_3222 player = context.getServer().method_3760().method_14602(entry.getKey());
            if (player == null) continue;
            for (int i = 0; i < entry.getValue(); ++i) {
                this.executeCommand(player, this.lockCommand);
            }
        }
        this.counts.clear();
    }
}

