/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.core.v1.common.text;

import com.google.common.collect.Lists;
import dev.obscuria.fragmentum.api.v1.common.text.TextWrapper;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public final class TextWrapperImpl
implements TextWrapper {
    private static final String BREAKER = "\n";
    private final String text;
    private final IntObjectMap<String> prefixByLine = new IntObjectHashMap();
    private final IntObjectMap<class_2583> styleByLine = new IntObjectHashMap();
    private Function<String, class_2561> fragment = class_2561::method_43470;
    private String defaultPrefix = "";
    private class_2583 defaultStyle = class_2583.field_24360;
    private int maxLength = 40;

    public TextWrapperImpl(class_2561 component) {
        this(component.getString());
    }

    public TextWrapperImpl(String text) {
        this.text = text;
    }

    @Override
    public TextWrapper withMaxLength(int length) {
        this.maxLength = length;
        return this;
    }

    @Override
    public TextWrapper withPrefix(String prefix) {
        this.defaultPrefix = prefix;
        return this;
    }

    @Override
    public TextWrapper withLinePrefix(int index, String prefix) {
        this.prefixByLine.put(index, (Object)prefix);
        return this;
    }

    @Override
    public TextWrapper withStyle(class_2583 style) {
        this.defaultStyle = style;
        return this;
    }

    @Override
    public TextWrapper withLineStyle(int index, class_2583 style) {
        this.styleByLine.put(index, (Object)style);
        return this;
    }

    @Override
    public TextWrapper fragment(Function<String, class_2561> function) {
        this.fragment = function;
        return this;
    }

    @Override
    public List<? extends class_2561> build() {
        try {
            ArrayList result = Lists.newArrayList();
            ArrayList words = Lists.newArrayList(Arrays.stream(this.text.replace(BREAKER, " #$# ").split(" ")).filter(word -> !word.isBlank()).toList());
            while (!words.isEmpty()) {
                class_5250 line = class_2561.method_43470((String)((String)this.prefixByLine.getOrDefault((Object)result.size(), (Object)this.defaultPrefix)));
                String firstWord = (String)words.removeFirst();
                if (firstWord.equals("#$#")) {
                    result.add(line.method_27696((class_2583)this.styleByLine.getOrDefault((Object)result.size(), (Object)this.defaultStyle)));
                    continue;
                }
                line.method_10852(this.fragment.apply(firstWord));
                while (!words.isEmpty()) {
                    String word2 = (String)words.getFirst();
                    if (word2.equals("#$#")) {
                        words.removeFirst();
                        break;
                    }
                    class_2561 finalWord = this.fragment.apply(word2);
                    if (TextWrapperImpl.getLength(line.getString() + " " + finalWord.getString()) > this.maxLength) break;
                    line.method_27693(" ").method_10852(finalWord);
                    words.removeFirst();
                }
                result.add(line.method_27696((class_2583)this.styleByLine.getOrDefault((Object)result.size(), (Object)this.defaultStyle)));
            }
            return result;
        }
        catch (Exception ignored) {
            return Lists.newArrayList();
        }
    }

    public static int getLength(String string) {
        return class_124.method_539((String)string).length();
    }
}

