/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.core.v1.common.easing;

import com.google.common.collect.Lists;
import dev.obscuria.fragmentum.api.v1.common.easing.CubicCurve;
import dev.obscuria.fragmentum.api.v1.common.easing.EasingFunction;
import java.util.Comparator;
import java.util.List;

public final class CubicCurveImpl
implements CubicCurve {
    private final List<CubicCurve.Point> rawPoints = Lists.newArrayList();
    private final List<CubicCurve.Point> cachedPoints = Lists.newArrayList();
    private final int resolution;
    private boolean dirty;

    public CubicCurveImpl(int resolution) {
        this.resolution = Math.min(Math.max(resolution, 0), 100);
        this.dirty = true;
    }

    @Override
    public CubicCurveImpl addPoint(float x, float y) {
        this.rawPoints.add(new CubicCurve.Point(Math.clamp(x, 0.0f, 1.0f), Math.clamp(x, 0.0f, 1.0f)));
        this.rawPoints.sort(Comparator.comparingDouble(CubicCurve.Point::x));
        this.dirty = true;
        return this;
    }

    @Override
    public CubicCurve.Point samplePoint(float x) {
        if (this.dirty) {
            this.bake();
        }
        if (this.cachedPoints.isEmpty()) {
            return CubicCurve.Point.ZERO;
        }
        int index = (int)Math.clamp(x * (float)(this.cachedPoints.size() - 1), 0.0f, (float)(this.cachedPoints.size() - 1));
        return this.cachedPoints.get(index);
    }

    @Override
    public double sample(float x) {
        return this.samplePoint(x).y();
    }

    @Override
    public EasingFunction asEasing() {
        return progress -> (float)this.sample(progress);
    }

    public void bake() {
        this.dirty = false;
        this.cachedPoints.clear();
        float res = 1.0f / (float)this.resolution;
        int segments = this.rawPoints.size() - 1;
        for (int i = 0; i < segments; ++i) {
            CubicCurve.Point point = this.rawPoints.get(i);
            CubicCurve.Point nextPoint = this.rawPoints.get(i + 1);
            float xDiff = nextPoint.x() - point.x();
            float yDiff = nextPoint.y() - point.y();
            for (float step = 0.0f; step <= 1.0f; step += res) {
                float x = point.x() + step * xDiff;
                float y = point.y() + step * step * (3.0f * yDiff - 2.0f * step * yDiff);
                this.cachedPoints.add(new CubicCurve.Point(x, y));
            }
        }
    }
}

