/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabric_extras.ranged_weapon.api.AttributeModifierIDs;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;

public class AttributeUtils {
    public static class_9285 mergeComponents(class_9285 target, class_9285 source) {
        if (source == null && target == null) {
            return null;
        }
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        class_9285.class_9286 builder = class_9285.method_57480();
        for (class_9285.class_9287 entry : source.comp_2393()) {
            builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
        }
        for (class_9285.class_9287 entry : target.comp_2393()) {
            builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
        }
        return builder.method_57486();
    }

    public static class_9285 fromRangedConfig(RangedConfig config) {
        class_9274 slot = class_9274.field_49219;
        class_1322 damage = new class_1322(AttributeModifierIDs.WEAPON_DAMAGE_ID, (double)config.damage(), class_1322.class_1323.field_6328);
        class_1322 pullTime = new class_1322(AttributeModifierIDs.WEAPON_PULL_TIME_ID, (double)config.pull_time_bonus(), class_1322.class_1323.field_6328);
        class_9285.class_9286 builder = class_9285.method_57480().method_57487(EntityAttributes_RangedWeapon.DAMAGE.entry, damage, slot).method_57487(EntityAttributes_RangedWeapon.PULL_TIME.entry, pullTime, slot);
        if (config.velocity_bonus() > 0.0f) {
            class_1322 velocity = new class_1322(AttributeModifierIDs.WEAPON_VELOCITY_ID, (double)config.velocity_bonus(), class_1322.class_1323.field_6328);
            builder.method_57487(EntityAttributes_RangedWeapon.VELOCITY.entry, velocity, slot);
        }
        for (ComponentEntry entry : AttributeUtils.componentEntriesFrom(config.attributes(), slot)) {
            builder.method_57487(entry.attribute, entry.modifier, entry.slot);
        }
        return builder.method_57486();
    }

    public static List<ComponentEntry> componentEntriesFrom(List<RangedConfig.Attribute> attributes, class_9274 slot) {
        ArrayList<ComponentEntry> list = new ArrayList<ComponentEntry>();
        if (attributes == null || attributes.isEmpty()) {
            return list;
        }
        for (RangedConfig.Attribute attr : attributes) {
            class_2960 modifierId;
            class_2960 entityAttributeId;
            try {
                entityAttributeId = class_2960.method_12829((String)attr.attributeId());
            }
            catch (Exception e) {
                continue;
            }
            Optional entityAttribute = class_7923.field_41190.method_55841(entityAttributeId);
            if (entityAttribute.isEmpty() || attr.modifier() == null) continue;
            try {
                modifierId = class_2960.method_12829((String)attr.modifier().modifierId());
            }
            catch (Exception e) {
                continue;
            }
            list.add(new ComponentEntry((class_6880<class_1320>)((class_6880)entityAttribute.get()), new class_1322(modifierId, attr.modifier().value(), attr.modifier().operation()), slot));
        }
        return list;
    }

    public record ComponentEntry(class_6880<class_1320> attribute, class_1322 modifier, class_9274 slot) {
    }
}

