/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.api;

import java.util.ArrayList;
import java.util.List;
import net.fabric_extras.ranged_weapon.api.AttributeModifierIDs;
import net.fabric_extras.ranged_weapon.internal.ScalingUtil;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record RangedConfig(float damage, float pull_time_bonus, float velocity_bonus, @Nullable List<Attribute> attributes) {
    public static final RangedConfig EMPTY = new RangedConfig(0.0f, 0.0f, 0.0f);
    public static final RangedConfig BOW = new RangedConfig((float)ScalingUtil.BOW_BASELINE.damage(), 0.0f, 0.0f);
    public static final RangedConfig CROSSBOW = new RangedConfig((float)ScalingUtil.CROSSBOW_BASELINE.damage(), 0.25f, 0.0f);

    public RangedConfig(float damage, float pull_time_bonus, float velocity_bonus) {
        this(damage, pull_time_bonus, velocity_bonus, null);
    }

    public RangedConfig withAttributes(@Nullable List<Attribute> attributes) {
        return new RangedConfig(this.damage, this.pull_time_bonus, this.velocity_bonus, attributes);
    }

    public RangedConfig withAttribute(class_2960 attributeId, class_2960 modifierId, class_1322.class_1323 operation, double value) {
        ArrayList<Attribute> list = new ArrayList<Attribute>(this.attributes != null ? this.attributes : List.of());
        Attribute newEntry = new Attribute(attributeId.toString(), new Modifier(modifierId.toString(), operation, value));
        list.add(newEntry);
        return new RangedConfig(this.damage, this.pull_time_bonus, this.velocity_bonus, list);
    }

    public RangedConfig withAttribute(class_2960 attributeId, class_1322.class_1323 operation, double value) {
        return this.withAttribute(attributeId, AttributeModifierIDs.OTHER_BONUS_ID, operation, value);
    }

    public record Attribute(String attributeId, Modifier modifier) {
    }

    public record Modifier(String modifierId, class_1322.class_1323 operation, double value) {
    }
}

