/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.trinkets;

import com.google.common.collect.BiMap;
import com.mojang.datafixers.util.Either;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.TrinketsAttributeModifiersComponent;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.data.SlotLoader;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories_compat.AccessoriesCompatInit;
import io.wispforest.accessories_compat.api.EntityBindingModifier;
import io.wispforest.accessories_compat.api.ModCompatibilityModule;
import io.wispforest.accessories_compat.api.ReloadListenerRegisterCallback;
import io.wispforest.accessories_compat.api.tags.CollectionAddition;
import io.wispforest.accessories_compat.api.tags.SlotTypesModifier;
import io.wispforest.accessories_compat.trinkets.mixin.accessor.GroupDataAccessor;
import io.wispforest.accessories_compat.trinkets.mixin.accessor.SlotDataAccessor;
import io.wispforest.accessories_compat.trinkets.mixin.accessor.SlotLoaderAccessor;
import io.wispforest.accessories_compat.trinkets.utils.SlotIdRedirect;
import io.wispforest.accessories_compat.trinkets.wrapper.AccessoryFromTrinket;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketFromAccessory;
import io.wispforest.accessories_compat.trinkets.wrapper.TrinketsWrappingUtils;
import io.wispforest.accessories_compat.utils.LoaderPlatformUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import org.jetbrains.annotations.Nullable;

public class TrinketsCompat
extends ModCompatibilityModule {
    public static final TrinketsCompat INSTANCE = TrinketsCompat.create();
    private final class_2960 EMPTY_TEXTURE = class_2960.method_60655((String)"trinkets", (String)"gui/slots/empty.png");

    protected TrinketsCompat() {
        super("trinkets");
    }

    @Nullable
    private static TrinketsCompat create() {
        if (!LoaderPlatformUtils.INSTANCE.isModLoaded("trinkets")) {
            AccessoriesCompatInit.LOGGER.error("Attempted to load the TrinketsCompat while Trinkets the mod is not loaded!");
            return null;
        }
        return new TrinketsCompat();
    }

    @Override
    public void registerDataLoaders(ReloadListenerRegisterCallback callback) {
        callback.registerSlotLoader((class_3302)SlotLoader.INSTANCE, SlotLoader.INSTANCE.getFabricId());
        callback.registerEntitySlotLoader((class_3302)EntitySlotLoader.SERVER, EntitySlotLoader.SERVER.getFabricId());
    }

    @Override
    public void addEntityBindings(EntityBindingModifier modifier) {
        Map<String, Pair<String, Integer>> redirects = SlotIdRedirect.getMap(AccessoriesCompatInit.CONFIG.slotIdRedirects());
        for (Map.Entry<class_1299<?>, Map<String, Set<String>>> entry : TrinketsWrappingUtils.CURRENT_SLOT_INFO.entrySet()) {
            CollectionAddition<String> addition = modifier.addTo(entry.getKey());
            Map<String, Set<String>> groupedSlots = entry.getValue();
            for (Map.Entry<String, Set<String>> groupEntry : groupedSlots.entrySet()) {
                String groupName = groupEntry.getKey();
                for (String slotName : groupEntry.getValue()) {
                    Pair<String, Integer> redirect = redirects.get(groupName + "/" + slotName);
                    String accessoryType = redirect != null ? (String)redirect.key() : TrinketsWrappingUtils.trinketsToAccessories_Slot(Optional.of(groupName), slotName);
                    addition.add(accessoryType);
                }
            }
        }
        TrinketsWrappingUtils.CURRENT_SLOT_INFO.clear();
    }

    @Override
    public void addSlotTypes(SlotTypesModifier modifier) {
        Map<String, Pair<String, Integer>> redirects = SlotIdRedirect.getMap(AccessoriesCompatInit.CONFIG.slotIdRedirects());
        for (Map.Entry<String, GroupDataAccessor> groupDataEntry : ((SlotLoaderAccessor)SlotLoader.INSTANCE).getLoadedSlots().entrySet()) {
            String groupName = groupDataEntry.getKey();
            GroupDataAccessor groupData = groupDataEntry.getValue();
            Map<String, SlotDataAccessor> slots = groupData.getSlots();
            for (Map.Entry<String, SlotDataAccessor> entry : slots.entrySet()) {
                Pair<String, Integer> redirect = redirects.get(groupName + "/" + entry.getKey());
                String accessoryType = redirect != null ? (String)redirect.key() : TrinketsWrappingUtils.trinketsToAccessories_Slot(Optional.of(groupName), entry.getKey());
                SlotDataAccessor slotData = entry.getValue();
                SlotTypeLoader.SlotBuilder builder = modifier.getBuilder(accessoryType);
                if (builder != null) {
                    Integer slotsCurrentSize = builder.baseAmount;
                    if (slotsCurrentSize != null && slotData.getAmount() > slotsCurrentSize) {
                        builder.amount(slotData.getAmount());
                    }
                    if (redirect != null) {
                        builder.addAmount(((Integer)redirect.right()).intValue());
                    }
                } else {
                    builder = modifier.addBuilder(accessoryType);
                    if (slotData.getAmount() != -1) {
                        builder.amount(slotData.getAmount());
                    }
                    builder.order(Integer.valueOf(slotData.getOrder()));
                    class_2960 icon = class_2960.method_60654((String)slotData.getIcon());
                    if (!icon.equals((Object)this.EMPTY_TEXTURE)) {
                        builder.icon(icon);
                    }
                    builder.dropRule(TrinketsWrappingUtils.convertDropRule(TrinketEnums.DropRule.valueOf((String)slotData.getDropRule())));
                    builder.alternativeTranslation("trinkets.slot." + groupDataEntry.getKey() + "." + entry.getKey());
                }
                for (String validatorPredicate : slotData.getValidatorPredicates()) {
                    class_2960 location = class_2960.method_12829((String)validatorPredicate);
                    if (location == null) continue;
                    builder.validator(TrinketsWrappingUtils.trinketsToAccessories_Validators(location));
                }
            }
        }
    }

    @Override
    public SequencedSet<class_2960> toAccessoriesTag(class_2960 tag) {
        BiMap<String, String> redirects = SlotIdRedirect.getBiMap(AccessoriesCompatInit.CONFIG.slotIdRedirects());
        String path = tag.method_12832();
        String[] parts = path.split("/");
        if (parts.length != 2) {
            return new LinkedHashSet<class_2960>();
        }
        String group = parts[0];
        String slot = parts[1];
        return (SequencedSet)Either.unwrap((Either)TrinketsWrappingUtils.trinketsToAccessories_SlotEither(Optional.of(group), slot).mapRight(slotName -> new LinkedHashSet<class_2960>(Set.of(class_2960.method_60655((String)"accessories", (String)slotName)))).mapLeft(slotName -> {
            LinkedHashSet<class_2960> entries = new LinkedHashSet<class_2960>();
            String redirect = (String)redirects.get((Object)tag.method_12832());
            if (redirect != null) {
                entries.add(class_2960.method_60655((String)"accessories", (String)redirect));
            }
            entries.add(class_2960.method_60655((String)"accessories", (String)slotName));
            return entries;
        }));
    }

    @Override
    public SequencedSet<class_2960> fromAccessoriesTag(class_2960 tag) {
        LinkedHashSet<class_2960> entries = new LinkedHashSet<class_2960>();
        SequencedCollection<String> possibleGroups = TrinketsWrappingUtils.getGroupFromDefaultSlot(tag.method_12832());
        for (String group : possibleGroups) {
            entries.add(class_2960.method_60655((String)"trinkets", (String)(group + "/" + TrinketsWrappingUtils.accessoriesToTrinkets_Slot(tag.method_12832()))));
        }
        return entries;
    }

    @Override
    public void getAttributes(class_1799 stack, @Nullable class_1309 entity, String accessoriesSlotName, int slot, AccessoryAttributeBuilder builder) {
        if (!stack.method_57826(TrinketsAttributeModifiersComponent.TYPE)) {
            return;
        }
        for (TrinketsAttributeModifiersComponent.Entry entry : ((TrinketsAttributeModifiersComponent)stack.method_57825(TrinketsAttributeModifiersComponent.TYPE, (Object)TrinketsAttributeModifiersComponent.DEFAULT)).modifiers()) {
            if (entry.slot().isEmpty()) {
                builder.addExclusive(entry.attribute(), entry.modifier());
                continue;
            }
            if (entity == null) continue;
            SlotGroup group = TrinketsWrappingUtils.getGroup(entity.method_37908(), accessoriesSlotName);
            String slotId = TrinketsWrappingUtils.accessoriesToTrinkets_Group(group.name()) + "/" + TrinketsWrappingUtils.accessoriesToTrinkets_Slot(accessoriesSlotName);
            if (!((String)entry.slot().get()).equals(slotId)) continue;
            builder.addExclusive(entry.attribute(), entry.modifier());
        }
    }

    @Override
    public boolean skipOnEquipCheck(class_1799 stack, Accessory accessory) {
        return accessory instanceof AccessoryFromTrinket;
    }

    @Override
    public boolean skipDefaultRenderer(class_1792 item) {
        Trinket trinket = TrinketsApi.getTrinket((class_1792)item);
        return trinket != TrinketsApi.getDefaultTrinket() && !(trinket instanceof TrinketFromAccessory);
    }
}

