/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.wrapper;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

public class CuriosSlotBasedPredicate
implements SlotBasedPredicate {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean hasErrored = false;
    private final class_2960 location;
    private final Predicate<SlotResult> curiosValidator;

    public CuriosSlotBasedPredicate(class_2960 location, Predicate<SlotResult> curiosValidator) {
        this.location = location;
        this.curiosValidator = curiosValidator;
    }

    public TriState isValid(class_1937 level, SlotType slotType, int slot, class_1799 stack) {
        if (this.hasErrored) {
            return TriState.DEFAULT;
        }
        try {
            return TriState.of((boolean)this.curiosValidator.test(new SlotResult(new SlotContext(slotType.name(), null, slot, false, true), stack)));
        }
        catch (Exception e) {
            this.hasErrored = true;
            LOGGER.warn("Unable to handle Curios Slot Predicate converted to Accessories Slot Predicate due to fundamental incompatibility, issues may be present with it! [Slot: {}, Predicate ID: {}]", new Object[]{slotType.name(), this.location, e});
            return TriState.DEFAULT;
        }
    }
}

