/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.wrapper;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.LootingAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import java.util.List;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1560;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_47;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CurioFromAccessory
implements ICurioItem {
    private final Accessory accessory;

    public CurioFromAccessory(Accessory accessory) {
        this.accessory = accessory;
    }

    public void curioTick(SlotContext slotContext, class_1799 stack) {
        this.accessory.tick(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public void onEquip(SlotContext slotContext, class_1799 prevStack, class_1799 stack) {
        this.accessory.onEquip(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public void onUnequip(SlotContext slotContext, class_1799 newStack, class_1799 stack) {
        this.accessory.onUnequip(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public boolean canEquip(SlotContext slotContext, class_1799 stack) {
        return this.accessory.canEquip(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public boolean canUnequip(SlotContext slotContext, class_1799 stack) {
        return this.accessory.canUnequip(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public Multimap<class_6880<class_1320>, class_1322> getAttributeModifiers(SlotContext slotContext, class_2960 id, class_1799 stack) {
        SlotReference ref = CuriosConversionUtils.convertToA(slotContext);
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(ref);
        this.accessory.getDynamicModifiers(stack, ref, builder);
        return builder.getAttributeModifiers(false);
    }

    public void onEquipFromUse(SlotContext slotContext, class_1799 stack) {
        this.accessory.onEquipFromUse(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, class_1799 stack) {
        SoundEventData data = this.accessory.getEquipSound(stack, CuriosConversionUtils.convertToA(slotContext));
        return data == null ? super.getEquipSound(slotContext, stack) : new ICurio.SoundInfo((class_3414)data.event().comp_349(), data.volume(), data.pitch());
    }

    public boolean canEquipFromUse(SlotContext slotContext, class_1799 stack) {
        return this.accessory.canEquipFromUse(stack);
    }

    public void curioBreak(SlotContext slotContext, class_1799 stack) {
        this.accessory.onBreak(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, class_1282 source, boolean recentlyHit, class_1799 stack) {
        return CuriosConversionUtils.dropRuleConvertToC(this.accessory.getDropRule(stack, CuriosConversionUtils.convertToA(slotContext), source));
    }

    public List<class_2561> getAttributesTooltip(List<class_2561> tooltips, class_1792.class_9635 context, class_1799 stack) {
        try {
            this.accessory.getAttributesTooltip(stack, null, tooltips, context, (class_1836)class_1836.field_41070);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return tooltips;
    }

    public int getFortuneLevel(SlotContext slotContext, class_47 lootContext, class_1799 stack) {
        Accessory accessory = this.accessory;
        if (accessory instanceof FortuneAdjustment) {
            FortuneAdjustment adjustment = (FortuneAdjustment)accessory;
            return adjustment.getFortuneAdjustment(stack, CuriosConversionUtils.convertToA(slotContext), lootContext, 0);
        }
        return super.getFortuneLevel(slotContext, lootContext, stack);
    }

    public int getLootingLevel(SlotContext slotContext, @Nullable class_47 lootContext, class_1799 stack) {
        Object object;
        if (lootContext != null && (object = lootContext.method_35508(class_181.field_1230)) instanceof class_1309) {
            class_1309 target = (class_1309)object;
            class_1282 damageSource = (class_1282)lootContext.method_296(class_181.field_1231);
            if (damageSource != null) {
                Accessory accessory = this.accessory;
                if (accessory instanceof LootingAdjustment) {
                    LootingAdjustment lootingAdjustment = (LootingAdjustment)accessory;
                    return lootingAdjustment.getLootingAdjustment(stack, CuriosConversionUtils.convertToA(slotContext), target, damageSource, 0);
                }
                accessory = this.accessory;
                if (accessory instanceof io.wispforest.accessories.api.events.extra.v2.LootingAdjustment) {
                    io.wispforest.accessories.api.events.extra.v2.LootingAdjustment lootingAdjustment = (io.wispforest.accessories.api.events.extra.v2.LootingAdjustment)accessory;
                    return lootingAdjustment.getLootingAdjustment(stack, CuriosConversionUtils.convertToA(slotContext), target, lootContext, damageSource, 0);
                }
            }
        }
        return super.getLootingLevel(slotContext, lootContext, stack);
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, class_1799 stack) {
        TriState state = TriState.DEFAULT;
        Accessory accessory = this.accessory;
        if (accessory instanceof PiglinNeutralInducer) {
            PiglinNeutralInducer inducer = (PiglinNeutralInducer)accessory;
            state = inducer.makePiglinsNeutral(stack, CuriosConversionUtils.convertToA(slotContext));
        }
        return state.orElse(super.makesPiglinsNeutral(slotContext, stack));
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, class_1799 stack) {
        TriState state = TriState.DEFAULT;
        Accessory accessory = this.accessory;
        if (accessory instanceof AllowWalkingOnSnow) {
            AllowWalkingOnSnow predicate = (AllowWalkingOnSnow)accessory;
            state = predicate.allowWalkingOnSnow(stack, CuriosConversionUtils.convertToA(slotContext));
        }
        return state.orElse(super.canWalkOnPowderedSnow(slotContext, stack));
    }

    public boolean isEnderMask(SlotContext slotContext, class_1560 enderMan, class_1799 stack) {
        TriState state = TriState.DEFAULT;
        Accessory accessory = this.accessory;
        if (accessory instanceof EndermanMasked) {
            EndermanMasked predicate = (EndermanMasked)accessory;
            state = predicate.isEndermanMasked(enderMan, stack, CuriosConversionUtils.convertToA(slotContext));
        }
        return state.orElse(super.isEnderMask(slotContext, enderMan, stack));
    }
}

