/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.wrapper;

import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories_compat.curios.mixin.accessories.AccessoriesContainerImplAccessor;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public record AccessoriesBasedStackHandler(AccessoriesContainerImpl container) implements ICurioStacksHandler
{
    public AccessoriesBasedStackHandler(AccessoriesContainer container) {
        this(AccessoriesBasedStackHandler.validate(container));
    }

    private static AccessoriesContainerImpl validate(AccessoriesContainer container) {
        if (!(container instanceof AccessoriesContainerImpl)) {
            throw new IllegalStateException("The given instance of AccessoriesContainer was found not to be of AccessoriesContainerImpl");
        }
        AccessoriesContainerImpl container1 = (AccessoriesContainerImpl)container;
        return container1;
    }

    public IDynamicStackHandler getStacks() {
        return new HandlerImpl((AccessoriesContainer)this.container, false);
    }

    public IDynamicStackHandler getCosmeticStacks() {
        return new HandlerImpl((AccessoriesContainer)this.container, true);
    }

    public class_2371<Boolean> getRenders() {
        return class_2371.method_10212((Object)Boolean.TRUE, (Object[])((Boolean[])this.container.renderOptions().toArray(Boolean[]::new)));
    }

    public int getSlots() {
        return this.container.getSize();
    }

    public boolean isVisible() {
        return true;
    }

    public boolean hasCosmetic() {
        return true;
    }

    public class_2487 serializeNBT() {
        class_2499 list;
        class_5455 registryAccess = this.container.capability().entity().method_56673();
        class_2487 compoundNBT = new class_2487();
        compoundNBT.method_10569("SavedBaseSize", this.container.getBaseSize().intValue());
        compoundNBT.method_10566("Stacks", (class_2520)this.getStacks().serializeNBT((class_7225.class_7874)registryAccess));
        compoundNBT.method_10566("Cosmetics", (class_2520)this.getCosmeticStacks().serializeNBT((class_7225.class_7874)registryAccess));
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.getRenders().size(); ++i) {
            class_2487 tag = new class_2487();
            tag.method_10569("Slot", i);
            tag.method_10556("Render", ((Boolean)this.getRenders().get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Renders", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.getRenders().size());
        compoundNBT.method_10566("Renders", (class_2520)nbt);
        compoundNBT.method_10556("HasCosmetic", true);
        compoundNBT.method_10556("Visible", true);
        compoundNBT.method_10556("RenderToggle", true);
        compoundNBT.method_10582("DropRule", CuriosConversionUtils.dropRuleConvertToC(this.container.slotType().dropRule()).toString());
        AccessoriesContainerImplAccessor accessor = (AccessoriesContainerImplAccessor)this.container;
        if (!accessor.persistentModifiers().isEmpty()) {
            list = new class_2499();
            for (class_1322 attributeModifier : accessor.persistentModifiers()) {
                list.add((Object)attributeModifier.method_26860());
            }
            compoundNBT.method_10566("PersistentModifiers", (class_2520)list);
        }
        if (!accessor.modifiers().isEmpty()) {
            list = new class_2499();
            accessor.modifiers().forEach((uuid, modifier) -> {
                if (!accessor.persistentModifiers().contains(modifier)) {
                    list.add((Object)modifier.method_26860());
                }
            });
            compoundNBT.method_10566("CachedModifiers", (class_2520)list);
        }
        return compoundNBT;
    }

    public void deserializeNBT(class_2487 nbt) {
        class_5455 registryAccess = this.container.capability().entity().method_56673();
        if (nbt.method_10573("PersistentModifiers", 9)) {
            class_2499 list = nbt.method_10554("PersistentModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_1322 attributeModifier = class_1322.method_26859((class_2487)list.method_10602(i));
                if (attributeModifier == null) continue;
                this.addPermanentModifier(attributeModifier);
            }
        }
        AccessoriesContainerImplAccessor accessor = (AccessoriesContainerImplAccessor)this.container;
        if (nbt.method_10573("CachedModifiers", 9)) {
            class_2499 list = nbt.method_10554("CachedModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_1322 attributeModifier = class_1322.method_26859((class_2487)list.method_10602(i));
                if (attributeModifier == null) continue;
                accessor.cachedModifiers().add(attributeModifier);
                this.addTransientModifier(attributeModifier);
            }
        }
        if (nbt.method_10545("Renders")) {
            class_2487 tag = nbt.method_10562("Renders");
            List renderHandler = this.container().renderOptions();
            class_2499 tagList = tag.method_10554("Renders", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 tags = tagList.method_10602(i);
                int slot = tags.method_10550("Slot");
                if (slot < 0 || slot >= renderHandler.size()) continue;
                renderHandler.set(slot, tags.method_10577("Render"));
            }
        }
        if (nbt.method_10545("Stacks")) {
            this.getStacks().deserializeNBT((class_7225.class_7874)registryAccess, nbt.method_10562("Stacks"));
        }
        if (nbt.method_10545("Cosmetics")) {
            this.getCosmeticStacks().deserializeNBT((class_7225.class_7874)registryAccess, nbt.method_10562("Cosmetics"));
        }
        this.update();
    }

    public String getIdentifier() {
        return CuriosConversionUtils.slotConvertToC(this.container.getSlotName());
    }

    public Map<class_2960, class_1322> getModifiers() {
        return this.container.getModifiers();
    }

    public Set<class_1322> getPermanentModifiers() {
        return Set.of();
    }

    public Set<class_1322> getCachedModifiers() {
        return this.container.getCachedModifiers();
    }

    public Collection<class_1322> getModifiersByOperation(class_1322.class_1323 operation) {
        return this.container.getModifiersForOperation(operation);
    }

    public void addTransientModifier(class_1322 modifier) {
        this.container.addTransientModifier(modifier);
    }

    public void addPermanentModifier(class_1322 modifier) {
        this.container.addPersistentModifier(modifier);
    }

    public void removeModifier(class_2960 id) {
        this.container.removeModifier(id);
    }

    public void clearModifiers() {
        this.container.clearModifiers();
    }

    public void clearCachedModifiers() {
        this.container.clearCachedModifiers();
    }

    public void copyModifiers(ICurioStacksHandler other) {
    }

    public void update() {
        this.container.update();
    }

    public class_2487 getSyncTag() {
        return null;
    }

    public void applySyncTag(class_2487 tag) {
    }

    public int getSizeShift() {
        return 0;
    }

    public void grow(int amount) {
    }

    public void shrink(int amount) {
    }

    public static class HandlerImpl
    implements IDynamicStackHandler {
        public final AccessoriesContainer container;
        public final ExpandedSimpleContainer accessories;
        public final boolean isCosmetic;
        public final InvWrapper wrapper;

        public HandlerImpl(AccessoriesContainer container, boolean isCosmetic) {
            this.container = container;
            this.accessories = isCosmetic ? container.getCosmeticAccessories() : container.getAccessories();
            this.isCosmetic = isCosmetic;
            this.wrapper = new InvWrapper((class_1263)this.accessories);
        }

        public void setPreviousStackInSlot(int slot, @NotNull class_1799 stack) {
            this.accessories.setPreviousItem(slot, stack);
        }

        public class_1799 getPreviousStackInSlot(int slot) {
            return this.accessories.getPreviousItem(slot);
        }

        public class_2487 serializeNBT(class_7225.class_7874 provider) {
            ItemStackHandler dummyHandler = new ItemStackHandler(this.accessories.method_54454());
            return dummyHandler.serializeNBT(provider);
        }

        public void deserializeNBT(class_7225.class_7874 provider, class_2487 nbt) {
            class_2499 tagList = nbt.method_10554("Items", 10);
            this.accessories.method_7659(tagList, provider);
        }

        public void setStackInSlot(int slot, @NotNull class_1799 stack) {
            this.wrapper.setStackInSlot(slot, stack);
        }

        @NotNull
        public class_1799 getStackInSlot(int slot) {
            return this.wrapper.getStackInSlot(slot);
        }

        public class_1799 insertItem(int i, class_1799 arg, boolean bl) {
            return this.wrapper.insertItem(i, arg, bl);
        }

        public class_1799 extractItem(int i, int j, boolean bl) {
            return this.wrapper.extractItem(i, j, bl);
        }

        public int getSlotLimit(int i) {
            return this.wrapper.getSlotLimit(i);
        }

        public boolean isItemValid(int i, class_1799 arg) {
            return this.wrapper.isItemValid(i, arg);
        }

        public int getSlots() {
            return this.wrapper.getSlots();
        }

        public void grow(int amount) {
        }

        public void shrink(int amount) {
        }
    }
}

