/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories_compat.curios.pond.SlotContextExtension;
import io.wispforest.accessories_compat.curios.wrapper.AccessoryFromCurio;
import io.wispforest.accessories_compat.curios.wrapper.AccessorySlotResultPredicate;
import io.wispforest.accessories_compat.curios.wrapper.CurioFromAccessory;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import io.wispforest.accessories_compat.curios.wrapper.CuriosSlotBasedPredicate;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.mixin.CuriosImplMixinHooks;

@Mixin(value={CuriosImplMixinHooks.class})
public abstract class CuriosImplMixinHooksMixin {
    @Shadow
    private static Map<String, ISlotType> filteredSlots(Predicate<ISlotType> filter, Map<String, ISlotType> map) {
        return null;
    }

    @Inject(method={"registerCurio"}, at={@At(value="TAIL")})
    private static void registerCurioAsAccessory(class_1792 item, ICurioItem icurio, CallbackInfo ci) {
        if (AccessoriesAPI.getAccessory((class_1792)item) != null) {
            return;
        }
        AccessoriesAPI.registerAccessory((class_1792)item, (Accessory)CuriosConversionUtils.curioConvertToA(icurio));
    }

    @Inject(method={"getCurioFromRegistry"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getAccessoryAsCurio(class_1792 item, CallbackInfoReturnable<Optional<ICurioItem>> cir) {
        Accessory accessory = AccessoriesAPI.getAccessory((class_1792)item);
        if (accessory != null && !(accessory instanceof AccessoryFromCurio)) {
            cir.setReturnValue(Optional.of(new CurioFromAccessory(accessory)));
        }
    }

    @Overwrite
    public static Map<String, ISlotType> getItemStackSlots(class_1799 stack, boolean isClient) {
        return CuriosImplMixinHooksMixin.filteredSlots(slotType -> {
            SlotContext slotContext = new SlotContext(slotType.getIdentifier(), null, 0, false, true);
            SlotContextExtension.from(slotContext).isClient(isClient);
            SlotResult slotResult = new SlotResult(slotContext, stack);
            return CuriosApi.testCurioPredicates((Set)slotType.getValidators(), (SlotResult)slotResult);
        }, CuriosApi.getSlots((boolean)isClient));
    }

    @Inject(method={"getCurio"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getAccessoryAsCurio(class_1799 stack, CallbackInfoReturnable<Optional<ICurio>> cir) {
        Accessory accessory = AccessoriesAPI.getAccessory((class_1799)stack);
        if (accessory != null) {
            cir.setReturnValue(Optional.ofNullable(CuriosConversionUtils.accessoryConvertToC(accessory, stack)));
        }
    }

    @Inject(method={"broadcastCurioBreakEvent"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/network/PacketDistributor;sendToPlayersTrackingEntityAndSelf(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;[Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;)V")})
    private static void broadcastAsAccessoryEvent(SlotContext slotContext, CallbackInfo ci) {
        AccessoriesAPI.breakStack((SlotReference)CuriosConversionUtils.convertToA(slotContext));
        ci.cancel();
    }

    @WrapOperation(method={"getSlotId"}, at={@At(value="INVOKE", target="Ltop/theillusivec4/curios/api/SlotContext;identifier()Ljava/lang/String;")})
    private static String filterForBadChars(SlotContext instance, Operation<String> original) {
        return ((String)original.call(new Object[]{instance})).replace(":", "-");
    }

    @Inject(method={"registerCurioPredicate"}, at={@At(value="TAIL")})
    private static void registerPredicateAsAccessoryPredicate(class_2960 resourceLocation, Predicate<SlotResult> validator, CallbackInfo ci) {
        if (resourceLocation.method_12836().equals("curios")) {
            return;
        }
        AccessoriesAPI.registerPredicate((class_2960)resourceLocation, (SlotBasedPredicate)new CuriosSlotBasedPredicate(resourceLocation, validator));
    }

    @Overwrite
    public static Optional<Predicate<SlotResult>> getCurioPredicate(class_2960 resourceLocation) {
        class_2960 location = CuriosConversionUtils.convertToA(resourceLocation);
        SlotBasedPredicate predicate = AccessoriesAPI.getPredicate((class_2960)location);
        return Optional.of(new AccessorySlotResultPredicate(location, predicate));
    }

    @Overwrite(remap=false)
    public static boolean testCurioPredicates(Set<class_2960> predicates, SlotResult slotResult) {
        predicates = predicates.stream().map(CuriosConversionUtils::convertToA).collect(Collectors.toSet());
        SlotContext ctx = slotResult.slotContext();
        class_1309 livingEntity = ctx.entity();
        class_1937 level = livingEntity != null ? livingEntity.method_37908() : null;
        SlotType slotType = SlotContextExtension.from(ctx).slotType();
        try {
            return AccessoriesAPI.getPredicateResults(predicates, (class_1937)level, (class_1309)livingEntity, (SlotType)slotType, (int)ctx.index(), (class_1799)slotResult.stack());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

