/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mvs.world.structures;

import com.finndog.mvs.modinit.MVSStructures;
import com.finndog.mvs.utils.GeneralUtils;
import com.finndog.mvs.world.structures.codecs.YRangeAllowance;
import com.finndog.mvs.world.structures.pieces.PieceLimitedJigsawManager;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3542;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_4966;
import net.minecraft.class_5434;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_7924;
import net.minecraft.class_9822;

public class GenericJigsawStructure
extends class_3195 {
    public static final MapCodec<GenericJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GenericJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)YRangeAllowance.CODEC.optionalFieldOf("y_allowance").forGetter(structure -> structure.yAllowance), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)class_2960.field_25139.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)class_3542.method_28140(BURYING_TYPE::values).optionalFieldOf("burying_type").forGetter(structure -> structure.buryingType), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_5434.field_52235).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, GenericJigsawStructure::new));
    public final class_6880<class_3785> startPool;
    public final int size;
    public final Optional<YRangeAllowance> yAllowance;
    public final class_6122 startHeight;
    public final Optional<class_2902.class_2903> projectStartToHeightmap;
    public final boolean cannotSpawnInLiquid;
    public final Optional<Integer> terrainHeightCheckRadius;
    public final Optional<Integer> allowedTerrainHeightRange;
    public final Optional<Integer> biomeRadius;
    public final HashSet<class_2960> poolsThatIgnoreBoundaries;
    public final Optional<Integer> maxDistanceFromCenter;
    public final Optional<BURYING_TYPE> buryingType;
    public final boolean useBoundingBoxHack;
    public final class_9822 liquidSettings;

    public GenericJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, Optional<YRangeAllowance> yAllowance, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, HashSet<class_2960> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<BURYING_TYPE> buryingType, boolean useBoundingBoxHack, class_9822 liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.size = size;
        this.yAllowance = yAllowance;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.cannotSpawnInLiquid = cannotSpawnInLiquid;
        this.terrainHeightCheckRadius = terrainHeightCheckRadius;
        this.allowedTerrainHeightRange = allowedTerrainHeightRange;
        this.biomeRadius = biomeRadius;
        this.poolsThatIgnoreBoundaries = poolsThatIgnoreBoundaries;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.buryingType = buryingType;
        this.useBoundingBoxHack = useBoundingBoxHack;
        this.liquidSettings = liquidSettings;
        if (yAllowance.isPresent() && yAllowance.get().maxYAllowed.isPresent() && yAllowance.get().minYAllowed.isPresent() && yAllowance.get().maxYAllowed.get() < yAllowance.get().minYAllowed.get()) {
            throw new RuntimeException("    Moog's Voyager Structures: maxYAllowed cannot be less than minYAllowed.\n    Please correct this error as there's no way to spawn this structure properly\n        Structure pool of problematic structure: %s\n".formatted(startPool.comp_349()));
        }
    }

    protected boolean extraSpawningChecks(class_3195.class_7149 context, class_2338 blockPos) {
        class_1923 chunkPos = context.comp_568();
        if (this.biomeRadius.isPresent() && !(context.comp_563() instanceof class_1973)) {
            int validBiomeRange = this.biomeRadius.get();
            int sectionY = blockPos.method_10264();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += context.comp_562().method_18028(blockPos.method_10263(), blockPos.method_10260(), this.projectStartToHeightmap.get(), context.comp_569(), context.comp_564());
            }
            sectionY = class_5742.method_33100((int)sectionY);
            for (int curChunkX = chunkPos.field_9181 - validBiomeRange; curChunkX <= chunkPos.field_9181 + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - validBiomeRange; curChunkZ <= chunkPos.field_9180 + validBiomeRange; ++curChunkZ) {
                    class_6880 biome = context.comp_563().method_38109(class_5742.method_33102((int)curChunkX), sectionY, class_5742.method_33102((int)curChunkZ), context.comp_564().method_42371());
                    if (context.comp_570().test(biome)) continue;
                    return false;
                }
            }
        }
        if (this.cannotSpawnInLiquid) {
            class_2338 centerOfChunk = chunkPos.method_33943(0);
            int landHeight = context.comp_562().method_18028(centerOfChunk.method_10263(), centerOfChunk.method_10260(), class_2902.class_2903.field_13194, context.comp_569(), context.comp_564());
            class_4966 columnOfBlocks = context.comp_562().method_26261(centerOfChunk.method_10263(), centerOfChunk.method_10260(), context.comp_569(), context.comp_564());
            class_2680 topBlock = columnOfBlocks.method_32892(centerOfChunk.method_10264() + landHeight);
            if (!topBlock.method_26227().method_15769()) {
                return false;
            }
        }
        if (this.terrainHeightCheckRadius.isPresent() && (this.allowedTerrainHeightRange.isPresent() || this.yAllowance.isPresent() && this.yAllowance.get().minYAllowed.isPresent())) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            int terrainCheckRange = this.terrainHeightCheckRadius.get();
            for (int curChunkX = chunkPos.field_9181 - terrainCheckRange; curChunkX <= chunkPos.field_9181 + terrainCheckRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - terrainCheckRange; curChunkZ <= chunkPos.field_9180 + terrainCheckRange; ++curChunkZ) {
                    int height = context.comp_562().method_16397((curChunkX << 4) + 7, (curChunkZ << 4) + 7, this.projectStartToHeightmap.orElse(class_2902.class_2903.field_13194), context.comp_569(), context.comp_564());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                    if (this.yAllowance.isPresent() && this.yAllowance.get().minYAllowed.isPresent() && minTerrainHeight < this.yAllowance.get().minYAllowed.get()) {
                        return false;
                    }
                    if (!this.yAllowance.isPresent() || !this.yAllowance.get().maxYAllowed.isPresent() || minTerrainHeight <= this.yAllowance.get().maxYAllowed.get()) continue;
                    return false;
                }
            }
            if (this.allowedTerrainHeightRange.isPresent() && maxTerrainHeight - minTerrainHeight > this.allowedTerrainHeightRange.get()) {
                return false;
            }
        }
        return true;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        int offsetY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockpos = new class_2338(context.comp_568().method_8326(), offsetY, context.comp_568().method_8328());
        if (!this.extraSpawningChecks(context, blockpos)) {
            return Optional.empty();
        }
        int topClipOff = Integer.MAX_VALUE;
        int bottomClipOff = Integer.MIN_VALUE;
        if (this.yAllowance.isPresent()) {
            if (this.yAllowance.get().maxYAllowed.isPresent()) {
                topClipOff = Math.min(topClipOff, this.yAllowance.get().maxYAllowed.get());
            }
            if (this.yAllowance.get().minYAllowed.isPresent()) {
                bottomClipOff = Math.max(bottomClipOff, this.yAllowance.get().minYAllowed.get());
            }
        }
        int finalTopClipOff = topClipOff;
        int finalBottomClipOff = bottomClipOff;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, this.startPool, this.size, context.comp_561().method_30530(class_7924.field_41246).method_10221((Object)this), blockpos, this.useBoundingBoxHack, this.projectStartToHeightmap, topClipOff, bottomClipOff, this.poolsThatIgnoreBoundaries, this.maxDistanceFromCenter, this.buryingType, this.liquidSettings, (structurePiecesBuilder, pieces) -> this.postLayoutAdjustments((class_6626)structurePiecesBuilder, context, offsetY, blockpos, finalTopClipOff, finalBottomClipOff, (List<class_3790>)pieces));
    }

    protected void postLayoutAdjustments(class_6626 structurePiecesBuilder, class_3195.class_7149 context, int offsetY, class_2338 blockpos, int topClipOff, int bottomClipOff, List<class_3790> pieces) {
        GeneralUtils.centerAllPieces(blockpos, pieces);
        if (this.buryingType.isEmpty()) {
            return;
        }
        if (this.buryingType.get() == BURYING_TYPE.LOWEST_CORNER) {
            class_2902.class_2903 heightMapToUse = this.projectStartToHeightmap.orElse(class_2902.class_2903.field_13194);
            class_3341 box = pieces.get(0).method_14935();
            int highestLandPos = context.comp_562().method_18028(box.method_35415(), box.method_35417(), heightMapToUse, context.comp_569(), context.comp_564());
            highestLandPos = Math.min(highestLandPos, context.comp_562().method_18028(box.method_35415(), box.method_35420(), heightMapToUse, context.comp_569(), context.comp_564()));
            highestLandPos = Math.min(highestLandPos, context.comp_562().method_18028(box.method_35418(), box.method_35417(), heightMapToUse, context.comp_569(), context.comp_564()));
            highestLandPos = Math.min(highestLandPos, context.comp_562().method_18028(box.method_35418(), box.method_35420(), heightMapToUse, context.comp_569(), context.comp_564()));
            if (!(this.cannotSpawnInLiquid || heightMapToUse != class_2902.class_2903.field_13195 && heightMapToUse != class_2902.class_2903.field_13200)) {
                int maxHeightForSubmerging = context.comp_562().method_16398() - box.method_14660();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            } else {
                highestLandPos = Math.max(highestLandPos, context.comp_562().method_16398());
            }
            this.offsetToNewHeight(context, offsetY, pieces, box, highestLandPos);
        } else if (this.buryingType.get() == BURYING_TYPE.AVERAGE_LAND) {
            int maxYAllowed;
            int minYAllowed;
            class_3341 box = pieces.get(0).method_14935();
            class_2338 centerPos = new class_2338((class_2382)box.method_22874());
            int radius = (int)Math.sqrt(box.method_14659().method_10263() * box.method_14659().method_10263() + box.method_14659().method_10260() * box.method_14659().method_10260()) / 2;
            class_2902.class_2903 heightMapToUse = this.projectStartToHeightmap.orElse(class_2902.class_2903.field_13194);
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = context.comp_562().method_18028(centerPos.method_10263() + xOffset, centerPos.method_10260() + zOffset, heightMapToUse, context.comp_569(), context.comp_564());
                    landHeights.add(landHeight);
                }
            }
            if (this.yAllowance.isPresent()) {
                minYAllowed = this.yAllowance.get().minYAllowed.orElse(Integer.MIN_VALUE);
                maxYAllowed = this.yAllowance.get().maxYAllowed.orElse(Integer.MAX_VALUE);
            } else {
                maxYAllowed = Integer.MAX_VALUE;
                minYAllowed = Integer.MIN_VALUE;
            }
            OptionalDouble avgHeightOptional = landHeights.stream().filter(height -> height > minYAllowed && height < maxYAllowed).mapToInt(Integer::intValue).average();
            if (this.yAllowance.isPresent()) {
                if (this.yAllowance.get().maxYAllowed.isPresent() && avgHeightOptional.isEmpty()) {
                    avgHeightOptional = OptionalDouble.of(this.yAllowance.get().maxYAllowed.get().intValue());
                }
                if (this.yAllowance.get().minYAllowed.isPresent() && avgHeightOptional.isEmpty()) {
                    avgHeightOptional = OptionalDouble.of(this.yAllowance.get().minYAllowed.get().intValue());
                }
            }
            if (avgHeightOptional.isPresent()) {
                double avgHeight = avgHeightOptional.getAsDouble();
                if (this.cannotSpawnInLiquid && heightMapToUse != class_2902.class_2903.field_13195 && heightMapToUse != class_2902.class_2903.field_13200) {
                    avgHeight = Math.max(avgHeight, (double)context.comp_562().method_16398());
                    if (this.yAllowance.isPresent() && this.yAllowance.get().maxYAllowed.isPresent()) {
                        avgHeight = Math.max(avgHeight, (double)this.yAllowance.get().maxYAllowed.get().intValue());
                    }
                }
                int parentHeight = pieces.get(0).method_14935().method_35416();
                int offsetAmount = (int)avgHeight - parentHeight + offsetY;
                pieces.forEach(child -> child.method_14922(0, offsetAmount, 0));
            } else {
                pieces.clear();
            }
        } else if (this.buryingType.get() == BURYING_TYPE.LOWEST_SIDE) {
            class_2902.class_2903 heightMapToUse = this.projectStartToHeightmap.orElse(class_2902.class_2903.field_13194);
            class_3341 box = pieces.get(0).method_14935();
            class_2338 centerPos = box.method_22874();
            int highestLandPos = Integer.MAX_VALUE;
            Optional<Integer> minYAllowed = Optional.empty();
            if (this.yAllowance.isPresent()) {
                minYAllowed = this.yAllowance.get().minYAllowed;
            }
            highestLandPos = this.terrainHeight(context, heightMapToUse, box.method_35415(), centerPos.method_10260(), minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, centerPos.method_10263(), box.method_35420(), minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, centerPos.method_10263(), box.method_35417(), minYAllowed, highestLandPos);
            highestLandPos = this.terrainHeight(context, heightMapToUse, box.method_35418(), centerPos.method_10260(), minYAllowed, highestLandPos);
            if (minYAllowed.isPresent() && highestLandPos == Integer.MAX_VALUE) {
                highestLandPos = minYAllowed.get();
            }
            if (!(this.cannotSpawnInLiquid || heightMapToUse != class_2902.class_2903.field_13195 && heightMapToUse != class_2902.class_2903.field_13200)) {
                int maxHeightForSubmerging = context.comp_562().method_16398() - box.method_14660();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            } else {
                highestLandPos = Math.max(highestLandPos, context.comp_562().method_16398());
            }
            this.offsetToNewHeight(context, offsetY, pieces, box, highestLandPos);
        }
    }

    private int terrainHeight(class_3195.class_7149 context, class_2902.class_2903 heightMapToUse, int x, int z, Optional<Integer> minYAllowed, int highestLandPos) {
        int landPos = context.comp_562().method_18028(x, z, heightMapToUse, context.comp_569(), context.comp_564());
        if (minYAllowed.isPresent()) {
            if (landPos >= minYAllowed.get()) {
                highestLandPos = landPos;
            }
        } else {
            highestLandPos = Math.min(highestLandPos, landPos);
        }
        return highestLandPos;
    }

    private void offsetToNewHeight(class_3195.class_7149 context, int offsetY, List<class_3790> pieces, class_3341 box, int highestLandPos) {
        if (this.yAllowance.isPresent()) {
            if (this.yAllowance.get().maxYAllowed.isPresent() && box.method_35419() + offsetY < this.yAllowance.get().minYAllowed.get()) {
                highestLandPos = Math.max(highestLandPos, this.yAllowance.get().maxYAllowed.get());
            }
            if (this.yAllowance.get().minYAllowed.isPresent() && box.method_35416() + offsetY < this.yAllowance.get().minYAllowed.get()) {
                highestLandPos = Math.min(highestLandPos, this.yAllowance.get().minYAllowed.get());
            }
        }
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_567(), context.comp_568().field_9181, context.comp_568().field_9180);
        int heightDiff = highestLandPos - box.method_35416();
        for (class_3443 class_34432 : pieces) {
            class_34432.method_14922(0, heightDiff + offsetY, 0);
        }
    }

    public class_7151<?> method_41618() {
        return MVSStructures.GENERIC_JIGSAW_STRUCTURE.get();
    }

    public static enum BURYING_TYPE implements class_3542
    {
        LOWEST_CORNER("LOWEST_CORNER"),
        AVERAGE_LAND("AVERAGE_LAND"),
        LOWEST_SIDE("LOWEST_SIDE");

        private final String name;
        private static final Map<String, BURYING_TYPE> BY_NAME;

        private BURYING_TYPE(String name) {
            this.name = name;
        }

        public static BURYING_TYPE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String method_15434() {
            return this.name;
        }

        static {
            BY_NAME = (Map)class_156.method_654((Object)Maps.newHashMap(), hashMap -> {
                BURYING_TYPE[] var1;
                for (BURYING_TYPE type : var1 = BURYING_TYPE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

