/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.dungeons_iso.network;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record Capabilities(boolean targetFromCamera, boolean unlimitedReach) implements class_8710
{
    public static final class_8710.class_9154<Capabilities> ID = new class_8710.class_9154(class_2960.method_60655((String)"dungeons_iso", (String)"capabilities"));
    public static final class_9139<class_9129, Capabilities> CODEC = class_9139.method_56435((class_9139)class_9135.field_48547, Capabilities::targetFromCamera, (class_9139)class_9135.field_48547, Capabilities::unlimitedReach, Capabilities::new);

    public static Capabilities all() {
        return new Capabilities(true, true);
    }

    public static Capabilities none() {
        return new Capabilities(false, false);
    }

    public static Capabilities load() {
        try {
            FileReader reader = new FileReader(FabricLoader.getInstance().getConfigDir().resolve("dungeons_iso.capabilities.json").toFile());
            return (Capabilities)new GsonBuilder().registerTypeAdapter(Capabilities.class, (Object)new CapabilitiesDeserializer()).create().fromJson((Reader)reader, Capabilities.class);
        }
        catch (FileNotFoundException e) {
            return Capabilities.none();
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public Capabilities withTargetFromCamera(boolean targetFromCamera) {
        return new Capabilities(targetFromCamera, this.unlimitedReach);
    }

    public Capabilities withUnlimitedReach(boolean unlimitedReach) {
        return new Capabilities(this.targetFromCamera, unlimitedReach);
    }

    public void save() throws IOException {
        FileWriter writer = new FileWriter(FabricLoader.getInstance().getConfigDir().resolve("dungeons_iso.capabilities.json").toFile());
        new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, Capabilities.class, (Appendable)writer);
        writer.close();
    }

    private static class CapabilitiesDeserializer
    implements JsonDeserializer<Capabilities> {
        private CapabilitiesDeserializer() {
        }

        public Capabilities deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Capabilities capabilities = Capabilities.none();
            if (json instanceof JsonObject) {
                JsonPrimitive primitive;
                JsonObject object = (JsonObject)json;
                JsonElement jsonElement = object.get("targetFromCamera");
                if (jsonElement instanceof JsonPrimitive) {
                    primitive = (JsonPrimitive)jsonElement;
                    capabilities = capabilities.withTargetFromCamera(primitive.getAsBoolean());
                }
                if ((jsonElement = object.get("unlimitedReach")) instanceof JsonPrimitive) {
                    primitive = (JsonPrimitive)jsonElement;
                    capabilities = capabilities.withUnlimitedReach(primitive.getAsBoolean());
                }
            }
            return capabilities;
        }
    }
}

