/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.pixeldreamstudios.attributepanel.config.AttributesPanelConfig;

@Environment(value=EnvType.CLIENT)
public class AttributesPanelModMenu
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> this.buildScreen(parent, AttributesPanelModMenu.deepCopyHeaders(AttributesPanelModMenu.safeSettings().headers));
    }

    private class_437 buildScreen(class_437 parent, List<AttributesPanelConfig.HeaderDef> workingHeaders) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"config.attributepanel.title"));
        ConfigEntryBuilder eb = builder.entryBuilder();
        ConfigCategory cat = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.attributepanel.category.general"));
        cat.addEntry((AbstractConfigListEntry)eb.startIntField((class_2561)class_2561.method_43471((String)"config.attributepanel.x_offset"), AttributesPanelConfig.INSTANCE.xOffset).setDefaultValue(-61).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.attributepanel.x_offset.tooltip")}).setSaveConsumer(v -> {
            AttributesPanelConfig.INSTANCE.xOffset = v;
        }).build());
        cat.addEntry((AbstractConfigListEntry)eb.startIntField((class_2561)class_2561.method_43471((String)"config.attributepanel.y_offset"), AttributesPanelConfig.INSTANCE.yOffset).setDefaultValue(10).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.attributepanel.y_offset.tooltip")}).setSaveConsumer(v -> {
            AttributesPanelConfig.INSTANCE.yOffset = v;
        }).build());
        cat.addEntry((AbstractConfigListEntry)eb.startIntField((class_2561)class_2561.method_43470((String)"Panel X offset (relative to inventory)"), AttributesPanelConfig.INSTANCE.panelOffsetX).setDefaultValue(-130).setTooltip(new class_2561[]{class_2561.method_43470((String)"Horizontal offset from the inventory\u2019s top-left (negative = left of it).")}).setSaveConsumer(v -> {
            AttributesPanelConfig.INSTANCE.panelOffsetX = v;
        }).build());
        cat.addEntry((AbstractConfigListEntry)eb.startIntField((class_2561)class_2561.method_43470((String)"Panel Y offset (relative to inventory)"), AttributesPanelConfig.INSTANCE.panelOffsetY).setDefaultValue(0).setTooltip(new class_2561[]{class_2561.method_43470((String)"Vertical offset from the inventory\u2019s top-left.")}).setSaveConsumer(v -> {
            AttributesPanelConfig.INSTANCE.panelOffsetY = v;
        }).build());
        EnumListEntry guiStyleEntry = eb.startEnumSelector((class_2561)class_2561.method_43471((String)"config.attributepanel.gui_style"), AttributesPanelConfig.GuiStyle.class, (Enum)AttributesPanelConfig.INSTANCE.guiStyle).setDefaultValue((Enum)AttributesPanelConfig.GuiStyle.BOOK).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.attributepanel.gui_style.tooltip")}).setSaveConsumer(v -> {
            AttributesPanelConfig.INSTANCE.guiStyle = v;
        }).build();
        cat.addEntry((AbstractConfigListEntry)guiStyleEntry);
        cat.addEntry((AbstractConfigListEntry)eb.startStrList((class_2561)class_2561.method_43470((String)"Percent attributes (0..1)"), new ArrayList<String>(AttributesPanelConfig.INSTANCE.percentAttributes)).setTooltip(new class_2561[]{class_2561.method_43470((String)"Attribute IDs shown as percentages when values are in the 0..1 range, e.g. 0.12 \u2192 12%.\nExample: kevslibrary:multistrike_chance")}).setSaveConsumer(list -> {
            AttributesPanelConfig.INSTANCE.percentAttributes = list;
        }).build());
        cat.addEntry((AbstractConfigListEntry)eb.startStrList((class_2561)class_2561.method_43470((String)"Percent attributes (start at 100%)"), new ArrayList<String>(AttributesPanelConfig.INSTANCE.percentAttributesBase100)).setTooltip(new class_2561[]{class_2561.method_43470((String)"Attribute IDs shown as percentages where 100 = 0% and 200 = 100%, e.g. 110 \u2192 10%.")}).setSaveConsumer(list -> {
            AttributesPanelConfig.INSTANCE.percentAttributesBase100 = list;
        }).build());
        cat.addEntry((AbstractConfigListEntry)eb.startStrList((class_2561)class_2561.method_43470((String)"Percent keywords (0..1)"), new ArrayList<String>(AttributesPanelConfig.INSTANCE.percentKeywords)).setTooltip(new class_2561[]{class_2561.method_43470((String)"If an attribute ID isn\u2019t listed above, match these substrings in the translation key.\nExample: chance, movement_speed")}).setSaveConsumer(list -> {
            AttributesPanelConfig.INSTANCE.percentKeywords = list;
        }).build());
        cat.addEntry((AbstractConfigListEntry)eb.startStrList((class_2561)class_2561.method_43470((String)"Percent keywords (start at 100%)"), new ArrayList<String>(AttributesPanelConfig.INSTANCE.percentBase100Keywords)).setTooltip(new class_2561[]{class_2561.method_43470((String)"If an attribute ID isn\u2019t listed above, match these substrings in the translation key (100 = 0%).")}).setSaveConsumer(list -> {
            AttributesPanelConfig.INSTANCE.percentBase100Keywords = list;
        }).build());
        cat.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Force track visible attributes"), AttributesPanelConfig.INSTANCE.forceTrackVisibleAttributes).setTooltip(new class_2561[]{class_2561.method_43470((String)"Attributes shown on the panel will be force synced from the server. Requires restart to take effect!")}).build());
        SubCategoryBuilder compactSC = eb.startSubCategory((class_2561)class_2561.method_43470((String)"Compact options"));
        compactSC.setExpanded(true);
        compactSC.setRequirement(() -> AttributesPanelModMenu.lambda$buildScreen$10((AbstractConfigListEntry)guiStyleEntry));
        compactSC.add((AbstractConfigListEntry)eb.startStrField((class_2561)class_2561.method_43470((String)"Other header name"), AttributesPanelModMenu.nullToEmpty(AttributesPanelModMenu.safeSettings().otherHeaderName)).setDefaultValue("Other").setTooltip(new class_2561[]{class_2561.method_43470((String)"Title used for the automatic group that collects unmatched attributes.")}).setSaveConsumer(v -> {
            AttributesPanelModMenu.safeSettings().otherHeaderName = AttributesPanelModMenu.emptyToNull(AttributesPanelModMenu.trimOrNull(v));
        }).build());
        compactSC.add((AbstractConfigListEntry)eb.startStrField((class_2561)class_2561.method_43470((String)"Other header icon (optional)"), AttributesPanelModMenu.nullToEmpty(AttributesPanelModMenu.safeSettings().otherHeaderIcon)).setTooltip(new class_2561[]{class_2561.method_43470((String)"Texture path like modid:textures/gui/other.png; leave blank for none.")}).setSaveConsumer(v -> {
            AttributesPanelModMenu.safeSettings().otherHeaderIcon = AttributesPanelModMenu.emptyToNull(AttributesPanelModMenu.trimOrNull(v));
        }).build());
        compactSC.add((AbstractConfigListEntry)eb.startStrList((class_2561)class_2561.method_43470((String)"Global blacklist (globs)"), new ArrayList<String>(AttributesPanelModMenu.safeSettings().globalBlacklist)).setTooltip(new class_2561[]{class_2561.method_43470((String)"Any matching attributes are hidden entirely.")}).setSaveConsumer(list -> {
            AttributesPanelModMenu.safeSettings().globalBlacklist = list;
        }).build());
        compactSC.add((AbstractConfigListEntry)eb.startBooleanToggle((class_2561)class_2561.method_43470((String)"Hide automatic \"Other\" header"), AttributesPanelModMenu.safeSettings().disableOtherHeader).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"If enabled, unmatched attributes are listed without the \"Other\" header.")}).setSaveConsumer(v -> {
            AttributesPanelModMenu.safeSettings().disableOtherHeader = v;
        }).build());
        compactSC.add((AbstractConfigListEntry)eb.startIntField((class_2561)class_2561.method_43470((String)"Side padding"), AttributesPanelModMenu.safeSettings().sidePadding).setDefaultValue(15).setTooltip(new class_2561[]{class_2561.method_43470((String)"Horizontal padding between the panel texture and attribute content.")}).setSaveConsumer(v -> {
            AttributesPanelModMenu.safeSettings().sidePadding = Math.max(0, v);
        }).build());
        compactSC.add((AbstractConfigListEntry)eb.startFloatField((class_2561)class_2561.method_43470((String)"Text scale"), AttributesPanelModMenu.safeSettings().textScale).setDefaultValue(0.55f).setTooltip(new class_2561[]{class_2561.method_43470((String)"Scales the attribute value and name text in the compact view.")}).setSaveConsumer(v -> {
            AttributesPanelModMenu.safeSettings().textScale = Math.max(0.01f, v.floatValue());
        }).build());
        for (int i = 0; i < workingHeaders.size(); ++i) {
            int idx = i;
            AttributesPanelConfig.HeaderDef h = workingHeaders.get(i);
            ArrayList<Object> rows = new ArrayList<Object>();
            rows.add(eb.startStrField((class_2561)class_2561.method_43470((String)"Header label (Text [path])"), AttributesPanelModMenu.nullToEmpty(h.header)).setTooltip(new class_2561[]{class_2561.method_43470((String)"Examples:\n\u2022 Offense [modid:textures/gui/offense.png]\n\u2022 [modid:textures/gui/defense.png]\n\u2022 Utility\nIf an icon can\u2019t be found at runtime, \u201c[cant find texture]\u201d is shown.")}).setSaveConsumer(v -> {
                h.header = AttributesPanelModMenu.emptyToNull(AttributesPanelModMenu.trimOrNull(v));
            }).build());
            List attrRows = h.attributes.stream().map(a -> AttributesPanelModMenu.isBlank(a.icon) ? a.id : a.id + " | " + a.icon).collect(Collectors.toList());
            rows.add(eb.startStrList((class_2561)class_2561.method_43470((String)"Attributes (id or id | icon)"), attrRows).setTooltip(new class_2561[]{class_2561.method_43470((String)"Each line:\n\u2022 Exact id:  minecraft:generic.attack_damage\nOptional icon after a pipe:\n\u2022 spell_engine:crit_chance | kevs-attributes-panel:textures/icons/crit.png\n")}).setSaveConsumer(list -> {
                h.attributes.clear();
                for (String row : list) {
                    String r = AttributesPanelModMenu.trimOrNull(row);
                    if (r == null) continue;
                    String id = r;
                    String icon = null;
                    int p = r.indexOf(124);
                    if (p >= 0) {
                        id = r.substring(0, p).trim();
                        icon = AttributesPanelModMenu.trimOrNull(r.substring(p + 1));
                    }
                    AttributesPanelConfig.AttributeSpec spec = new AttributesPanelConfig.AttributeSpec();
                    spec.id = id;
                    spec.icon = icon;
                    h.attributes.add(spec);
                }
            }).build());
            rows.add(eb.startStrList((class_2561)class_2561.method_43470((String)"Header blacklist (globs)"), new ArrayList<String>(h.blacklist)).setTooltip(new class_2561[]{class_2561.method_43470((String)"Hide matches from this header only.")}).setSaveConsumer(list -> {
                h.blacklist = list;
            }).build());
            rows.add((Object)new InlineButtonEntry((class_2561)class_2561.method_43470((String)""), (class_2561)class_2561.method_43470((String)"Remove this header"), () -> {
                if (idx >= 0 && idx < workingHeaders.size()) {
                    workingHeaders.remove(idx);
                    class_310.method_1551().method_1507(this.buildScreen(parent, workingHeaders));
                }
            }));
            SubCategoryBuilder headerSC = eb.startSubCategory((class_2561)class_2561.method_43470((String)("Header " + (i + 1))));
            headerSC.addAll(rows);
            compactSC.add((AbstractConfigListEntry)headerSC.build());
        }
        compactSC.add((AbstractConfigListEntry)new InlineButtonEntry((class_2561)class_2561.method_43470((String)""), (class_2561)class_2561.method_43470((String)"Add Header +"), () -> {
            AttributesPanelConfig.HeaderDef def = new AttributesPanelConfig.HeaderDef();
            def.header = "New Header";
            workingHeaders.add(def);
            class_310.method_1551().method_1507(this.buildScreen(parent, workingHeaders));
        }));
        cat.addEntry((AbstractConfigListEntry)compactSC.build());
        builder.setSavingRunnable(() -> {
            AttributesPanelConfig.INSTANCE.compact.headers = workingHeaders;
            AttributesPanelConfig.save();
            AttributesPanelConfig.apply();
        });
        return builder.build();
    }

    private static AttributesPanelConfig.CompactSettings safeSettings() {
        if (AttributesPanelConfig.INSTANCE.compact == null) {
            AttributesPanelConfig.INSTANCE.compact = AttributesPanelConfig.CompactSettings.defaultPreset();
        }
        return AttributesPanelConfig.INSTANCE.compact;
    }

    private static List<AttributesPanelConfig.HeaderDef> deepCopyHeaders(List<AttributesPanelConfig.HeaderDef> in) {
        ArrayList<AttributesPanelConfig.HeaderDef> out = new ArrayList<AttributesPanelConfig.HeaderDef>();
        if (in == null) {
            return out;
        }
        for (AttributesPanelConfig.HeaderDef h : in) {
            AttributesPanelConfig.HeaderDef c = new AttributesPanelConfig.HeaderDef();
            c.header = h.header;
            c.blacklist = new ArrayList<String>(h.blacklist == null ? List.of() : h.blacklist);
            c.attributes = new ArrayList<AttributesPanelConfig.AttributeSpec>();
            if (h.attributes != null) {
                for (AttributesPanelConfig.AttributeSpec a : h.attributes) {
                    AttributesPanelConfig.AttributeSpec cc = new AttributesPanelConfig.AttributeSpec();
                    cc.id = a.id;
                    cc.icon = a.icon;
                    c.attributes.add(cc);
                }
            }
            out.add(c);
        }
        return out;
    }

    private static String trimOrNull(String s) {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        return t.isEmpty() ? null : t;
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static String emptyToNull(String s) {
        return s == null || s.isEmpty() ? null : s;
    }

    private static /* synthetic */ boolean lambda$buildScreen$10(AbstractConfigListEntry guiStyleEntry) {
        return guiStyleEntry.getValue() == AttributesPanelConfig.GuiStyle.COMPACT;
    }

    static final class InlineButtonEntry
    extends AbstractConfigListEntry<Void> {
        private final class_4185 button;
        private final class_2561 label;

        InlineButtonEntry(class_2561 label, class_2561 buttonText, Runnable onPress) {
            super(label, false);
            this.label = label;
            this.button = class_4185.method_46430((class_2561)buttonText, b -> onPress.run()).method_46432(120).method_46431();
        }

        public int getItemHeight() {
            return 24;
        }

        public Void getValue() {
            return null;
        }

        public void save() {
        }

        public class_2561 getFieldName() {
            return this.label;
        }

        public Optional<Void> getDefaultValue() {
            return Optional.empty();
        }

        public void render(class_332 ctx, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            class_327 tr = class_310.method_1551().field_1772;
            if (this.label != null && !this.label.getString().isEmpty()) {
                Objects.requireNonNull(tr);
                ctx.method_51439(tr, this.label, x, y + (entryHeight - 9) / 2, 0xFFFFFF, false);
            }
            int w = 120;
            int h = entryHeight - 2;
            this.button.method_46421(x + entryWidth - w);
            this.button.method_46419(y + 1);
            this.button.method_25358(w);
            this.button.method_53533(h);
            this.button.method_25394(ctx, mouseX, mouseY, delta);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button);
        }

        public List<? extends class_6379> narratables() {
            return List.of(this.button);
        }
    }
}

