/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.client;

import java.util.ArrayList;
import java.util.TreeMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.pixeldreamstudios.attributepanel.client.AttributePanelDrawable;
import net.pixeldreamstudios.attributepanel.client.StatEntry;

@Environment(value=EnvType.CLIENT)
class BookAttributePanelDrawable {
    private final AttributePanelDrawable root;
    private static final class_2960 BOOK_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/gui/book.png");
    private static final class_2960 INFO_ICON = class_2960.method_60655((String)"kevs-attributes-panel", (String)"textures/gui/attribute_book.png");
    private static final int INFO_ICON_SIZE = 8;

    BookAttributePanelDrawable(AttributePanelDrawable root) {
        this.root = root;
    }

    void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 tr = this.root.mc().field_1772;
        int rowHeight = 20;
        int padding = 20;
        context.method_25290(BOOK_TEXTURE, this.root.left() - 25, this.root.top(), 0.0f, 0.0f, 240, 230, 240, 230);
        int visibleRows = 6;
        int totalPages = (int)Math.ceil((float)this.root.getCachedStats().size() / (float)visibleRows);
        this.root.setCurrentPage(Math.min(this.root.getCurrentPage(), Math.max(totalPages - 1, 0)));
        if (this.root.getShowOnlyChanged() && this.root.getCachedStats().isEmpty()) {
            String noStatsText = "No changed attributes";
            int textWidth = tr.method_1727(noStatsText);
            this.drawBookButtons(context, tr, mouseX, mouseY, this.root.top() + this.root.panelHeight() - 20);
            context.method_51433(tr, noStatsText, this.root.left() + (this.root.panelWidth() - textWidth) / 2 + 5, this.root.top() + 20, class_124.field_1063.method_532().intValue(), false);
            return;
        }
        int startIndex = this.root.getCurrentPage() * visibleRows;
        int endIndex = Math.min(startIndex + visibleRows, this.root.getCachedStats().size());
        int rowY = this.root.top() + padding;
        int hoverIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            Object valueStr;
            String topLine;
            StatEntry stat = this.root.getCachedStats().get(i);
            int rowIndex = i - startIndex;
            int yOffset = rowY + rowIndex * rowHeight;
            String statName = stat.name().getString();
            int maxNameWidth = this.root.panelWidth() / 2 - 7;
            context.method_25294(this.root.left() + 12, yOffset + rowHeight + 2, this.root.left() + this.root.panelWidth() - 12, yOffset + rowHeight + 1, -2702173);
            Object bottomLine = null;
            if (tr.method_1727(statName) <= maxNameWidth) {
                topLine = statName;
            } else {
                topLine = tr.method_27523(statName, maxNameWidth);
                String remainder = statName.substring(topLine.length()).trim();
                if (!remainder.isEmpty()) {
                    bottomLine = tr.method_27523(remainder, maxNameWidth);
                    if (tr.method_1727(remainder) > maxNameWidth) {
                        while (tr.method_1727((String)bottomLine + "...") > maxNameWidth && ((String)bottomLine).length() > 0) {
                            bottomLine = ((String)bottomLine).substring(0, ((String)bottomLine).length() - 1);
                        }
                        bottomLine = (String)bottomLine + "...";
                    }
                }
            }
            int nameX = this.root.left() + 15;
            int valueX = this.root.left() + this.root.panelWidth() - 12;
            int nameY = yOffset + (rowHeight - 8) / 2;
            if (bottomLine == null) {
                context.method_51433(tr, topLine, nameX, nameY, 3813155, false);
            } else {
                context.method_51433(tr, topLine, nameX, yOffset + 4, 3813155, false);
                context.method_51433(tr, (String)bottomLine, nameX, yOffset + 12, 7167048, false);
            }
            Object object = valueStr = stat.percent() ? String.format("%d%%", (int)(stat.current() * 100.0)) : String.format("%.2f", stat.current());
            int color = stat.isChanged() ? (stat.current() > stat.base() ? class_124.field_1060.method_532() : class_124.field_1061.method_532()) : class_124.field_1080.method_532();
            valueStr = (String)valueStr + (stat.isChanged() ? (stat.current() > stat.base() ? " \u2191" : " \u2193") : "");
            context.method_51433(tr, (String)valueStr, valueX - tr.method_1727((String)valueStr), nameY, color, false);
            if (mouseX < this.root.left() || mouseX > this.root.left() + this.root.panelWidth() || mouseY < yOffset || mouseY > yOffset + rowHeight) continue;
            hoverIndex = i;
        }
        int infoX = this.root.left() + this.root.panelWidth() - 8 - 95;
        int infoY = this.root.top() + 10;
        context.method_25290(INFO_ICON, infoX, infoY, 0.0f, 0.0f, 8, 8, 8, 8);
        if (mouseX >= infoX && mouseX <= infoX + 8 && mouseY >= infoY && mouseY <= infoY + 8) {
            this.drawGlobalBonusTooltip(mouseX, mouseY);
        }
        this.drawBookTooltipButton(context, tr, hoverIndex, mouseX, mouseY, rowHeight, padding);
    }

    boolean mouseClicked(double mouseX, double mouseY, int button) {
        int infoX = this.root.left() + this.root.panelWidth() - 8 - 95;
        int infoY = this.root.top() + 10;
        int btnY = this.root.top() + this.root.panelHeight() - 20;
        ButtonCoords coords = this.getBookButtonCoords(this.root.mc().field_1772);
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, coords.prevX(), btnY, coords.prevW(), 10)) {
            if (this.root.getCurrentPage() > 0) {
                this.root.setCurrentPage(this.root.getCurrentPage() - 1);
            }
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
            }
            return true;
        }
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, coords.nextX(), btnY, coords.nextW(), 10)) {
            int totalPages = (int)Math.ceil((float)this.root.getCachedStats().size() / 6.0f);
            if (this.root.getCurrentPage() < totalPages - 1) {
                this.root.setCurrentPage(this.root.getCurrentPage() + 1);
            }
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
            }
            return true;
        }
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, coords.checkX(), btnY, coords.checkW(), 10)) {
            this.root.setShowOnlyChanged(!this.root.getShowOnlyChanged());
            this.root.setCurrentPage(0);
            this.root.cacheStats();
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private ButtonCoords getBookButtonCoords(class_327 tr) {
        int startX;
        String prevText = "\u00ab\u00ab";
        String nextText = "\u00bb\u00bb";
        String checkLabel = "[ " + (this.root.getShowOnlyChanged() ? "\u2713" : " ") + " ]";
        int spacing = 24;
        int prevW = tr.method_1727(prevText);
        int checkW = tr.method_1727(checkLabel);
        int nextW = tr.method_1727(nextText);
        int totalWidth = prevW + spacing + checkW + spacing + nextW;
        int prevX = startX = this.root.left() + (this.root.panelWidth() - totalWidth) / 2;
        int checkX = prevX + prevW + spacing;
        int nextX = checkX + checkW + spacing;
        return new ButtonCoords(prevX, checkX, nextX, prevW, checkW, nextW);
    }

    private void drawBookButtons(class_332 context, class_327 tr, int mouseX, int mouseY, int btnY) {
        int startX;
        String prevText = "\u00ab\u00ab";
        String nextText = "\u00bb\u00bb";
        String checkLabel = "[ " + (this.root.getShowOnlyChanged() ? "\u2713" : " ") + " ]";
        int spacing = 24;
        int buttonHeight = 10;
        int prevWidth = tr.method_1727(prevText);
        int checkWidth = tr.method_1727(checkLabel);
        int nextWidth = tr.method_1727(nextText);
        int totalWidth = prevWidth + spacing + checkWidth + spacing + nextWidth;
        int prevX = startX = this.root.left() + (this.root.panelWidth() - totalWidth) / 2;
        int checkX = prevX + prevWidth + spacing;
        int nextX = checkX + checkWidth + spacing;
        context.method_51433(tr, prevText, prevX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, prevX, btnY, prevWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
        context.method_51433(tr, checkLabel, checkX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, checkX, btnY, checkWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
        context.method_51433(tr, nextText, nextX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, nextX, btnY, nextWidth, buttonHeight) ? 3813155 : 0xAAAAAA, false);
    }

    private void drawBookTooltipButton(class_332 context, class_327 tr, int hoverIndex, int mouseX, int mouseY, int rowHeight, int padding) {
        this.root.drawTooltipContent(context, tr, hoverIndex, mouseX, mouseY, rowHeight, padding);
        int btnY = this.root.top() + this.root.panelHeight() - 20;
        this.drawBookButtons(context, tr, mouseX, mouseY, btnY);
    }

    private void drawGlobalBonusTooltip(int mouseX, int mouseY) {
        class_746 player = this.root.mc().field_1724;
        if (player == null) {
            return;
        }
        TreeMap<String, Double> flatMap = new TreeMap<String, Double>();
        TreeMap<String, Double> baseMultMap = new TreeMap<String, Double>();
        TreeMap<String, Double> totalMultMap = new TreeMap<String, Double>();
        for (class_6880 entry : class_7923.field_41190.method_40270().toList()) {
            class_1320 attr = (class_1320)entry.comp_349();
            class_1324 instance = player.method_5996(entry);
            if (instance == null || instance.method_6195().isEmpty()) continue;
            String attrName = class_2561.method_43471((String)attr.method_26830()).getString();
            for (class_1322 mod : instance.method_6195()) {
                double value = mod.comp_2449();
                if (Math.abs(value) < 1.0E-4) continue;
                switch (mod.comp_2450()) {
                    case field_6328: {
                        flatMap.merge(attrName, value, Double::sum);
                        break;
                    }
                    case field_6330: {
                        baseMultMap.merge(attrName, value, Double::sum);
                        break;
                    }
                    case field_6331: {
                        totalMultMap.merge(attrName, value, Double::sum);
                    }
                }
            }
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ArrayList<class_1799> icons = new ArrayList<class_1799>();
        lines.add((class_2561)class_2561.method_43471((String)"attributepanel.message.bonuses").method_27692(class_124.field_1065));
        icons.add(class_1799.field_8037);
        boolean addedAny = false;
        for (String attr : flatMap.keySet()) {
            double value = (Double)flatMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+,.2f", attr, value)).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        for (String attr : baseMultMap.keySet()) {
            double value = (Double)baseMultMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+d%% Base", attr, (int)(value * 100.0))).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        for (String attr : totalMultMap.keySet()) {
            double value = (Double)totalMultMap.get(attr);
            lines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+d%% Total", attr, (int)(value * 100.0))).method_27692(class_124.field_1060));
            icons.add(class_1799.field_8037);
            addedAny = true;
        }
        if (!addedAny) {
            lines.add((class_2561)class_2561.method_43470((String)"No active modifiers").method_27692(class_124.field_1080));
            icons.add(class_1799.field_8037);
        }
        this.root.enqueueTooltip(lines, icons, mouseX, mouseY);
    }

    private record ButtonCoords(int prevX, int checkX, int nextX, int prevW, int checkW, int nextW) {
    }
}

