/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.integration.ModernFixCompat;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements class_3262 {
    private static final List<DynamicResourcePack> INSTANCES = Collections.synchronizedList(new ArrayList());
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final class_9224 locationInfo;
    protected final class_2960 resourcePackName;
    protected final boolean hidden;
    protected final boolean fixed;
    protected final class_3288.class_3289 position;
    protected final class_3264 packType;
    protected final Supplier<class_3272> metadata;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<class_2960, byte[]> resources = new ConcurrentHashMap<class_2960, byte[]>();
    protected final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final String mainNamespace;
    protected boolean clearOnReload = true;
    protected Set<class_2960> staticResources = new HashSet<class_2960>();
    protected boolean generateDebugResources;
    boolean addToStatic = false;
    private boolean needsClearingNonStatic = false;
    private static final boolean MODERN_FIX = CompatHandler.MODERNFIX && ModernFixCompat.areLazyResourcesOn();

    @ApiStatus.Internal
    public static void clearAfterReload(class_3264 targetType) {
        for (DynamicResourcePack p : INSTANCES) {
            if (p.packType != targetType) continue;
            p.clearNonStatic();
        }
    }

    @ApiStatus.Internal
    public static void clearBeforeReload(class_3264 targetType) {
        for (DynamicResourcePack p : INSTANCES) {
            if (p.packType != targetType) continue;
            p.clearAllContent();
        }
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type) {
        this(name, type, class_3288.class_3289.field_14280, false, false);
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type, class_3288.class_3289 position, boolean fixed, boolean hidden) {
        this.locationInfo = new class_9224(name.toString(), (class_2561)class_2561.method_43471((String)LangBuilder.getReadableName(name.toString())), class_5352.field_25348, Optional.empty());
        this.packType = type;
        this.resourcePackName = name;
        this.mainNamespace = name.method_12836();
        this.namespaces.add(this.mainNamespace);
        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden;
        this.metadata = Suppliers.memoize(() -> new class_3272(this.makeDescription(), class_155.method_16673().method_48017(type), Optional.empty()));
        this.generateDebugResources = PlatHelper.isDev();
    }

    public class_9224 method_56926() {
        return this.locationInfo;
    }

    public class_2561 makeDescription() {
        return class_2561.method_43471((String)LangBuilder.getReadableName(this.mainNamespace + "_dynamic_resources"));
    }

    public void setClearOnReload(boolean canBeCleared) {
        this.clearOnReload = canBeCleared;
    }

    public void markNotClearable(class_2960 texturePath) {
        this.staticResources.add(texturePath);
    }

    public void unMarkNotClearable(class_2960 staticResources) {
        this.staticResources.remove(staticResources);
    }

    public void setGenerateDebugResources(boolean generateDebugResources) {
        this.generateDebugResources = generateDebugResources;
    }

    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public class_2960 id() {
        return this.resourcePackName;
    }

    public String toString() {
        return this.method_14409();
    }

    public class_2561 getTitle() {
        return this.method_56926().comp_2330();
    }

    public void registerPack() {
        if (!INSTANCES.contains(this)) {
            PlatHelper.registerResourcePack(this.packType, () -> class_3288.method_45275((class_9224)this.locationInfo, (class_3288.class_7680)new class_3288.class_7680(){

                public class_3262 method_52424(class_9224 location) {
                    return DynamicResourcePack.this;
                }

                public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
                    return DynamicResourcePack.this;
                }
            }, (class_3264)this.packType, (class_9225)new class_9225(true, class_3288.class_3289.field_14280, false)));
            INSTANCES.add(this);
        }
    }

    public Set<String> method_14406(class_3264 packType) {
        return this.namespaces;
    }

    public <T> T method_14407(class_3270<T> serializer) {
        try {
            return (T)(serializer == class_3272.field_14202 ? this.metadata.get() : null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_14408(class_3264 packType, String namespace, String id, class_3262.class_7664 output) {
        if (packType == this.packType) {
            DynamicResourcePack dynamicResourcePack = this;
            synchronized (dynamicResourcePack) {
                this.searchTrie.search(namespace + "/" + id).forEach(r -> {
                    byte[] buf = this.resources.get(r);
                    output.accept(r, () -> {
                        if (buf == null) {
                            throw new IllegalStateException("Somehow search tree returned a resource not in resources " + String.valueOf(r));
                        }
                        return new ByteArrayInputStream(buf);
                    });
                });
            }
        }
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        byte[] res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    public void close() {
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    protected void addBytes(class_2960 id, byte[] bytes) {
        this.namespaces.add(id.method_12836());
        this.resources.put(id, bytes);
        this.searchTrie.insert(id);
        if (this.addToStatic) {
            this.markNotClearable(id);
        }
        if (this.generateDebugResources) {
            try {
                Path p = Paths.get("debug", "generated_resource_pack").resolve(id.method_12836() + "/" + id.method_12832());
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public void removeResource(class_2960 res) {
        DynamicResourcePack dynamicResourcePack = this;
        synchronized (dynamicResourcePack) {
            this.searchTrie.remove(res);
            this.resources.remove(res);
            this.staticResources.remove(res);
        }
    }

    @Deprecated(forRemoval=true)
    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    @Deprecated(forRemoval=true)
    private void addJson(class_2960 path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    @Deprecated(forRemoval=true)
    public void addJson(class_2960 location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    @Deprecated(forRemoval=true)
    public void addBytes(class_2960 location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    public class_3264 getPackType() {
        return this.packType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected void clearNonStatic() {
        if (!CommonConfigs.CLEAR_RESOURCES.get().booleanValue()) {
            return;
        }
        if (!this.needsClearingNonStatic) {
            return;
        }
        DynamicResourcePack dynamicResourcePack = this;
        synchronized (dynamicResourcePack) {
            boolean mf;
            this.needsClearingNonStatic = false;
            boolean bl = mf = MODERN_FIX && this.getPackType() == class_3264.field_14188;
            if (!mf) {
                this.searchTrie.clear();
            }
            for (class_2960 class_29602 : this.resources.keySet()) {
                if (mf && this.modernFixHack(class_29602.method_12832()) || this.staticResources.contains(class_29602)) continue;
                this.resources.remove(class_29602);
            }
            if (mf) {
                ArrayList<CallSite> toRemove = new ArrayList<CallSite>();
                for (String namespace : this.searchTrie.listFolders("")) {
                    for (String f : this.searchTrie.listFolders(namespace)) {
                        if (this.modernFixHack(f)) continue;
                        toRemove.add((CallSite)((Object)(namespace + "/" + f)));
                    }
                }
                toRemove.forEach(this.searchTrie::remove);
            }
            for (class_2960 class_29603 : this.staticResources) {
                this.searchTrie.insert(class_29603);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected void clearAllContent() {
        if (this.clearOnReload) {
            DynamicResourcePack dynamicResourcePack = this;
            synchronized (dynamicResourcePack) {
                this.searchTrie.clear();
                this.resources.clear();
                this.needsClearingNonStatic = true;
            }
        }
    }

    private boolean modernFixHack(String s) {
        return s.startsWith("model") || s.startsWith("blockstate");
    }

    public void addTag(SimpleTagBuilder builder, class_5321<?> type) {
    }
}

