/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.feature.noise_path.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.frozenblock.lib.math.api.EasyNoiseSampler;
import net.frozenblock.lib.worldgen.feature.api.feature.noise_path.config.NoiseBandBlockPlacement;
import net.minecraft.class_2902;

public class NoiseBandPlacement {
    public static final MapCodec<NoiseBandPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EasyNoiseSampler.NoiseType.CODEC.fieldOf("noise_type").forGetter(config -> config.noiseType), (App)Codec.DOUBLE.lenientOptionalFieldOf("noise_scale", (Object)1.0).forGetter(config -> config.noiseScale), (App)Codec.BOOL.lenientOptionalFieldOf("include_y_in_noise_calculation", (Object)false).forGetter(config -> config.calculateNoiseWithY), (App)Codec.BOOL.lenientOptionalFieldOf("scale_noise_y", (Object)false).forGetter(config -> config.scaleYNoise), (App)class_2902.class_2903.field_24772.lenientOptionalFieldOf("heightmap").forGetter(config -> config.heightmapType), (App)NoiseBandBlockPlacement.CODEC.listOf().fieldOf("block_placements").forGetter(config -> config.blockPlacements)).apply((Applicative)instance, NoiseBandPlacement::new));
    private final EasyNoiseSampler.NoiseType noiseType;
    private final double noiseScale;
    private final boolean calculateNoiseWithY;
    private final boolean scaleYNoise;
    private final Optional<class_2902.class_2903> heightmapType;
    private final List<NoiseBandBlockPlacement> blockPlacements;

    public NoiseBandPlacement(EasyNoiseSampler.NoiseType noiseType, double noiseScale, boolean calculateNoiseWithY, boolean scaleYNoise, Optional<class_2902.class_2903> heightmapType, List<NoiseBandBlockPlacement> blockPlacements) {
        this.noiseType = noiseType;
        this.noiseScale = noiseScale;
        this.calculateNoiseWithY = calculateNoiseWithY;
        this.scaleYNoise = scaleYNoise;
        this.heightmapType = heightmapType;
        this.blockPlacements = blockPlacements;
    }

    public EasyNoiseSampler.NoiseType getNoiseType() {
        return this.noiseType;
    }

    public double getNoiseScale() {
        return this.noiseScale;
    }

    public boolean calculateNoiseWithY() {
        return this.calculateNoiseWithY;
    }

    public boolean scaleYNoise() {
        return this.scaleYNoise;
    }

    public Optional<class_2902.class_2903> getHeightmapType() {
        return this.heightmapType;
    }

    public List<NoiseBandBlockPlacement> getBlockPlacements() {
        return this.blockPlacements;
    }

    public static class Builder {
        private final EasyNoiseSampler.NoiseType noiseType;
        private double noiseScale = 0.2;
        private boolean calculateNoiseWithY = false;
        private boolean scaleYNoise = false;
        private Optional<class_2902.class_2903> heightmapType = Optional.empty();
        private List<NoiseBandBlockPlacement> blockPlacements = new ArrayList<NoiseBandBlockPlacement>();

        public Builder(EasyNoiseSampler.NoiseType noiseType) {
            this.noiseType = noiseType;
        }

        public Builder noiseScale(double noiseScale) {
            this.noiseScale = noiseScale;
            return this;
        }

        public Builder calculateNoiseWithY() {
            this.calculateNoiseWithY = true;
            return this;
        }

        public Builder scaleYNoise() {
            this.scaleYNoise = true;
            return this;
        }

        public Builder heightmapType(class_2902.class_2903 heightmapType) {
            this.heightmapType = Optional.ofNullable(heightmapType);
            return this;
        }

        public Builder noiseBandBlockPlacement(NoiseBandBlockPlacement blockPlacement) {
            this.blockPlacements = List.of(blockPlacement);
            return this;
        }

        public Builder noiseBandBlockPlacements(NoiseBandBlockPlacement ... blockPlacements) {
            this.blockPlacements = Arrays.stream(blockPlacements).toList();
            return this;
        }

        public NoiseBandPlacement build() {
            if (this.blockPlacements.isEmpty()) {
                throw new IllegalStateException("No NoiseBandBlockPlacements found for NoiseBandPlacement!");
            }
            return new NoiseBandPlacement(this.noiseType, this.noiseScale, this.calculateNoiseWithY, this.scaleYNoise, this.heightmapType, this.blockPlacements);
        }
    }
}

