/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.wind.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Optional;
import net.frozenblock.lib.registry.FrozenLibRegistries;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.wind.impl.networking.WindDisturbancePacket;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_8603;
import org.jetbrains.annotations.NotNull;

public class WindDisturbance<T> {
    public static final DisturbanceResult DUMMY_RESULT = new DisturbanceResult(0.0, 0.0, class_243.field_1353);
    private final Optional<T> source;
    public final class_243 origin;
    public final class_238 affectedArea;
    private final WindDisturbanceLogic<T> disturbanceLogic;

    public WindDisturbance(Optional<T> source, class_243 origin, class_238 affectedArea, WindDisturbanceLogic<T> disturbanceLogic) {
        this.source = source;
        this.origin = origin;
        this.affectedArea = affectedArea;
        this.disturbanceLogic = disturbanceLogic;
    }

    public DisturbanceResult calculateDisturbanceResult(class_1937 level, class_243 windTarget) {
        DisturbanceResult disturbanceResult;
        if (this.affectedArea.method_1006(windTarget) && (disturbanceResult = this.disturbanceLogic.getLogic().calculateDisturbanceResult(this.source, level, this.origin, this.affectedArea, windTarget)) != null) {
            return disturbanceResult;
        }
        return DUMMY_RESULT;
    }

    public boolean isWithinViewDistance(@NotNull class_8603 chunkTrackingView) {
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)this.affectedArea.field_1323, (Object)this.affectedArea.field_1320).iterator();
        while (unmodifiableIterator.hasNext()) {
            double xCorner = (Double)unmodifiableIterator.next();
            UnmodifiableIterator unmodifiableIterator2 = ImmutableList.of((Object)this.affectedArea.field_1321, (Object)this.affectedArea.field_1324).iterator();
            while (unmodifiableIterator2.hasNext()) {
                double zCorner = (Double)unmodifiableIterator2.next();
                class_1923 chunkPos = new class_1923(class_2338.method_49637((double)xCorner, (double)0.0, (double)zCorner));
                if (!chunkTrackingView.method_52364(chunkPos.field_9181, chunkPos.field_9180)) continue;
                return true;
            }
        }
        return false;
    }

    public Optional<WindDisturbancePacket> toPacket() {
        class_2960 resourceLocation = Optional.ofNullable(FrozenLibRegistries.WIND_DISTURBANCE_LOGIC.method_10221(this.disturbanceLogic)).orElseGet(() -> FrozenLibRegistries.WIND_DISTURBANCE_LOGIC_UNSYNCED.method_10221(this.disturbanceLogic));
        if (resourceLocation != null) {
            return Optional.of(new WindDisturbancePacket(this.affectedArea, this.origin, this.getSourceTypeFromSource(), resourceLocation, this.encodePosOrID()));
        }
        return Optional.empty();
    }

    private WindDisturbanceLogic.SourceType getSourceTypeFromSource() {
        if (this.source.isEmpty()) {
            return WindDisturbanceLogic.SourceType.NONE;
        }
        if (this.source.get() instanceof class_1297) {
            return WindDisturbanceLogic.SourceType.ENTITY;
        }
        if (this.source.get() instanceof class_2586) {
            return WindDisturbanceLogic.SourceType.BLOCK_ENTITY;
        }
        return WindDisturbanceLogic.SourceType.NONE;
    }

    private long encodePosOrID() {
        if (this.source.isEmpty()) {
            return 0L;
        }
        T t = this.source.get();
        if (t instanceof class_1297) {
            class_1297 entity = (class_1297)t;
            return entity.method_5628();
        }
        t = this.source.get();
        if (t instanceof class_2586) {
            class_2586 blockEntity = (class_2586)t;
            return blockEntity.method_11016().method_10063();
        }
        return 0L;
    }

    public record DisturbanceResult(double strength, double weight, class_243 wind) {
    }
}

