/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.spotting_icons.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.spotting_icons.api.SpottingIconPredicate;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconPacket;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconRemovePacket;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@ApiStatus.Internal
public class SpottingIconManager {
    public class_1297 entity;
    public int ticksToCheck;
    public SpottingIcon icon;
    public boolean clientHasIconResource;

    public SpottingIconManager(class_1297 entity) {
        this.entity = entity;
    }

    public void tick() {
        if (this.ticksToCheck > 0) {
            --this.ticksToCheck;
        } else {
            this.ticksToCheck = 20;
            if (this.icon != null) {
                if (this.entity.method_37908().field_9236) {
                    this.clientHasIconResource = SpottingIconManager.hasTexture(this.icon.texture());
                }
                if (!SpottingIconPredicate.getPredicate(this.icon.restrictionID).test(this.entity)) {
                    this.removeIcon();
                }
            }
        }
    }

    public void setIcon(class_2960 texture, float startFade, float endFade, class_2960 restrictionID) {
        this.icon = new SpottingIcon(texture, startFade, endFade, restrictionID);
        if (!this.entity.method_37908().field_9236) {
            SpottingIconPacket packet = new SpottingIconPacket(this.entity.method_5628(), texture, startFade, endFade, restrictionID);
            for (class_3222 player : PlayerLookup.tracking((class_1297)this.entity)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
            }
        } else {
            this.clientHasIconResource = SpottingIconManager.hasTexture(this.icon.texture());
        }
        SpottingIconPredicate.getPredicate(this.icon.restrictionID).onAdded(this.entity);
    }

    public void removeIcon() {
        SpottingIconPredicate.getPredicate(this.icon.restrictionID).onRemoved(this.entity);
        this.icon = null;
        if (!this.entity.method_37908().field_9236) {
            SpottingIconRemovePacket packet = new SpottingIconRemovePacket(this.entity.method_5628());
            for (class_3222 player : PlayerLookup.tracking((class_1297)this.entity)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
            }
        }
    }

    public void sendIconPacket(class_3222 player) {
        if (this.icon != null) {
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.method_10804(this.entity.method_5628());
            byteBuf.method_10812(this.icon.texture);
            byteBuf.method_52941(this.icon.startFadeDist);
            byteBuf.method_52941(this.icon.endFadeDist);
            byteBuf.method_10812(this.icon.restrictionID);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SpottingIconPacket(this.entity.method_5628(), this.icon.texture, this.icon.startFadeDist(), this.icon.endFadeDist(), this.icon.restrictionID()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static boolean hasTexture(class_2960 resourceLocation) {
        return class_310.method_1551().method_1478().method_14486(resourceLocation).isPresent();
    }

    public void load(@NotNull class_2487 nbt) {
        this.ticksToCheck = nbt.method_10550("frozenlib_spotting_icon_predicate_cooldown");
        if (nbt.method_10545("frozenlib_spotting_icons")) {
            this.icon = null;
            SpottingIcon.CODEC.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("frozenlib_spotting_icons"))).resultOrPartial(arg_0 -> ((Logger)FrozenLibConstants.LOGGER).error(arg_0)).ifPresent(spottingIcon -> {
                this.icon = spottingIcon;
            });
        }
    }

    public void save(@NotNull class_2487 nbt) {
        nbt.method_10569("frozenlib_spotting_icon_predicate_cooldown", this.ticksToCheck);
        if (this.icon != null) {
            SpottingIcon.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.icon).resultOrPartial(arg_0 -> ((Logger)FrozenLibConstants.LOGGER).error(arg_0)).ifPresent(spottingIcon -> nbt.method_10566("frozenlib_spotting_icons", spottingIcon));
        } else if (nbt.method_10545("frozenlib_spotting_icons")) {
            nbt.method_10551("frozenlib_spotting_icons");
        }
    }

    public record SpottingIcon(class_2960 texture, float startFadeDist, float endFadeDist, class_2960 restrictionID) {
        public static final Codec<SpottingIcon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(SpottingIcon::texture), (App)Codec.FLOAT.fieldOf("startFadeDist").forGetter(SpottingIcon::startFadeDist), (App)Codec.FLOAT.fieldOf("endFadeDist").forGetter(SpottingIcon::endFadeDist), (App)class_2960.field_25139.fieldOf("restrictionID").forGetter(SpottingIcon::restrictionID)).apply((Applicative)instance, SpottingIcon::new));
    }
}

