/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.ParsedToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;

public class CommentToken
extends ParsedToken {
    private final CommentStyle commentStyle;

    public CommentToken(int start, int end, int line, int offset, CommentStyle type, String text) {
        super(start, end, line, offset, TokenType.COMMENT, text);
        this.commentStyle = type;
    }

    public CommentToken(int start, int end, int line, int lastLine, int offset, CommentStyle type, String text) {
        super(start, end, line, lastLine, offset, TokenType.COMMENT, text);
        this.commentStyle = type;
    }

    public CommentToken(String text) {
        super(TokenType.COMMENT, text);
        this.commentStyle = CommentStyle.LINE;
    }

    @Override
    public CommentStyle commentStyle() {
        return this.commentStyle;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CommentToken) {
            CommentToken ct = (CommentToken)other;
            return this.commentStyle == ct.commentStyle && this.parsed.equals(ct.parsed) && this.spanEquals(ct);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(this.type) + "(start:" + this.start + ",end:" + this.end + ",line:" + this.line + ",lastLine:" + this.lastLine + ",offset:" + this.offset + ",commentStyle:" + String.valueOf((Object)this.commentStyle) + ",parsed:'" + this.parsed + "')";
    }
}

