/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.DjsParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.JsonParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.ParsingFunction;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.DjsWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.WritingFunction;

public class JsonContext {
    private static final Map<String, ParsingFunction> PARSERS = new ConcurrentHashMap<String, ParsingFunction>();
    private static final Map<String, WritingFunction> WRITERS = new ConcurrentHashMap<String, WritingFunction>();
    private static final Map<String, String> ALIASES = new ConcurrentHashMap<String, String>();
    private static final ParsingFunction DEFAULT_PARSER = ParsingFunction.fromParser(DjsParser::new);
    private static final WritingFunction DEFAULT_WRITER = WritingFunction.fromWriter(DjsWriter::new);
    private static volatile String eol = System.lineSeparator();
    private static volatile CommentStyle defaultCommentStyle = CommentStyle.LINE;
    private static volatile JsonWriterOptions defaultFormatting = new JsonWriterOptions();
    public static final boolean COMPAT_AVAILABLE;
    public static final boolean TRANSFORM_AVAILABLE;

    public static void addParser(String format, ParsingFunction parser) {
        PARSERS.put(format.toLowerCase(), parser);
    }

    public static void addWriter(String format, WritingFunction writer) {
        WRITERS.put(format.toLowerCase(), writer);
    }

    public static void registerAlias(String alias, String format) {
        ALIASES.put(alias.toLowerCase(), format.toLowerCase());
    }

    public static synchronized String getEol() {
        return eol;
    }

    public static synchronized void setEol(String eol) {
        JsonContext.eol = eol;
    }

    public static synchronized CommentStyle getDefaultCommentStyle() {
        return defaultCommentStyle;
    }

    public static synchronized void setDefaultCommentStyle(CommentStyle style) {
        defaultCommentStyle = style;
    }

    public static synchronized JsonWriterOptions getDefaultFormatting() {
        return new JsonWriterOptions(defaultFormatting);
    }

    public static synchronized void setDefaultFormatting(JsonWriterOptions options) {
        defaultFormatting = options;
    }

    public static boolean isKnownFormat(File file) {
        String ext = JsonContext.getExtension(file);
        return PARSERS.containsKey(ext) || ALIASES.containsKey(ext);
    }

    public static JsonValue autoParse(File file) throws IOException {
        return PARSERS.getOrDefault(JsonContext.getFormat(file), DEFAULT_PARSER).parse(file);
    }

    public static void autoWrite(File file, JsonValue value) throws IOException {
        WRITERS.getOrDefault(JsonContext.getFormat(file), DEFAULT_WRITER).write(file, value, defaultFormatting);
    }

    private static String getFormat(File file) {
        String ext = JsonContext.getExtension(file);
        return ALIASES.getOrDefault(ext, ext);
    }

    private static String getExtension(File file) {
        int index = file.getName().lastIndexOf(46);
        return index < 0 ? "djs" : file.getName().substring(index + 1).toLowerCase();
    }

    private static boolean isClassAvailable(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static {
        PARSERS.put("json", ParsingFunction.fromParser(JsonParser::new));
        PARSERS.put("djs", DEFAULT_PARSER);
        WRITERS.put("json", WritingFunction.fromWriter(JsonWriter::new));
        WRITERS.put("djs", DEFAULT_WRITER);
        ALIASES.put("xjs", "djs");
        COMPAT_AVAILABLE = JsonContext.isClassAvailable("net.frozenblock.lib.shadow.xjs.compat.serialization.XjsCompat");
        TRANSFORM_AVAILABLE = JsonContext.isClassAvailable("xjs.transform.JsonTransformer");
    }
}

