/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.blue.endless.jankson.api;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonArray;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonElement;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonNull;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonObject;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonPrimitive;
import org.jetbrains.annotations.Nullable;

public class JanksonOps
implements DynamicOps<JsonElement> {
    public static final JanksonOps INSTANCE = new JanksonOps(false);
    public static final JanksonOps COMPRESSED = new JanksonOps(true);
    public static final DSL.TypeReference TYPE = () -> "JANKSON";
    private final boolean compressed;

    protected JanksonOps(boolean compressed) {
        this.compressed = compressed;
    }

    public JsonElement empty() {
        return JsonNull.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> outOps, JsonElement input) {
        if (input instanceof JsonObject) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof JsonArray) {
            return (U)this.convertList(outOps, input);
        }
        if (input instanceof JsonNull) {
            return (U)outOps.empty();
        }
        if (input instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)input;
            Object object = primitive.getValue();
            if (object instanceof String) {
                String string = (String)object;
                return (U)outOps.createString(string);
            }
            object = primitive.getValue();
            if (object instanceof Boolean) {
                Boolean bool = (Boolean)object;
                return (U)outOps.createBoolean(bool.booleanValue());
            }
            object = primitive.getValue();
            if (object instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)object;
                try {
                    long l = value.longValueExact();
                    if ((long)((byte)l) == l) {
                        return (U)outOps.createByte((byte)l);
                    }
                    if ((long)((short)l) == l) {
                        return (U)outOps.createShort((short)l);
                    }
                    if ((long)((int)l) == l) {
                        return (U)outOps.createInt((int)l);
                    }
                    return (U)outOps.createLong(l);
                }
                catch (ArithmeticException e) {
                    double d = value.doubleValue();
                    if ((double)((float)d) == d) {
                        return (U)outOps.createFloat((float)d);
                    }
                    return (U)outOps.createDouble(d);
                }
            }
        }
        return null;
    }

    public DataResult<Number> getNumberValue(JsonElement input) {
        Object object;
        JsonPrimitive primitive;
        if (input instanceof JsonPrimitive) {
            Object bool2;
            primitive = (JsonPrimitive)input;
            Object object2 = primitive.getValue();
            if (object2 instanceof Number) {
                Number number = (Number)object2;
                return DataResult.success((Object)number);
            }
            object2 = primitive.getValue();
            if (object2 instanceof Boolean) {
                Boolean bool2 = (Boolean)object2;
                return DataResult.success((Object)(bool2 != false ? 1 : 0));
            }
            if (this.compressed && (bool2 = primitive.getValue()) instanceof String) {
                String string = (String)bool2;
                try {
                    return DataResult.success((Object)Integer.parseInt(string));
                }
                catch (NumberFormatException e) {
                    return DataResult.error(() -> "Not a number: " + String.valueOf(e) + " " + String.valueOf(input));
                }
            }
        }
        if (input instanceof JsonPrimitive && (object = (primitive = (JsonPrimitive)input).getValue()) instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return DataResult.success((Object)(bool != false ? 1 : 0));
        }
        return DataResult.error(() -> "Not a number: " + String.valueOf(input));
    }

    public JsonElement createNumeric(Number i) {
        return new JsonPrimitive(i);
    }

    public DataResult<Boolean> getBooleanValue(JsonElement input) {
        if (input instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)input;
            Object object = primitive.getValue();
            if (object instanceof Boolean) {
                Boolean bool = (Boolean)object;
                return DataResult.success((Object)bool);
            }
            object = primitive.getValue();
            if (object instanceof Number) {
                Number number = (Number)object;
                return DataResult.success((Object)(number.byteValue() != 0 ? 1 : 0));
            }
        }
        return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
    }

    public JsonElement createBoolean(boolean value) {
        return new JsonPrimitive(value);
    }

    public DataResult<String> getStringValue(JsonElement input) {
        JsonPrimitive primitive;
        if (input instanceof JsonPrimitive && ((primitive = (JsonPrimitive)input).getValue() instanceof String || primitive.getValue() instanceof Number && this.compressed)) {
            return DataResult.success((Object)primitive.getValue().toString());
        }
        return DataResult.error(() -> "Not a string: " + String.valueOf(input));
    }

    public JsonElement createString(String value) {
        return new JsonPrimitive(value);
    }

    public DataResult<JsonElement> mergeToList(JsonElement list, JsonElement value) {
        if (!(list instanceof JsonArray) && list != this.empty()) {
            return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
        }
        JsonArray result = new JsonArray();
        if (list != this.empty()) {
            assert (list instanceof JsonArray);
            result.addAll((JsonArray)list);
        }
        result.add(value);
        return DataResult.success((Object)result);
    }

    public DataResult<JsonElement> mergeToList(JsonElement list, List<JsonElement> values) {
        if (!(list instanceof JsonArray) && list != this.empty()) {
            return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
        }
        JsonArray result = new JsonArray();
        if (list != this.empty()) {
            assert (list instanceof JsonArray);
            result.addAll((JsonArray)list);
        }
        values.forEach(result::add);
        return DataResult.success((Object)result);
    }

    public DataResult<JsonElement> mergeToMap(JsonElement map, JsonElement key, JsonElement value) {
        JsonPrimitive primitive;
        if (!(map instanceof JsonObject) && map != this.empty()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (!(key instanceof JsonPrimitive) || !((primitive = (JsonPrimitive)key).getValue() instanceof String) && !this.compressed) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
        }
        JsonObject output = new JsonObject();
        if (map != this.empty()) {
            assert (map instanceof JsonObject);
            JsonObject object = (JsonObject)map;
            output.putAll(object);
        }
        output.put(((JsonPrimitive)key).asString(), value);
        return DataResult.success((Object)output);
    }

    public DataResult<JsonElement> mergeToMap(JsonElement map, MapLike<JsonElement> values) {
        if (!(map instanceof JsonObject) && map != this.empty()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        JsonObject output = new JsonObject();
        if (map != this.empty()) {
            assert (map instanceof JsonObject);
            JsonObject object = (JsonObject)map;
            output.putAll(object);
        }
        ArrayList missed = Lists.newArrayList();
        values.entries().forEach(entry -> {
            JsonPrimitive primitive;
            JsonElement key = (JsonElement)entry.getFirst();
            if (!(key instanceof JsonPrimitive) || !((primitive = (JsonPrimitive)key).getValue() instanceof String) && !this.compressed) {
                missed.add(key);
                return;
            }
            output.put(((JsonPrimitive)key).asString(), (JsonElement)entry.getSecond());
        });
        if (!missed.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf(missed), (Object)output);
        }
        return DataResult.success((Object)output);
    }

    public DataResult<Stream<Pair<JsonElement, JsonElement>>> getMapValues(JsonElement input) {
        if (!(input instanceof JsonObject)) {
            return DataResult.error(() -> "Not a JSON object: " + String.valueOf(input));
        }
        JsonObject object = (JsonObject)input;
        return DataResult.success(object.entrySet().stream().map(entry -> Pair.of((Object)new JsonPrimitive(entry.getKey()), entry.getValue() instanceof JsonNull ? null : (JsonElement)entry.getValue())));
    }

    public DataResult<Consumer<BiConsumer<JsonElement, JsonElement>>> getMapEntries(JsonElement input) {
        if (!(input instanceof JsonObject)) {
            return DataResult.error(() -> "Not a JSON object: " + String.valueOf(input));
        }
        JsonObject object = (JsonObject)input;
        return DataResult.success(c -> {
            for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
                c.accept(this.createString(entry.getKey()), entry.getValue() instanceof JsonNull ? null : entry.getValue());
            }
        });
    }

    public DataResult<MapLike<JsonElement>> getMap(JsonElement input) {
        if (!(input instanceof JsonObject)) {
            return DataResult.error(() -> "Not a JSON object: " + String.valueOf(input));
        }
        final JsonObject object = (JsonObject)input;
        return DataResult.success((Object)new MapLike<JsonElement>(this){

            @Nullable
            public JsonElement get(JsonElement key) {
                JsonElement element = object.get(((JsonPrimitive)key).asString());
                if (element instanceof JsonNull) {
                    return null;
                }
                return element;
            }

            @Nullable
            public JsonElement get(String key) {
                JsonElement element = object.get(key);
                if (element instanceof JsonNull) {
                    return null;
                }
                return element;
            }

            public Stream<Pair<JsonElement, JsonElement>> entries() {
                return object.entrySet().stream().map(e -> Pair.of((Object)new JsonPrimitive(e.getKey()), (Object)((JsonElement)e.getValue())));
            }

            public String toString() {
                return "MapLike[" + String.valueOf(object) + "]";
            }
        });
    }

    public JsonElement createMap(Stream<Pair<JsonElement, JsonElement>> map) {
        JsonObject result = new JsonObject();
        map.forEach(p -> result.put(((JsonPrimitive)p.getFirst()).asString(), (JsonElement)p.getSecond()));
        return result;
    }

    public DataResult<Stream<JsonElement>> getStream(JsonElement input) {
        if (input instanceof JsonArray) {
            JsonArray array = (JsonArray)input;
            return DataResult.success(StreamSupport.stream(array.spliterator(), false).map(e -> e instanceof JsonNull ? null : e));
        }
        return DataResult.error(() -> "Not a json array: " + String.valueOf(input));
    }

    public DataResult<Consumer<Consumer<JsonElement>>> getList(JsonElement input) {
        if (input instanceof JsonArray) {
            JsonArray array = (JsonArray)input;
            return DataResult.success(c -> {
                for (JsonElement element : array) {
                    c.accept(element instanceof JsonNull ? null : element);
                }
            });
        }
        return DataResult.error(() -> "Not a json array: " + String.valueOf(input));
    }

    public JsonElement createList(Stream<JsonElement> input) {
        JsonArray result = new JsonArray();
        input.forEach(result::add);
        return result;
    }

    public JsonElement remove(JsonElement input, String key) {
        if (input instanceof JsonObject) {
            JsonObject object = (JsonObject)input;
            JsonObject result = new JsonObject();
            object.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(entry -> result.put((String)entry.getKey(), (JsonElement)entry.getValue()));
            return result;
        }
        return input;
    }

    public String toString() {
        return "JSON";
    }

    public ListBuilder<JsonElement> listBuilder() {
        return new ArrayBuilder();
    }

    public boolean compressMaps() {
        return this.compressed;
    }

    public RecordBuilder<JsonElement> mapBuilder() {
        return new JsonRecordBuilder(this);
    }

    private static final class ArrayBuilder
    implements ListBuilder<JsonElement> {
        private DataResult<JsonArray> builder = DataResult.success((Object)new JsonArray(), (Lifecycle)Lifecycle.stable());

        private ArrayBuilder() {
        }

        public DynamicOps<JsonElement> ops() {
            return INSTANCE;
        }

        public ListBuilder<JsonElement> add(JsonElement value) {
            this.builder = this.builder.map(b -> {
                b.add(value);
                return b;
            });
            return this;
        }

        public ListBuilder<JsonElement> add(DataResult<JsonElement> value) {
            this.builder = this.builder.apply2stable((b, element) -> {
                b.add((JsonElement)element);
                return b;
            }, value);
            return this;
        }

        public ListBuilder<JsonElement> withErrorsFrom(DataResult<?> result) {
            this.builder = this.builder.flatMap(r -> result.map(v -> r));
            return this;
        }

        public ListBuilder<JsonElement> mapError(UnaryOperator<String> onError) {
            this.builder = this.builder.mapError(onError);
            return this;
        }

        public DataResult<JsonElement> build(JsonElement prefix) {
            DataResult result = this.builder.flatMap(b -> {
                if (!(prefix instanceof JsonArray) && prefix != this.ops().empty()) {
                    return DataResult.error(() -> "Cannot append a list to not a list: " + String.valueOf(prefix), (Object)prefix);
                }
                JsonArray array = new JsonArray();
                if (prefix != this.ops().empty()) {
                    assert (prefix instanceof JsonArray);
                    array.addAll((JsonArray)prefix);
                }
                array.addAll((Collection<? extends JsonElement>)b);
                return DataResult.success((Object)array, (Lifecycle)Lifecycle.stable());
            });
            this.builder = DataResult.success((Object)new JsonArray(), (Lifecycle)Lifecycle.stable());
            return result;
        }
    }

    private class JsonRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<JsonElement, JsonObject> {
        protected JsonRecordBuilder(JanksonOps janksonOps) {
            super((DynamicOps)janksonOps);
        }

        protected JsonObject initBuilder() {
            return new JsonObject();
        }

        protected JsonObject append(String key, JsonElement value, JsonObject builder) {
            builder.put(key, value);
            return builder;
        }

        protected DataResult<JsonElement> build(JsonObject builder, JsonElement prefix) {
            if (prefix == null || prefix instanceof JsonNull) {
                return DataResult.success((Object)builder);
            }
            if (prefix instanceof JsonObject) {
                JsonObject object = (JsonObject)prefix;
                JsonObject result = new JsonObject();
                result.putAll(object);
                result.putAll(builder);
                return DataResult.success((Object)result);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(prefix), (Object)prefix);
        }
    }
}

